/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;

public class IconRotationMap {
    private final HashMap<BlockRotationHandler.RelativeSide, String> texNames = new HashMap();
    private final HashMap<BlockRotationHandler.RelativeSide, IIcon> icons = new HashMap();

    public void setIcon(BlockRotationHandler.IRotatableBlock block, BlockRotationHandler.RelativeSide side, String texName) {
        BlockRotationHandler.RotationType t = block.getRotationType();
        if (t == BlockRotationHandler.RotationType.NONE || side == BlockRotationHandler.RelativeSide.ANY_SIDE) {
            side = BlockRotationHandler.RelativeSide.ANY_SIDE;
        } else if (!t.getValidSides().contains((Object)side)) {
            throw new IllegalArgumentException(String.format("Invalid relative side for %s as %s", new Object[]{t, texName}));
        }
        this.texNames.put(side, texName);
    }

    public void registerIcons(IIconRegister register) {
        HashMap<String, IIcon> temp = new HashMap<String, IIcon>();
        for (Map.Entry<BlockRotationHandler.RelativeSide, String> entry : this.texNames.entrySet()) {
            IIcon icon;
            String name = entry.getValue();
            if (temp.containsKey(name)) {
                icon = (IIcon)temp.get(name);
            } else {
                icon = register.func_94245_a(name);
                temp.put(name, icon);
            }
            this.icons.put(entry.getKey(), icon);
        }
    }

    public IIcon getIcon(BlockRotationHandler.IRotatableBlock block, int meta, int side) {
        return this.getIcon(BlockRotationHandler.RelativeSide.getSideViewed(block.getRotationType(), meta, side));
    }

    public IIcon getIcon(BlockRotationHandler.RelativeSide side) {
        return this.icons.get((Object)side);
    }
}

