/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.container;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.item.ItemResearchBook;
import net.shadowmage.ancientwarfare.core.research.ResearchTracker;
import net.shadowmage.ancientwarfare.core.tile.TileResearchStation;

public class ContainerResearchStation
extends ContainerTileBase<TileResearchStation> {
    public boolean useAdjacentInventory;
    public String researcherName;
    public int currentGoal = -1;
    public int progress = 0;
    public List<Integer> queuedResearch = new ArrayList<Integer>();

    public ContainerResearchStation(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        this.researcherName = ((TileResearchStation)this.tileEntity).getCrafterName();
        this.useAdjacentInventory = ((TileResearchStation)this.tileEntity).useAdjacentInventory;
        if (!player.field_70170_p.field_72995_K && this.researcherName != null) {
            this.currentGoal = ResearchTracker.INSTANCE.getCurrentGoal(player.field_70170_p, this.researcherName);
            this.progress = ResearchTracker.INSTANCE.getProgress(player.field_70170_p, this.researcherName);
            this.queuedResearch.addAll(ResearchTracker.INSTANCE.getResearchQueueFor(player.field_70170_p, this.researcherName));
        }
        int slotNum = 0;
        Slot slot = new Slot((IInventory)this.tileEntity, slotNum, 8, 22){

            public boolean func_75214_a(ItemStack par1ItemStack) {
                return ItemResearchBook.getResearcherName(par1ItemStack) != null;
            }
        };
        this.func_75146_a(slot);
        int yBase = 98;
        for (int y1 = 0; y1 < 3; ++y1) {
            int y2 = y1 * 18 + yBase;
            for (int x1 = 0; x1 < 3; ++x1) {
                int x2 = x1 * 18 + 8 + 18;
                slot = new Slot((IInventory)this.tileEntity, ++slotNum, x2, y2);
                this.func_75146_a(slot);
            }
        }
        this.addPlayerSlots();
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotClickedIndex) {
        ItemStack slotStackCopy = null;
        Slot theSlot = this.func_75139_a(slotClickedIndex);
        if (theSlot != null && theSlot.func_75216_d()) {
            ItemStack slotStack = theSlot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            int playerSlotStart = ((TileResearchStation)this.tileEntity).func_70302_i_();
            int playerSlotEnd = playerSlotStart + this.playerSlots;
            if (slotClickedIndex < playerSlotStart ? !this.func_75135_a(slotStack, playerSlotStart, playerSlotEnd, false) : slotClickedIndex < playerSlotEnd && !this.func_75135_a(slotStack, 1, playerSlotStart, false)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                theSlot.func_75215_d(null);
            } else {
                theSlot.func_75218_e();
            }
            if (slotStack.field_77994_a == slotStackCopy.field_77994_a) {
                return null;
            }
            theSlot.func_82870_a(par1EntityPlayer, slotStack);
        }
        return slotStackCopy;
    }

    @Override
    public void sendInitData() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.researcherName != null) {
            tag.func_74778_a("researcherName", this.researcherName);
        } else {
            tag.func_74757_a("clearResearcher", true);
        }
        tag.func_74768_a("currentGoal", this.currentGoal);
        tag.func_74768_a("progress", this.progress);
        if (!this.queuedResearch.isEmpty()) {
            int[] queueData = new int[this.queuedResearch.size()];
            for (int i = 0; i < this.queuedResearch.size(); ++i) {
                queueData[i] = this.queuedResearch.get(i);
            }
            tag.func_74783_a("queuedResearch", queueData);
        }
        tag.func_74757_a("useAdjacentInventory", this.useAdjacentInventory);
        tag.func_74768_a("inventoryDirection", ((TileResearchStation)this.tileEntity).inventoryDirection.ordinal());
        tag.func_74768_a("inventorySide", ((TileResearchStation)this.tileEntity).inventorySide.ordinal());
        this.sendDataToClient(tag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("researcherName")) {
            this.researcherName = tag.func_74779_i("researcherName");
        } else if (tag.func_74764_b("clearResearcher")) {
            this.researcherName = null;
        }
        if (tag.func_74764_b("currentGoal")) {
            this.currentGoal = tag.func_74762_e("currentGoal");
        }
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
        if (tag.func_74764_b("queuedResearch")) {
            int[] data;
            this.queuedResearch.clear();
            for (int i : data = tag.func_74759_k("queuedResearch")) {
                this.queuedResearch.add(i);
            }
        }
        if (this.researcherName == null) {
            this.queuedResearch.clear();
            this.progress = 0;
            this.currentGoal = -1;
        }
        if (tag.func_74764_b("useAdjacentInventory")) {
            this.useAdjacentInventory = tag.func_74767_n("useAdjacentInventory");
            if (!this.player.field_70170_p.field_72995_K) {
                ((TileResearchStation)this.tileEntity).useAdjacentInventory = this.useAdjacentInventory;
            }
        }
        if (tag.func_74764_b("inventoryDirection")) {
            ((TileResearchStation)this.tileEntity).inventoryDirection = ForgeDirection.getOrientation((int)tag.func_74762_e("inventoryDirection"));
        }
        if (tag.func_74764_b("inventorySide")) {
            ((TileResearchStation)this.tileEntity).inventorySide = ForgeDirection.getOrientation((int)tag.func_74762_e("inventorySide"));
        }
        if (!this.player.field_70170_p.field_72995_K) {
            ((TileResearchStation)this.tileEntity).func_70296_d();
        }
        this.refreshGui();
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        ((TileResearchStation)this.tileEntity).addTorque(ForgeDirection.UNKNOWN, AWCoreStatics.researchPerTick);
        NBTTagCompound tag = null;
        String name = ((TileResearchStation)this.tileEntity).getCrafterName();
        if (name != null || this.researcherName != null) {
            if (name == null) {
                tag = new NBTTagCompound();
                this.researcherName = null;
                tag.func_74757_a("clearResearcher", true);
                tag.func_74768_a("currentGoal", -1);
                tag.func_74768_a("progress", 0);
            } else if (this.researcherName == null || !name.equals(this.researcherName)) {
                tag = new NBTTagCompound();
                this.researcherName = name;
                tag.func_74778_a("researcherName", name);
                this.currentGoal = ResearchTracker.INSTANCE.getCurrentGoal(this.player.field_70170_p, this.researcherName);
                tag.func_74768_a("currentGoal", this.currentGoal);
                this.progress = ResearchTracker.INSTANCE.getProgress(this.player.field_70170_p, this.researcherName);
                tag.func_74768_a("progress", this.progress);
            } else {
                int p;
                int g = ResearchTracker.INSTANCE.getCurrentGoal(this.player.field_70170_p, this.researcherName);
                if (g != this.currentGoal) {
                    tag = new NBTTagCompound();
                    this.currentGoal = g;
                    tag.func_74768_a("currentGoal", this.currentGoal);
                }
                if ((p = ResearchTracker.INSTANCE.getProgress(this.player.field_70170_p, this.researcherName)) != this.progress) {
                    if (tag == null) {
                        tag = new NBTTagCompound();
                    }
                    this.progress = p;
                    tag.func_74768_a("progress", this.progress);
                }
            }
        }
        if (this.researcherName != null) {
            List<Integer> queue = ResearchTracker.INSTANCE.getResearchQueueFor(this.player.field_70170_p, this.researcherName);
            if (!queue.equals(this.queuedResearch)) {
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                this.queuedResearch.clear();
                this.queuedResearch.addAll(queue);
                int[] queueData = new int[queue.size()];
                for (int i = 0; i < queue.size(); ++i) {
                    queueData[i] = queue.get(i);
                }
                tag.func_74783_a("queuedResearch", queueData);
            }
        } else {
            this.queuedResearch.clear();
        }
        if (((TileResearchStation)this.tileEntity).useAdjacentInventory != this.useAdjacentInventory) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.useAdjacentInventory = ((TileResearchStation)this.tileEntity).useAdjacentInventory;
            tag.func_74757_a("useAdjacentInventory", this.useAdjacentInventory);
        }
        if (tag != null) {
            this.sendDataToClient(tag);
        }
    }

    public void toggleUseAdjacentInventory() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("useAdjacentInventory", !this.useAdjacentInventory);
        this.useAdjacentInventory = !this.useAdjacentInventory;
        this.sendDataToServer(tag);
    }

    public void onSidePressed() {
        int o = (((TileResearchStation)this.tileEntity).inventorySide.ordinal() + 1) % ForgeDirection.VALID_DIRECTIONS.length;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("inventorySide", o);
        this.sendDataToServer(tag);
        ((TileResearchStation)this.tileEntity).inventorySide = ForgeDirection.getOrientation((int)o);
    }

    public void onDirPressed() {
        int o = (((TileResearchStation)this.tileEntity).inventoryDirection.ordinal() + 1) % ForgeDirection.VALID_DIRECTIONS.length;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("inventoryDirection", o);
        this.sendDataToServer(tag);
        ((TileResearchStation)this.tileEntity).inventoryDirection = ForgeDirection.getOrientation((int)o);
    }
}

