/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.crafting;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.crafting.RecipeResearched;
import net.shadowmage.ancientwarfare.core.crafting.UnformedRecipeResearched;
import net.shadowmage.ancientwarfare.core.interfaces.IResearchRecipe;
import net.shadowmage.ancientwarfare.core.research.ResearchTracker;
import net.shadowmage.ancientwarfare.core.util.StringTools;

public class AWCraftingManager {
    private static final String[] singleInputArray = new String[]{""};
    public static final AWCraftingManager INSTANCE = new AWCraftingManager();
    private final List<IResearchRecipe> recipes = new ArrayList<IResearchRecipe>();

    private AWCraftingManager() {
    }

    public ItemStack findMatchingRecipe(InventoryCrafting inventory, World world, String playerName) {
        if (world == null) {
            return null;
        }
        if (playerName != null && !playerName.isEmpty()) {
            for (IResearchRecipe recipe : this.recipes) {
                if (!recipe.func_77569_a(inventory, world) || !this.canPlayerCraft(recipe, world, playerName)) continue;
                return recipe.func_77572_b(inventory);
            }
        }
        return CraftingManager.func_77594_a().func_82787_a(inventory, world);
    }

    private boolean canPlayerCraft(IResearchRecipe recipe, World world, String playerName) {
        if (AWCoreStatics.useResearchSystem) {
            for (Integer i : recipe.getNeededResearch()) {
                if (ResearchTracker.INSTANCE.hasPlayerCompleted(world, playerName, i)) continue;
                return false;
            }
        }
        return true;
    }

    private void addRecipe(IResearchRecipe recipe) {
        Item item = recipe.func_77571_b().func_77973_b();
        if (AWCoreStatics.isItemCraftable(item)) {
            if (!recipe.getNeededResearch().isEmpty() && AWCoreStatics.isItemResearched(item)) {
                this.recipes.add(recipe);
            } else {
                GameRegistry.addRecipe((IRecipe)recipe);
            }
        }
    }

    public void parseRecipes(String path) {
        List<String> lines = StringTools.getResourceLines(path);
        for (String line : lines) {
            ItemStack stack;
            String[] split = StringTools.parseStringArray(line);
            if (split.length < 5 || (stack = StringTools.safeParseStack(split[1], split[2], split[3])) == null) continue;
            boolean shaped = true;
            if (split.length < 7 || split[4].length() > 3) {
                shaped = false;
            }
            Object[] craft_par = new Object[split.length - 4];
            int i = 4;
            while (split[i].length() > 0 && split[i + 1].length() < 4) {
                craft_par[i - 4] = split[i];
                ++i;
            }
            while (i < split.length) {
                if (shaped) {
                    craft_par[i - 4] = Character.valueOf(split[i].charAt(0));
                } else {
                    --i;
                }
                if (split[i + 1].startsWith("(") && split[i + 3].endsWith(")")) {
                    craft_par[i - 3] = StringTools.safeParseStack(split[i + 1].substring(1), split[i + 2], split[i + 3].substring(0, split[i + 3].length() - 1));
                    i += 2;
                } else {
                    Object crafting_item = GameData.getItemRegistry().func_82594_a(split[i + 1]);
                    if (crafting_item == GameData.getItemRegistry().getDefaultValue() && (crafting_item = GameData.getBlockRegistry().func_82594_a(split[i + 1])) == GameData.getBlockRegistry().getDefaultValue()) {
                        crafting_item = split[i + 1];
                    }
                    craft_par[i - 3] = crafting_item;
                }
                i += 2;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object object : craft_par) {
                if (object == null) continue;
                list.add(object);
            }
            try {
                this.createRecipe(shaped, stack, split[0].trim(), list.toArray());
            }
            catch (Throwable throwable) {
                AWLog.logError("Error creating recipe for parsed line: " + line);
            }
        }
    }

    public void createRecipe(ItemStack result, String research, Object ... inputArray) {
        this.createRecipe(true, result, research, inputArray);
    }

    public void createRecipe(boolean shaped, ItemStack result, String research, Object ... inputArray) {
        if (research == null || research.isEmpty()) {
            this.createRecipe(shaped, result, inputArray);
        } else {
            AWCraftingManager.singleInputArray[0] = research;
            this.createRecipe(shaped, result, singleInputArray, inputArray);
        }
    }

    private void createRecipe(boolean shaped, ItemStack result, Object[] inputArray) {
        if (AWCoreStatics.isItemCraftable(result.func_77973_b())) {
            ShapedOreRecipe recipe = shaped ? new ShapedOreRecipe(result, inputArray) : new ShapelessOreRecipe(result, inputArray);
            GameRegistry.addRecipe((IRecipe)recipe);
        }
    }

    public IResearchRecipe createRecipe(boolean shaped, ItemStack result, String[] research, Object ... inputArray) {
        IResearchRecipe recipe = shaped ? new RecipeResearched(result, inputArray) : new UnformedRecipeResearched(result, inputArray);
        this.addRecipe(recipe.addResearch(research));
        return recipe;
    }

    public List<IResearchRecipe> getRecipes() {
        return this.recipes;
    }
}

