/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.crafting;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.shadowmage.ancientwarfare.core.interfaces.IResearchRecipe;
import net.shadowmage.ancientwarfare.core.research.ResearchGoal;

public class UnformedRecipeResearched
extends ShapelessOreRecipe
implements IResearchRecipe {
    private final Set<Integer> neededResearch = new HashSet<Integer>();

    public UnformedRecipeResearched(ItemStack result, Object ... recipe) {
        super(result, recipe);
    }

    @Override
    public Set<Integer> getNeededResearch() {
        return this.neededResearch;
    }

    @Override
    public int getRecipeHeight() {
        int sqrt = (int)Math.sqrt(this.func_77570_a());
        int diff = this.func_77570_a() - sqrt * sqrt;
        if (diff != 0) {
            return sqrt + 1;
        }
        return sqrt;
    }

    @Override
    public int getRecipeWidth() {
        int h = this.getRecipeHeight();
        for (int i = 1; i < h + 2; ++i) {
            if (h * i < this.func_77570_a()) continue;
            return i;
        }
        return h + 2;
    }

    @Override
    public IResearchRecipe addResearch(String ... names) {
        for (String name : names) {
            name = name.startsWith("research.") ? name : "research." + name;
            ResearchGoal g = ResearchGoal.getGoal(name);
            if (g == null) {
                throw new IllegalArgumentException("COULD NOT LOCATE RESEARCH GOAL FOR NAME: " + name);
            }
            this.neededResearch.add(g.getId());
        }
        return this;
    }

    @Override
    public Object[] getInputs() {
        return this.getInput().toArray();
    }
}

