/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gamedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.WorldSavedData;
import net.shadowmage.ancientwarfare.core.util.Zone;

public class WarzoneSaveData
extends WorldSavedData {
    private final List<WarZone> warZones = new ArrayList<WarZone>();

    public WarzoneSaveData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound tag) {
        NBTTagList warzoneList = tag.func_150295_c("wars", 10);
        this.warZones.clear();
        for (int i = 0; i < warzoneList.func_74745_c(); ++i) {
            NBTTagCompound entryTag = warzoneList.func_150305_b(i);
            WarZone zone = new WarZone();
            zone.readFromNBT(entryTag);
            this.warZones.add(zone);
        }
    }

    public void func_76187_b(NBTTagCompound tag) {
        NBTTagList warzoneList = new NBTTagList();
        for (Zone zone : this.warZones) {
            warzoneList.func_74742_a((NBTBase)zone.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("wars", (NBTBase)warzoneList);
    }

    public boolean isPositionAtWar(int x, int y, int z) {
        for (Zone zone : this.warZones) {
            if (!zone.isPositionIn(x, y, z)) continue;
            return true;
        }
        return false;
    }

    public boolean startWar(Zone start, UUID ... ids) {
        WarZone war = new WarZone(start, ids);
        if (!war.isClear()) {
            for (WarZone zone : this.warZones) {
                if (!zone.isPositionIn(war.min) || !zone.isPositionIn(war.max) || !zone.canAddParts(ids)) continue;
                this.func_76185_a();
                return false;
            }
            if (this.warZones.add(war)) {
                this.func_76185_a();
                return true;
            }
        }
        return false;
    }

    public boolean clearPartInWar(Zone zone, UUID id) {
        for (WarZone z : this.warZones) {
            if (!z.equals(zone)) continue;
            if (z.clearPart(id)) {
                this.func_76185_a();
                if (z.isClear()) {
                    this.warZones.remove(z);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private class WarZone
    extends Zone {
        private final List<UUID> generals;

        public WarZone(Zone zone, UUID ... general) {
            super(zone.min, zone.max);
            this.generals = new ArrayList<UUID>();
            for (UUID id : general) {
                this.generals.add(id);
            }
        }

        public WarZone() {
            this.generals = new ArrayList<UUID>();
        }

        public boolean clearPart(UUID id) {
            return this.generals.remove(id);
        }

        public boolean isClear() {
            return this.generals.size() < 2;
        }

        public boolean canAddParts(UUID ... ids) {
            List<UUID> list = Arrays.asList(ids);
            int size = list.size();
            for (UUID id : ids) {
                if (!this.generals.contains(id)) continue;
                list.remove(id);
            }
            if (list.size() < size) {
                if (list.size() > 0) {
                    this.generals.addAll(list);
                }
                return true;
            }
            return false;
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            super.readFromNBT(tag);
            NBTTagList genList = tag.func_150295_c("parts", 8);
            this.generals.clear();
            for (int i = 0; i < genList.func_74745_c(); ++i) {
                String entryTag = genList.func_150307_f(i);
                this.generals.add(UUID.fromString(entryTag));
            }
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            NBTTagList genList = new NBTTagList();
            for (UUID id : this.generals) {
                genList.func_74742_a((NBTBase)new NBTTagString(id.toString()));
            }
            tag.func_74782_a("parts", (NBTBase)genList);
            return super.writeToNBT(tag);
        }

        @Override
        public String toString() {
            return String.format("From %s to %s involving %s", this.min, this.max, this.generals);
        }
    }
}

