/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Tooltip;
import net.shadowmage.ancientwarfare.core.interfaces.ITooltipRenderer;

public abstract class GuiElement {
    private List<Listener> actionListeners = new ArrayList<Listener>();
    protected boolean mouseInterface;
    protected boolean keyboardInterface;
    protected boolean enabled;
    protected boolean visible;
    protected boolean selected;
    protected boolean scrollInput = false;
    protected Tooltip tooltip;
    protected long hoverStart;
    protected int topLeftX;
    protected int topLeftY;
    protected int renderX;
    protected int renderY;
    protected int width;
    protected int height;
    public static final ResourceLocation backgroundTextureLocation = new ResourceLocation("ancientwarfare", "textures/gui/guiBackgroundLarge.png");
    public static final ResourceLocation widgetTexture1 = new ResourceLocation("ancientwarfare", "textures/gui/guiButtons1.png");
    public static final ResourceLocation widgetTexture2 = new ResourceLocation("ancientwarfare", "textures/gui/guiButtons2.png");

    public GuiElement(int topLeftX, int topLeftY) {
        this.topLeftX = topLeftX;
        this.topLeftY = topLeftY;
        this.enabled = true;
        this.visible = true;
    }

    public GuiElement(int topLeftX, int topLeftY, int width, int height) {
        this(topLeftX, topLeftY);
        this.width = width;
        this.height = height;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setScrollable(boolean handleScroll) {
        this.scrollInput = handleScroll;
    }

    public void updateGuiPosition(int guiLeft, int guiTop) {
        this.renderX = this.topLeftX + guiLeft;
        this.renderY = this.topLeftY + guiTop;
    }

    public void setRenderPosition(int topLeftX, int topLeftY) {
        this.topLeftX = topLeftX;
        this.topLeftY = topLeftY;
    }

    public final void handleMouseInput(GuiContainerBase.ActivationEvent evt) {
        if (this.mouseInterface && this.visible && this.enabled && !this.actionListeners.isEmpty()) {
            for (Listener o : this.actionListeners) {
                if ((o.type & evt.type) == 0 || o.onEvent(this, evt)) continue;
                break;
            }
        }
    }

    public final void handleKeyboardInput(GuiContainerBase.ActivationEvent evt) {
        if (this.keyboardInterface && this.visible && this.enabled && !this.actionListeners.isEmpty()) {
            for (Listener o : this.actionListeners) {
                if ((o.type & evt.type) == 0 || o.onEvent(this, evt)) continue;
                break;
            }
        }
    }

    public final void addNewListener(Listener listener) {
        this.actionListeners.add(listener);
        if ((listener.type & 0x3C) != 0) {
            this.mouseInterface = true;
        }
        if ((listener.type & 3) != 0) {
            this.keyboardInterface = true;
        }
    }

    public final boolean isMouseOverElement(int mouseX, int mouseY) {
        return mouseX >= this.renderX && mouseX < this.renderX + this.width && mouseY >= this.renderY && mouseY < this.renderY + this.height;
    }

    public abstract void render(int var1, int var2, float var3);

    public void postRender(int mouseX, int mouseY, float partialTick, long tick, ITooltipRenderer rend) {
        if (this.tooltip == null) {
            return;
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.hoverStart == -1L) {
                this.hoverStart = tick;
            } else if (tick - this.hoverStart > 500L) {
                rend.handleElementTooltipRender(this.tooltip);
            }
        } else {
            this.hoverStart = -1L;
        }
    }

    public void setTooltip(Tooltip tip) {
        this.tooltip = tip;
    }

    public boolean selected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

