/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Tooltip;
import net.shadowmage.ancientwarfare.core.interfaces.ITooltipRenderer;
import net.shadowmage.ancientwarfare.core.util.RenderTools;
import org.lwjgl.opengl.GL11;

public class ItemSlot
extends GuiElement {
    protected static RenderItem itemRender = new RenderItem();
    private ItemStack item;
    protected ITooltipRenderer render;
    protected boolean highlightOnMouseOver = true;
    protected boolean renderTooltip = true;
    protected boolean renderItemQuantity = true;
    protected boolean renderSlotBackground = true;
    protected boolean renderLabel = false;

    public ItemSlot(int topLeftX, int topLeftY, ItemStack item, ITooltipRenderer render) {
        super(topLeftX - 1, topLeftY - 1, 18, 18);
        this.item = item;
        this.render = render;
        Listener listener = new Listener(8){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
                    ItemSlot.this.onSlotClicked(stack);
                }
                return true;
            }
        };
        this.addNewListener(listener);
    }

    public void addTooltip(String text) {
        if (this.tooltip == null) {
            this.tooltip = new Tooltip(Minecraft.func_71410_x().field_71466_p.func_78256_a(text), 10);
        }
        this.tooltip.addTooltipElement(new Label(0, 0, text));
        this.renderTooltip = true;
    }

    public void setRenderLabel(boolean val) {
        this.renderLabel = val;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ItemSlot setRenderTooltip(boolean val) {
        this.renderTooltip = val;
        return this;
    }

    public ItemSlot setRenderItemQuantity(boolean val) {
        this.renderItemQuantity = val;
        return this;
    }

    public ItemSlot setHighlightOnMouseOver(boolean val) {
        this.highlightOnMouseOver = val;
        return this;
    }

    public ItemSlot setRenderSlotBackground(boolean val) {
        this.renderSlotBackground = val;
        return this;
    }

    public ItemStack getStack() {
        return this.item;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            GL11.glPushAttrib((int)8192);
            Minecraft mc = Minecraft.func_71410_x();
            if (this.renderSlotBackground) {
                mc.field_71446_o.func_110577_a(widgetTexture1);
                RenderTools.renderQuarteredTexture(256, 256, 152, 120, 18, 18, this.renderX, this.renderY, this.width, this.height);
            }
            GL11.glDisable((int)2929);
            if (this.item != null && this.item.func_77973_b() != null) {
                RenderHelper.func_74520_c();
                ItemSlot.itemRender.field_77023_b = 10.0f;
                FontRenderer font = this.item.func_77973_b().getFontRenderer(this.item);
                if (font == null) {
                    font = mc.field_71466_p;
                }
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                itemRender.func_82406_b(font, mc.func_110434_K(), this.item, this.renderX + 1, this.renderY + 1);
                GL11.glDisable((int)2929);
                if (this.renderItemQuantity && this.item.field_77994_a > 1) {
                    itemRender.func_94148_a(font, mc.func_110434_K(), this.item, this.renderX + 1, this.renderY + 1, "");
                    this.renderStackSize(this.renderX + 1, this.renderY + 1, this.item.field_77994_a, font);
                }
                GL11.glDisable((int)2896);
                if (this.renderLabel) {
                    int x = this.renderX + 18;
                    int y = this.renderY + 3;
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    font.func_78261_a(this.item.func_82833_r(), x, y, -1);
                }
            }
            if (this.isMouseOverElement(mouseX, mouseY)) {
                if (this.highlightOnMouseOver) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)3553);
                    GL11.glBegin((int)7);
                    GL11.glVertex2f((float)this.renderX, (float)this.renderY);
                    GL11.glVertex2f((float)this.renderX, (float)(this.renderY + this.height));
                    GL11.glVertex2f((float)(this.renderX + this.width), (float)(this.renderY + this.height));
                    GL11.glVertex2d((double)(this.renderX + this.width), (double)this.renderY);
                    GL11.glEnd();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)3553);
                }
                if (this.renderTooltip && this.render != null) {
                    if (this.tooltip != null) {
                        this.render.handleElementTooltipRender(this.tooltip);
                    } else if (this.item != null) {
                        this.render.handleItemStackTooltipRender(this.item);
                    }
                }
            }
            GL11.glEnable((int)2929);
            GL11.glDisable((int)2896);
            GL11.glPopAttrib();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void renderStackSize(int renderX, int renderY, int stackSize, FontRenderer fr) {
        GL11.glPushMatrix();
        float ox = renderX + 16;
        float oy = renderY + 8;
        GL11.glTranslatef((float)(ox + 0.5f), (float)(oy + 0.5f), (float)0.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3042);
        String s1 = String.valueOf(stackSize);
        float w = fr.func_78256_a(s1);
        float scale = stackSize > 99 ? 0.5f : 1.0f;
        int oy1 = stackSize > 99 ? 6 : 0;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        fr.func_78261_a(s1, -((int)w), oy1, 0xFFFFFF);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public void onSlotClicked(ItemStack stack) {
    }
}

