/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.interfaces.IScrollableCallback;
import net.shadowmage.ancientwarfare.core.util.RenderTools;

public class Scrollbar
extends GuiElement {
    static final int borderSize = 4;
    int totalAreaSize;
    int viewSize;
    float viewPercent;
    int handleTopMax;
    int handleTop;
    int handleWidth;
    int handleHeight;
    boolean pressed;
    boolean dragging;
    int lastMouseY;
    int topIndex;
    private IScrollableCallback parent;

    public Scrollbar(int topLeftX, int topLeftY, int width, int height, IScrollableCallback parentCaller) {
        super(topLeftX, topLeftY, width, height);
        this.viewSize = height - 8;
        this.handleTop = 0;
        this.handleHeight = this.viewSize;
        this.handleWidth = width - 8;
        this.setAreaSize(height);
        this.parent = parentCaller;
        this.addNewListener(new Listener(32){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (Scrollbar.this.dragging) {
                    int dy = evt.my - Scrollbar.this.lastMouseY;
                    Scrollbar.this.handleTop += dy;
                    Scrollbar.this.lastMouseY = evt.my;
                    Scrollbar.this.updateHandlePosition();
                }
                return true;
            }
        });
        this.addNewListener(new Listener(8){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                Scrollbar.this.dragging = false;
                Scrollbar.this.pressed = false;
                Scrollbar.this.lastMouseY = evt.my;
                if (Scrollbar.this.isMouseOverHandle(evt.mx, evt.my)) {
                    Scrollbar.this.dragging = true;
                } else if (Scrollbar.this.isMouseOverElement(evt.mx, evt.my)) {
                    Scrollbar.this.pressed = true;
                }
                return true;
            }
        });
        this.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (Scrollbar.this.enabled && Scrollbar.this.visible && Scrollbar.this.pressed && Scrollbar.this.isMouseOverElement(evt.mx, evt.my) && !Scrollbar.this.isMouseOverHandle(evt.mx, evt.my)) {
                    Scrollbar.this.handleTop = evt.my < Scrollbar.this.renderY + 4 + Scrollbar.this.handleTop ? (Scrollbar.this.handleTop -= Scrollbar.this.handleHeight) : (Scrollbar.this.handleTop += Scrollbar.this.handleHeight);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    Scrollbar.this.updateHandlePosition();
                }
                Scrollbar.this.dragging = false;
                Scrollbar.this.pressed = false;
                return true;
            }
        });
        this.addNewListener(new Listener(16){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    Scrollbar.this.handleTop -= evt.mw / 10;
                    Scrollbar.this.updateHandlePosition();
                }
                return true;
            }
        });
    }

    protected boolean isMouseOverHandle(int mouseX, int mouseY) {
        return mouseX >= this.renderX + 4 && mouseX < this.renderX + this.width - 4 && mouseY >= this.renderY + 4 + this.handleTop && mouseY < this.renderY + 4 + this.handleTop + this.handleHeight;
    }

    public void setAreaSize(int size) {
        this.totalAreaSize = size;
        this.viewPercent = (float)this.viewSize / (float)this.totalAreaSize;
        if (this.viewPercent > 1.0f) {
            this.viewPercent = 1.0f;
        }
        this.updateHandlePosition();
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(widgetTexture1);
            RenderTools.renderQuarteredTexture(256, 256, 80, 120, 40, 128, this.renderX, this.renderY, this.width, this.height);
            RenderTools.renderQuarteredTexture(256, 256, 120, 120, 32, 128, this.renderX + 4, this.renderY + 4 + this.handleTop, this.handleWidth, this.handleHeight);
        }
    }

    protected void updateHandlePosition() {
        this.handleHeight = (int)((float)this.viewSize * this.viewPercent);
        this.handleTopMax = this.viewSize - this.handleHeight;
        if (this.handleTop > this.handleTopMax) {
            this.handleTop = this.handleTopMax;
        }
        if (this.handleTop < 0) {
            this.handleTop = 0;
        }
        if (this.parent != null) {
            this.topIndex = (int)((float)this.handleTop * (1.0f / this.viewPercent));
            this.parent.onScrolled(this.topIndex);
        }
    }

    public int getTopIndex() {
        return this.topIndex;
    }
}

