/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.research;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.container.ContainerResearchStation;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Tooltip;
import net.shadowmage.ancientwarfare.core.gui.research.GuiResearchStation;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketResearchUpdate;
import net.shadowmage.ancientwarfare.core.research.ResearchGoal;
import net.shadowmage.ancientwarfare.core.research.ResearchTracker;
import org.lwjgl.input.Mouse;

public class GuiResearchStationSelection
extends GuiContainerBase<ContainerResearchStation> {
    private final GuiResearchStation parent;
    private CompositeScrolled queueArea;
    private CompositeScrolled selectionArea;

    public GuiResearchStationSelection(GuiResearchStation parent, int x, int y) {
        super((ContainerBase)((Object)parent.getContainer()), 400, 240);
        this.parent = parent;
        Mouse.setCursorPosition((int)x, (int)y);
    }

    @Override
    public void initElements() {
        this.queueArea = new CompositeScrolled(this, 0, 40, 200, 200);
        this.addGuiElement(this.queueArea);
        this.selectionArea = new CompositeScrolled(this, 200, 40, 200, 200);
        this.addGuiElement(this.selectionArea);
        Label label = new Label(8, 8, "guistrings.research.queued_research");
        this.addGuiElement(label);
        label = new Label(248, 8, "guistrings.research.learnable_research");
        this.addGuiElement(label);
    }

    @Override
    public void setupElements() {
        this.selectionArea.clearElements();
        this.queueArea.clearElements();
        int goal = ((ContainerResearchStation)((Object)this.getContainer())).currentGoal;
        int totalHeight = 8;
        if (goal >= 0) {
            totalHeight = this.addQueuedGoal(totalHeight, goal, false);
        }
        for (Integer g : ((ContainerResearchStation)((Object)this.getContainer())).queuedResearch) {
            totalHeight = this.addQueuedGoal(totalHeight, g, true);
        }
        this.queueArea.setAreaSize(totalHeight + 8);
        totalHeight = 8;
        if (((ContainerResearchStation)((Object)this.getContainer())).researcherName != null) {
            for (Integer g : ResearchTracker.INSTANCE.getResearchableGoals(this.player.field_70170_p, ((ContainerResearchStation)((Object)this.getContainer())).researcherName)) {
                totalHeight = this.addSelectableGoal(totalHeight, g);
            }
        }
        this.selectionArea.setAreaSize(totalHeight + 8);
    }

    private int addQueuedGoal(int totalHeight, int goalNumber, boolean removeButton) {
        ResearchGoal g = ResearchGoal.getGoal(goalNumber);
        if (g == null) {
            return totalHeight;
        }
        String name = StatCollector.func_74838_a((String)g.getName());
        if (!removeButton) {
            name = name + " (" + StatCollector.func_74838_a((String)"guistrings.research.current_goal") + ")";
        }
        Label label = new Label(8, totalHeight + 1, name);
        this.queueArea.addGuiElement(label);
        Tooltip selectableGoalTooltip = this.createGoal(label, g);
        if (removeButton) {
            GoalButton button = new GoalButton(168, totalHeight, 12, 12, g, false);
            button.setTooltip(selectableGoalTooltip);
            this.queueArea.addGuiElement(button);
        }
        return totalHeight + 12;
    }

    private int addSelectableGoal(int totalHeight, int goalNumber) {
        ResearchGoal g = ResearchGoal.getGoal(goalNumber);
        if (g == null) {
            return totalHeight;
        }
        Label label = new Label(8, totalHeight + 1, g.getName());
        this.selectionArea.addGuiElement(label);
        GoalButton button = new GoalButton(168, totalHeight, 12, 12, g, true);
        button.setTooltip(this.createGoal(label, g));
        this.selectionArea.addGuiElement(button);
        return totalHeight + 12;
    }

    private Tooltip createGoal(Label label, ResearchGoal g) {
        Tooltip selectableGoalTooltip = new Tooltip(110, 75);
        selectableGoalTooltip.addTooltipElement(new Label(0, 0, StatCollector.func_74837_a((String)"guistrings.research.research_time", (Object[])new Object[]{g.getTotalResearchTime()})));
        selectableGoalTooltip.addTooltipElement(new Label(0, 10, "guistrings.research.resources_needed"));
        int x = 0;
        int y = 0;
        for (ItemStack stack : g.getResources()) {
            selectableGoalTooltip.addTooltipElement(new ItemSlot(x * 18, y * 18 + 20, stack, this));
            if (++x <= 2) continue;
            x = 0;
            ++y;
        }
        label.setTooltip(selectableGoalTooltip);
        return selectableGoalTooltip;
    }

    @Override
    protected boolean onGuiCloseRequested() {
        this.parent.refreshGui();
        ((ContainerResearchStation)((Object)this.getContainer())).setGui(this.parent);
        ((ContainerResearchStation)((Object)this.getContainer())).addSlots();
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        return false;
    }

    private class GoalButton
    extends Button {
        final ResearchGoal goal;
        final boolean add;

        public GoalButton(int topLeftX, int topLeftY, int width, int height, ResearchGoal goal, boolean add) {
            super(topLeftX, topLeftY, width, height, add ? "+" : "-");
            this.goal = goal;
            this.add = add;
        }

        @Override
        protected void onPressed() {
            PacketResearchUpdate pkt = new PacketResearchUpdate(((ContainerResearchStation)((Object)GuiResearchStationSelection.this.getContainer())).researcherName, this.goal.getId(), this.add, false);
            NetworkHandler.sendToServer(pkt);
        }
    }
}

