/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;

public class ItemQuantityMap {
    private final Map<ItemHashEntry, Integer> map = new HashMap<ItemHashEntry, Integer>();

    public void putAll(ItemQuantityMap incoming) {
        for (ItemHashEntry entry : incoming.map.keySet()) {
            this.map.put(entry, incoming.map.get(entry));
        }
    }

    public void addAll(ItemQuantityMap incoming) {
        for (ItemHashEntry entry : incoming.map.keySet()) {
            if (this.map.containsKey(entry)) {
                this.map.put(entry, this.map.get(entry) + incoming.getCount(entry));
                continue;
            }
            this.map.put(entry, incoming.map.get(entry));
        }
    }

    public void removeAll(ItemQuantityMap toRemove) {
        for (ItemHashEntry entry : toRemove.map.keySet()) {
            this.remove(entry);
        }
    }

    public void removeAll(Collection<ItemHashEntry> entries) {
        for (ItemHashEntry entry : entries) {
            this.remove(entry);
        }
    }

    public void decreaseQuantitiesFor(ItemQuantityMap toRemove) {
        for (ItemHashEntry entry : toRemove.map.keySet()) {
            if (!this.contains(entry)) continue;
            this.decreaseCount(entry, toRemove.getCount(entry));
        }
    }

    public int getCount(ItemHashEntry entry) {
        if (this.map.containsKey(entry)) {
            return this.map.get(entry);
        }
        return 0;
    }

    public int getCount(ItemStack item) {
        return this.getCount(new ItemHashEntry(item));
    }

    public void addCount(ItemStack item, int count) {
        this.addCount(new ItemHashEntry(item), count);
    }

    public void addCount(ItemHashEntry entry, int count) {
        if (!this.map.containsKey(entry)) {
            this.map.put(entry, count);
        } else {
            this.map.put(entry, this.map.get(entry) + count);
        }
    }

    public void decreaseCount(ItemStack item, int count) {
        this.decreaseCount(new ItemHashEntry(item), count);
    }

    public void decreaseCount(ItemHashEntry entry, int count) {
        if (this.map.containsKey(entry)) {
            int itemCount = this.map.get(entry) - count;
            if (itemCount <= 0) {
                this.map.remove(entry);
            } else {
                this.map.put(entry, itemCount);
            }
        }
    }

    public void remove(ItemStack item) {
        this.remove(new ItemHashEntry(item));
    }

    public void remove(ItemHashEntry entry) {
        this.map.remove(entry);
    }

    public void put(ItemStack item, int count) {
        this.put(new ItemHashEntry(item), count);
    }

    public void put(ItemHashEntry wrap, int count) {
        this.map.put(wrap, count);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<ItemHashEntry> keySet() {
        return this.map.keySet();
    }

    public boolean contains(ItemHashEntry entry) {
        return this.map.containsKey(entry);
    }

    public boolean contains(ItemStack item) {
        return this.contains(new ItemHashEntry(item));
    }

    public String toString() {
        String out = "Item Quantity Map:";
        for (ItemHashEntry wrap : this.map.keySet()) {
            out = out + "\n   " + wrap.item.func_77658_a();
            out = out + " : " + this.map.get(wrap);
        }
        return out;
    }

    public List<ItemStack> getItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemHashEntry wrap1 : this.map.keySet()) {
            ItemStack outStack;
            for (int qty = this.map.get(wrap1).intValue(); qty > 0; qty -= outStack.field_77994_a) {
                outStack = wrap1.getItemStack().func_77946_l();
                outStack.field_77994_a = qty > outStack.func_77976_d() ? outStack.func_77976_d() : qty;
                items.add(outStack);
            }
        }
        return items;
    }

    public void getCompactItems(List<ItemStack> items) {
        for (ItemHashEntry wrap1 : this.map.keySet()) {
            ItemStack outStack = wrap1.getItemStack().func_77946_l();
            outStack.field_77994_a = this.map.get(wrap1);
            items.add(outStack);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList entryList = tag.func_150295_c("entryList", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            NBTTagCompound entryTag = entryList.func_150305_b(i);
            ItemHashEntry entry = ItemHashEntry.readFromNBT(entryTag);
            if (entry == null) continue;
            int qty = entryTag.func_74762_e("quantity");
            this.map.put(entry, qty);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList entryList = new NBTTagList();
        for (ItemHashEntry entry : this.keySet()) {
            NBTTagCompound entryTag = entry.writeToNBT(new NBTTagCompound());
            entryTag.func_74768_a("quantity", this.getCount(entry));
            entryList.func_74742_a((NBTBase)entryTag);
        }
        tag.func_74782_a("entryList", (NBTBase)entryList);
        return tag;
    }

    public int getSlotUseCount() {
        int count = 0;
        for (ItemHashEntry entry : this.map.keySet()) {
            int c1 = entry.getItemStack().func_77976_d();
            int c2 = this.getCount(entry);
            int c3 = c2 / c1;
            int c4 = c2 % c1;
            count += c3 + (c4 > 0 ? 1 : 0);
        }
        return count;
    }

    public int getTotalItemCount() {
        int count = 0;
        for (ItemHashEntry entry : this.map.keySet()) {
            count += this.map.get(entry).intValue();
        }
        return count;
    }

    public static final class ItemHashEntry {
        private final Item item;
        private final int damage;
        private final NBTTagCompound itemTag;
        private ItemStack cacheStack;

        public ItemHashEntry(ItemStack item) {
            if (item == null) {
                throw new IllegalArgumentException("Stack may not be null");
            }
            this.item = item.func_77973_b();
            if (this.item == null) {
                throw new IllegalArgumentException("Item may not be null");
            }
            this.damage = item.func_77960_j();
            this.itemTag = item.func_77942_o() ? (NBTTagCompound)item.func_77978_p().func_74737_b() : null;
        }

        public Item getItem() {
            return this.item;
        }

        public int getDamage() {
            return this.damage;
        }

        public NBTTagCompound getTag() {
            return (NBTTagCompound)(this.itemTag == null ? null : this.itemTag.func_74737_b());
        }

        private ItemHashEntry(Item item, int damage, NBTTagCompound tag) {
            if (item == null) {
                throw new IllegalArgumentException("Item may not be null");
            }
            this.item = item;
            this.damage = damage;
            this.itemTag = (NBTTagCompound)(tag == null ? null : tag.func_74737_b());
        }

        public int hashCode() {
            long hash = 31 + this.item.hashCode();
            hash = 31L * hash + (long)this.damage;
            if (this.itemTag != null) {
                hash = 31L * hash + (long)this.itemTag.hashCode();
            }
            return Long.hashCode(hash);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ItemHashEntry)) {
                return false;
            }
            ItemHashEntry wrap = (ItemHashEntry)obj;
            if (this.item == wrap.item && this.damage == wrap.damage) {
                if (this.itemTag == null) {
                    return wrap.itemTag == null;
                }
                return wrap.itemTag != null && this.itemTag.equals((Object)wrap.itemTag);
            }
            return false;
        }

        public String toString() {
            return "StackHashWrap: " + this.item.func_77658_a() + "@" + this.damage;
        }

        public ItemHashEntry copy() {
            return new ItemHashEntry(this.item, this.damage, this.itemTag);
        }

        public ItemStack getItemStack() {
            if (this.cacheStack != null) {
                return this.cacheStack;
            }
            ItemStack stack = new ItemStack(this.item, 1, this.damage);
            if (this.itemTag != null) {
                stack.func_77982_d((NBTTagCompound)this.itemTag.func_74737_b());
            }
            this.cacheStack = stack;
            return this.cacheStack;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            return ItemHashEntry.writeToNBT(this, tag);
        }

        public static NBTTagCompound writeToNBT(ItemHashEntry entry, NBTTagCompound tag) {
            tag.func_74778_a("itemName", Item.field_150901_e.func_148750_c((Object)entry.item));
            tag.func_74768_a("damage", entry.damage);
            if (entry.itemTag != null) {
                tag.func_74782_a("itemTag", (NBTBase)entry.itemTag);
            }
            return tag;
        }

        public static ItemHashEntry readFromNBT(NBTTagCompound tag) {
            Item item = (Item)Item.field_150901_e.func_82594_a(tag.func_74779_i("itemName"));
            if (item != null) {
                int dmg = tag.func_74762_e("damage");
                NBTTagCompound itemTag = tag.func_74764_b("itemTag") ? tag.func_74775_l("itemTag") : null;
                return new ItemHashEntry(item, dmg, itemTag);
            }
            AncientWarfareCore.log.error("Missing item: " + tag.func_74779_i("itemName"));
            return null;
        }
    }
}

