/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.item;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.core.block.AWCoreBlockLoader;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;

public class ItemHammer
extends Item
implements IItemKeyInterface {
    double attackDamage = 5.0;
    private Item.ToolMaterial material;

    public ItemHammer(String regName, Item.ToolMaterial material) {
        this.func_77655_b(regName);
        this.func_77637_a(AWCoreBlockLoader.coreTab);
        this.func_111206_d("ancientwarfare:core/" + regName);
        this.attackDamage = 4.0f + material.func_78000_c();
        this.material = material;
        this.field_77777_bU = 1;
        this.func_77656_e(material.func_77997_a());
        this.setHarvestLevel("hammer", material.func_77996_d());
    }

    public Item.ToolMaterial getMaterial() {
        return this.material;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return this.material.func_150995_f() == par2ItemStack.func_77973_b() || super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        par1ItemStack.func_77972_a(1, par3EntityLivingBase);
        return true;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase living) {
        if (block.func_149712_f(world, x, y, z) != 0.0f) {
            stack.func_77972_a(2, living);
        }
        return true;
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.attackDamage, 0));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        String key = InputHandler.instance.getKeybindBinding("keybind.alt_item_use_1");
        list.add(StatCollector.func_74837_a((String)"guistrings.core.hammer.use_primary_item_key", (Object[])new Object[]{key}));
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("workMode")) {
            list.add(StatCollector.func_74838_a((String)"guistrings.core.hammer.work_mode"));
        } else {
            list.add(StatCollector.func_74838_a((String)"guistrings.core.hammer.rotate_mode"));
        }
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        return key == IItemKeyInterface.ItemKey.KEY_0;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        boolean mode = false;
        if (stack.func_77942_o()) {
            mode = stack.func_77978_p().func_74767_n("workMode");
        } else {
            stack.func_77982_d(new NBTTagCompound());
        }
        mode = !mode;
        stack.func_77978_p().func_74757_a("workMode", mode);
        player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "random.click", 0.3f, 0.6f);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        MovingObjectPosition hit = this.func_77621_a(world, player, false);
        if (hit == null) {
            return stack;
        }
        boolean mode = false;
        if (stack.func_77942_o()) {
            mode = stack.func_77978_p().func_74767_n("workMode");
        } else {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (mode) {
            TileEntity te = world.func_147438_o(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
            if (te instanceof IWorkSite && ((IWorkSite)te).hasWork()) {
                ((IWorkSite)te).addEnergyFromPlayer(player);
                this.playSound(world, hit, "tile.piston.in");
            } else {
                Block block = world.func_147439_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                if (!block.isAir((IBlockAccess)world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d)) {
                    this.playBlockSound(world, hit, block);
                }
            }
        } else {
            Block block = world.func_147439_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
            if (!block.isAir((IBlockAccess)world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d)) {
                if (block.rotateBlock(world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, ForgeDirection.getOrientation((int)hit.field_72310_e))) {
                    this.playSound(world, hit, "tile.piston.out");
                } else {
                    this.playBlockSound(world, hit, block);
                }
            }
        }
        return stack;
    }

    private void playSound(World world, MovingObjectPosition hit, String sound) {
        world.func_72908_a((double)hit.field_72311_b, (double)hit.field_72312_c, (double)hit.field_72309_d, sound, 0.2f, world.field_73012_v.nextFloat() * 0.15f + 0.6f);
    }

    private void playBlockSound(World world, MovingObjectPosition hit, Block block) {
        if (block.field_149762_H != null) {
            world.func_72908_a((double)hit.field_72311_b, (double)hit.field_72312_c, (double)hit.field_72309_d, block.field_149762_H.func_150496_b(), block.field_149762_H.func_150497_c() * 0.5f, block.field_149762_H.func_150494_d() * 0.8f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

