/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import net.shadowmage.ancientwarfare.core.model.Primitive;
import net.shadowmage.ancientwarfare.core.model.PrimitiveBox;
import net.shadowmage.ancientwarfare.core.model.PrimitiveQuad;
import net.shadowmage.ancientwarfare.core.model.PrimitiveTriangle;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import org.lwjgl.opengl.GL11;

public class ModelBaseAW {
    int textureWidth = 256;
    int textureHeight = 256;
    HashMap<String, ModelPiece> pieces = new HashMap();
    private List<ModelPiece> basePieces = new ArrayList<ModelPiece>();
    protected int iterationNum;

    public void renderModel() {
        for (ModelPiece piece : this.getBasePieces()) {
            piece.render(this.textureWidth, this.textureHeight);
        }
    }

    public void renderForSelection() {
        this.iterationNum = 0;
        for (ModelPiece piece : this.getBasePieces()) {
            piece.renderForSelection(this.textureWidth, this.textureHeight, this);
        }
    }

    public void renderForEditor(ModelPiece selectedPiece, Primitive selectedPrimitive, List<ModelPiece> selectedPieceParents) {
        for (ModelPiece piece2 : this.getBasePieces()) {
            piece2.renderForEditor(selectedPiece, selectedPrimitive, selectedPieceParents, this.textureWidth, this.textureHeight);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setTextureSize(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
        this.recompilePrimitives();
    }

    public void parseFromLines(List<String> lines) {
        for (String line : lines) {
            Primitive box;
            ModelPiece piece;
            String parentName;
            String[] bits;
            if (line.toLowerCase(Locale.ENGLISH).startsWith("#")) continue;
            if (line.toLowerCase(Locale.ENGLISH).startsWith("texturesize=")) {
                bits = line.split("=")[1].split(",");
                this.textureWidth = StringTools.safeParseInt(bits[0]);
                this.textureHeight = StringTools.safeParseInt(bits[1]);
                continue;
            }
            if (line.startsWith("part=")) {
                ModelPiece piece2 = new ModelPiece(this, line.split("=")[1]);
                this.addPiece(piece2);
                continue;
            }
            if (line.startsWith("box=")) {
                bits = line.split("=")[1].split(",");
                parentName = bits[0];
                piece = this.getPiece(parentName);
                if (piece == null) {
                    throw new IllegalArgumentException("could not construct model, improper piece reference for: " + parentName);
                }
                box = new PrimitiveBox(piece);
                ((PrimitiveBox)box).readFromLine(bits);
                piece.addPrimitive(box);
                continue;
            }
            if (line.toLowerCase(Locale.ENGLISH).startsWith("quad")) {
                bits = line.split("=")[1].split(",");
                parentName = bits[0];
                piece = this.getPiece(parentName);
                if (piece == null) {
                    throw new IllegalArgumentException("could not construct model, improper piece reference for: " + parentName);
                }
                box = new PrimitiveQuad(piece);
                ((PrimitiveQuad)box).readFromLine(bits);
                piece.addPrimitive(box);
                continue;
            }
            if (!line.toLowerCase(Locale.ENGLISH).startsWith("triangle")) continue;
            bits = line.split("=")[1].split(",");
            parentName = bits[0];
            piece = this.getPiece(parentName);
            if (piece == null) {
                throw new IllegalArgumentException("could not construct model, improper piece reference for: " + parentName);
            }
            box = new PrimitiveTriangle(piece);
            ((PrimitiveTriangle)box).readFromLine(bits);
            piece.addPrimitive(box);
        }
    }

    public List<String> getModelLines() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("textureSize=" + this.textureWidth + "," + this.textureHeight);
        for (ModelPiece piece : this.basePieces) {
            piece.addPieceLines(lines);
        }
        return lines;
    }

    public void addPiece(ModelPiece piece) {
        this.pieces.put(piece.getName(), piece);
        if (piece.getParent() == null) {
            this.getBasePieces().add(piece);
        }
    }

    public void getPieces(List<ModelPiece> input) {
        for (ModelPiece piece : this.basePieces) {
            piece.getPieces(input);
        }
    }

    public void setPieceRotation(String name, float x, float y, float z) {
        ModelPiece piece = this.getPiece(name);
        if (piece == null) {
            return;
        }
        piece.setRotation(x, y, z);
    }

    public ModelPiece getPiece(String name) {
        return this.pieces.get(name);
    }

    public void removePiece(String name) {
        ModelPiece piece = this.getPiece(name);
        this.removePiece(piece);
    }

    public void removePiece(ModelPiece piece) {
        this.pieces.remove(piece.getName());
        this.basePieces.remove(piece);
    }

    public List<ModelPiece> getBasePieces() {
        return this.basePieces;
    }

    public Primitive getPrimitive(int num) {
        this.iterationNum = 0;
        for (ModelPiece p : this.basePieces) {
            Primitive prim = p.getPickedPrimitive(num, this);
            if (prim == null) continue;
            return prim;
        }
        return null;
    }

    public void recompilePrimitives() {
        for (ModelPiece p : this.basePieces) {
            p.recompilePiece();
        }
    }

    public int textureWidth() {
        return this.textureWidth;
    }

    public int textureHeight() {
        return this.textureHeight;
    }
}

