/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.model.ModelBaseAW;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import net.shadowmage.ancientwarfare.core.model.PrimitiveBox;
import net.shadowmage.ancientwarfare.core.util.StringTools;

public class ModelLoader {
    public ModelBaseAW loadModel(InputStream is) {
        Scanner scan = new Scanner(is);
        ArrayList<String> lines = new ArrayList<String>();
        while (scan.hasNext()) {
            lines.add(scan.next());
        }
        scan.close();
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ModelBaseAW model = new ModelBaseAW();
        model.parseFromLines(lines);
        return model;
    }

    public ModelBaseAW loadModel(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        Scanner scan = new Scanner(fis);
        ArrayList<String> lines = new ArrayList<String>();
        while (scan.hasNext()) {
            lines.add(scan.next());
        }
        scan.close();
        try {
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (file.getName().endsWith(".mmf")) {
            return this.parseOldModelLines(lines);
        }
        ModelBaseAW model = new ModelBaseAW();
        model.parseFromLines(lines);
        return model;
    }

    private ModelBaseAW parseOldModelLines(List<String> lines) {
        float importScale = 0.0625f;
        ModelBaseAW model = new ModelBaseAW();
        HashMap<String, Integer> txMap = new HashMap<String, Integer>();
        HashMap<String, Integer> tyMap = new HashMap<String, Integer>();
        for (String line : lines) {
            int ty;
            int tx;
            String name;
            String[] split;
            if (line.toLowerCase(Locale.ENGLISH).startsWith("part=")) {
                split = StringTools.safeParseStringArray("=", line);
                name = split[0];
                String parent = split[1];
                float x = StringTools.safeParseFloat(split[2]) * importScale;
                float y = StringTools.safeParseFloat(split[3]) * importScale;
                float z = StringTools.safeParseFloat(split[4]) * importScale;
                float rx = StringTools.safeParseFloat(split[5]) * 57.295776f;
                float ry = StringTools.safeParseFloat(split[6]) * 57.295776f;
                float rz = StringTools.safeParseFloat(split[7]) * 57.295776f;
                tx = StringTools.safeParseInt(split[8]);
                ty = StringTools.safeParseInt(split[9]);
                int tw = (int)StringTools.safeParseFloat(split[10]);
                int th = (int)StringTools.safeParseFloat(split[11]);
                model.setTextureSize(tw, th);
                ModelPiece piece = new ModelPiece(name, -x, -y, -z, rx, ry, rz, model.getPiece(parent));
                model.addPiece(piece);
                if (piece.getParent() == null) {
                    piece.setPosition(piece.x(), piece.y() + 1.0f, piece.z());
                }
                txMap.put(name, tx);
                tyMap.put(name, ty);
                continue;
            }
            if (!line.toLowerCase(Locale.ENGLISH).startsWith("box=")) continue;
            split = StringTools.safeParseStringArray("=", line);
            name = split[0];
            float x = StringTools.safeParseFloat(split[1]) * importScale;
            float y = StringTools.safeParseFloat(split[2]) * importScale;
            float z = StringTools.safeParseFloat(split[3]) * importScale;
            float bw = (float)StringTools.safeParseInt(split[4]) * importScale;
            float bh = (float)StringTools.safeParseInt(split[5]) * importScale;
            float bl = (float)StringTools.safeParseInt(split[6]) * importScale;
            ModelPiece piece = model.getPiece(name);
            tx = (Integer)txMap.get(name);
            ty = (Integer)tyMap.get(name);
            if (piece == null) continue;
            PrimitiveBox box = new PrimitiveBox(piece);
            box.setBounds(-x - bw, -y - bh, -z - bl, bw, bh, bl);
            box.setOrigin(0.0f, 0.0f, 0.0f);
            box.setRotation(0.0f, 0.0f, 0.0f);
            box.setTx(tx);
            box.setTy(ty);
            piece.addPrimitive(box);
        }
        return model;
    }

    public void saveModel(ModelBaseAW model, File file) {
        try {
            String name = file.getName();
            List<String> lines = model.getModelLines();
            if (!file.exists()) {
                File newoutputfile = new File(file.getParent());
                newoutputfile.mkdirs();
                file.createNewFile();
            }
            FileWriter writer = new FileWriter(file);
            for (String line : lines) {
                writer.write(line + "\n");
            }
            writer.close();
            if (!name.endsWith(".mf2")) {
                if (name.contains(".")) {
                    int d = name.indexOf(46);
                    name = name.substring(0, d);
                }
                file.renameTo(new File(file.getParent(), name + ".m2f"));
            }
        }
        catch (IOException e) {
            AWLog.logError("error exporting model for name: " + file.getName());
            e.printStackTrace();
        }
    }
}

