/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.model;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import net.shadowmage.ancientwarfare.core.model.Primitive;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import org.lwjgl.opengl.GL11;

public class PrimitiveQuad
extends Primitive {
    float x1;
    float y1;
    float x2;
    float y2;

    public PrimitiveQuad(ModelPiece parent) {
        super(parent);
    }

    @Override
    protected void renderPrimitive(float tw, float th) {
        float px = 1.0f / tw;
        float py = 1.0f / th;
        float w = (this.x2 - this.x1) * 16.0f;
        float l = 1.0f;
        float h = (this.y2 - this.y1) * 16.0f;
        float ty = this.ty();
        float tx = this.tx();
        if (this.rx != 0.0f) {
            GL11.glRotatef((float)this.rx, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.ry != 0.0f) {
            GL11.glRotatef((float)this.ry, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rz != 0.0f) {
            GL11.glRotatef((float)this.rz, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glBegin((int)7);
        float tx1 = (tx + l) * px;
        float ty1 = (th - (ty + l + h)) * py;
        float tx2 = (tx + l + w) * px;
        float ty2 = (th - (ty + l)) * py;
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)tx1, (float)ty1);
        GL11.glVertex3f((float)this.x1, (float)this.y1, (float)0.0f);
        GL11.glTexCoord2f((float)tx2, (float)ty1);
        GL11.glVertex3f((float)this.x2, (float)this.y1, (float)0.0f);
        GL11.glTexCoord2f((float)tx2, (float)ty2);
        GL11.glVertex3f((float)this.x2, (float)this.y2, (float)0.0f);
        GL11.glTexCoord2f((float)tx1, (float)ty2);
        GL11.glVertex3f((float)this.x1, (float)this.y2, (float)0.0f);
        GL11.glEnd();
    }

    @Override
    public Primitive copy() {
        PrimitiveQuad box = new PrimitiveQuad(this.parent);
        box.setBounds(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
        box.setOrigin(this.x, this.y, this.z);
        box.setRotation(this.rx, this.ry, this.rz);
        box.setTx(this.tx());
        box.setTy(this.ty());
        return box;
    }

    @Override
    public void addPrimitiveLines(ArrayList<String> lines) {
        StringBuilder b = new StringBuilder("quad=" + this.parent.getName() + ",");
        b.append(this.x).append(",").append(this.y).append(",").append(this.z).append(",").append(this.rx).append(",").append(this.ry).append(",").append(this.rz).append(",").append(this.tx()).append(",").append(this.ty()).append(",");
        b.append(this.x1).append(",").append(this.y1).append(",").append(this.x2).append(",").append(this.y2);
        lines.add(b.toString());
    }

    @Override
    public void readFromLine(String[] lineBits) {
        this.x = StringTools.safeParseFloat(lineBits[1]);
        this.y = StringTools.safeParseFloat(lineBits[2]);
        this.z = StringTools.safeParseFloat(lineBits[3]);
        this.rx = StringTools.safeParseFloat(lineBits[4]);
        this.ry = StringTools.safeParseFloat(lineBits[5]);
        this.rz = StringTools.safeParseFloat(lineBits[6]);
        this.setTx(StringTools.safeParseFloat(lineBits[7]));
        this.setTy(StringTools.safeParseFloat(lineBits[8]));
        this.x1 = StringTools.safeParseFloat(lineBits[9]);
        this.y1 = StringTools.safeParseFloat(lineBits[10]);
        this.x2 = StringTools.safeParseFloat(lineBits[11]);
        this.y2 = StringTools.safeParseFloat(lineBits[12]);
    }

    public void setBounds(float x1, float y1, float width, float height) {
        this.x1 = x1;
        this.x2 = x1 + width;
        this.y1 = y1;
        this.y2 = y1 + height;
    }

    public float x1() {
        return this.x1;
    }

    public float y1() {
        return this.y1;
    }

    public float width() {
        return this.x2 - this.x1;
    }

    public float height() {
        return this.y2 - this.y1;
    }

    @Override
    public void addUVMapToImage(BufferedImage image) {
        int w = (int)(this.x2 - this.x1) * 16;
        int h = (int)(this.y2 - this.y1) * 16;
        for (int x = (int)this.tx(); (float)x < this.tx() + (float)w && x < image.getWidth(); ++x) {
            for (int y = (int)this.ty(); (float)y < this.ty() + (float)h && y < image.getHeight(); ++y) {
                image.setRGB(x, y, -65536);
            }
        }
    }
}

