/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.model;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.MathHelper;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import net.shadowmage.ancientwarfare.core.model.Primitive;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.core.util.Trig;
import org.lwjgl.opengl.GL11;

public class PrimitiveTriangle
extends Primitive {
    float x1;
    float y1;
    float z1;
    float x2;
    float y2;
    float z2;
    float x3;
    float y3;
    float z3;
    float u1;
    float v1;
    float u2;
    float v2;
    float u3;
    float v3;
    float normalX;
    float normalY;
    float normalZ;
    float cx;
    float cy;

    public PrimitiveTriangle(ModelPiece parent) {
        super(parent);
    }

    public float x1() {
        return this.x1;
    }

    public float y1() {
        return this.y1;
    }

    public float z1() {
        return this.z1;
    }

    public float x2() {
        return this.x2;
    }

    public float y2() {
        return this.y2;
    }

    public float z2() {
        return this.z2;
    }

    public float x3() {
        return this.x3;
    }

    public float y3() {
        return this.y3;
    }

    public float z3() {
        return this.z3;
    }

    public float u1() {
        return this.u1;
    }

    public float u2() {
        return this.u2;
    }

    public float u3() {
        return this.u3;
    }

    public float v1() {
        return this.v1;
    }

    public float v2() {
        return this.v2;
    }

    public float v3() {
        return this.v3;
    }

    public float cx() {
        return this.cx;
    }

    public float cy() {
        return this.cy;
    }

    @Override
    protected void renderPrimitive(float tw, float th) {
        if (this.rx != 0.0f) {
            GL11.glRotatef((float)this.rx, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.ry != 0.0f) {
            GL11.glRotatef((float)this.ry, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rz != 0.0f) {
            GL11.glRotatef((float)this.rz, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        float px = 1.0f / tw;
        float py = 1.0f / th;
        float u1 = this.u1 * px + this.tx() * px;
        float u2 = this.u2 * px + this.tx() * px;
        float u3 = this.u3 * px + this.tx() * px;
        float v1 = this.v1 * py + this.ty() * py;
        float v2 = this.v2 * py + this.ty() * py;
        float v3 = this.v3 * py + this.ty() * py;
        GL11.glBegin((int)5);
        GL11.glNormal3f((float)this.normalX, (float)this.normalY, (float)this.normalZ);
        GL11.glTexCoord2f((float)u1, (float)v1);
        GL11.glVertex3f((float)this.x1, (float)this.y1, (float)this.z1);
        GL11.glTexCoord2f((float)u2, (float)v2);
        GL11.glVertex3f((float)this.x2, (float)this.y2, (float)this.z2);
        GL11.glTexCoord2f((float)u3, (float)v3);
        GL11.glVertex3f((float)this.x3, (float)this.y3, (float)this.z3);
        GL11.glEnd();
    }

    public void reverseVertexOrder() {
        float x = this.x2;
        float y = this.y2;
        float z = this.z2;
        this.x2 = this.x3;
        this.y2 = this.y3;
        this.z2 = this.z3;
        this.x3 = x;
        this.y3 = y;
        this.z3 = z;
        this.setBounds(this.x1, this.y1, this.z1, this.x2, this.y2, this.z1, this.x3, this.y3, this.z3);
    }

    public void rotateTriangleUV(float degrees) {
        float dx = this.u1() - this.cx();
        float dy = this.v1() - this.cy();
        float length = MathHelper.func_76129_c((float)(dx * dx + dy * dy));
        double radianAngle = Math.atan2(dx, dy);
        float u1 = (float)Math.sin(radianAngle += (double)(degrees * ((float)Math.PI / 180))) * length;
        float v1 = (float)Math.cos(radianAngle) * length;
        dx = this.u2() - this.cx();
        dy = this.v2() - this.cy();
        length = MathHelper.func_76129_c((float)(dx * dx + dy * dy));
        radianAngle = Math.atan2(dx, dy);
        float u2 = (float)Math.sin(radianAngle += (double)(degrees * ((float)Math.PI / 180))) * length;
        float v2 = (float)Math.cos(radianAngle) * length;
        dx = this.u3() - this.cx();
        dy = this.v3() - this.cy();
        length = MathHelper.func_76129_c((float)(dx * dx + dy * dy));
        radianAngle = Math.atan2(dx, dy);
        float u3 = (float)Math.sin(radianAngle += (double)(degrees * ((float)Math.PI / 180))) * length;
        float v3 = (float)Math.cos(radianAngle) * length;
        this.setUV(u1, v1, u2, v2, u3, v3);
    }

    @Override
    public Primitive copy() {
        PrimitiveTriangle box = new PrimitiveTriangle(this.parent);
        box.setBounds(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2, this.x3, this.y3, this.z3);
        box.setOrigin(this.x, this.y, this.z);
        box.setRotation(this.rx, this.ry, this.rz);
        box.setTx(this.tx());
        box.setTy(this.ty());
        box.setUV(this.u1, this.v1, this.u2, this.v2, this.u3, this.v3);
        return box;
    }

    @Override
    public void addPrimitiveLines(ArrayList<String> lines) {
        StringBuilder b = new StringBuilder("triangle=").append(this.parent.getName()).append(",");
        b.append(this.x).append(",").append(this.y).append(",").append(this.z).append(",").append(this.rx).append(",").append(this.ry).append(",").append(this.rz).append(",").append(this.tx()).append(",").append(this.ty()).append(",");
        b.append(this.x1).append(",").append(this.y1).append(",").append(this.z1).append(",").append(this.x2).append(",").append(this.y2).append(",").append(this.z2).append(",").append(this.x3).append(",").append(this.y3).append(",").append(this.z3).append(",");
        b.append(this.u1).append(",").append(this.v1).append(",").append(this.u2).append(",").append(this.v2).append(",").append(this.u3).append(",").append(this.v3);
        lines.add(b.toString());
    }

    @Override
    public void readFromLine(String[] lineBits) {
        this.x = StringTools.safeParseFloat(lineBits[1]);
        this.y = StringTools.safeParseFloat(lineBits[2]);
        this.z = StringTools.safeParseFloat(lineBits[3]);
        this.rx = StringTools.safeParseFloat(lineBits[4]);
        this.ry = StringTools.safeParseFloat(lineBits[5]);
        this.rz = StringTools.safeParseFloat(lineBits[6]);
        this.setTx(StringTools.safeParseFloat(lineBits[7]));
        this.setTy(StringTools.safeParseFloat(lineBits[8]));
        this.x1 = StringTools.safeParseFloat(lineBits[9]);
        this.y1 = StringTools.safeParseFloat(lineBits[10]);
        this.z1 = StringTools.safeParseFloat(lineBits[11]);
        this.x2 = StringTools.safeParseFloat(lineBits[12]);
        this.y2 = StringTools.safeParseFloat(lineBits[13]);
        this.z2 = StringTools.safeParseFloat(lineBits[14]);
        this.x3 = StringTools.safeParseFloat(lineBits[15]);
        this.y3 = StringTools.safeParseFloat(lineBits[16]);
        this.z3 = StringTools.safeParseFloat(lineBits[17]);
        this.u1 = StringTools.safeParseFloat(lineBits[18]);
        this.v1 = StringTools.safeParseFloat(lineBits[19]);
        this.u2 = StringTools.safeParseFloat(lineBits[20]);
        this.v2 = StringTools.safeParseFloat(lineBits[21]);
        this.u3 = StringTools.safeParseFloat(lineBits[22]);
        this.v3 = StringTools.safeParseFloat(lineBits[23]);
        this.calcNormal();
        this.calcCenter();
    }

    public void setBounds(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        this.x1 = x1;
        this.x2 = x2;
        this.x3 = x3;
        this.y1 = y1;
        this.y2 = y2;
        this.y3 = y3;
        this.z1 = z1;
        this.z2 = z2;
        this.z3 = z3;
        this.recalcUV();
        this.calcNormal();
        this.calcCenter();
    }

    public void setUV(float u1, float v1, float u2, float v2, float u3, float v3) {
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
        this.u3 = u3;
        this.v3 = v3;
        this.calcCenter();
    }

    private void calcCenter() {
        this.cx = (this.u1 + this.u2 + this.u3) / 3.0f;
        this.cy = (this.v1 + this.v2 + this.v3) / 3.0f;
    }

    private void calcNormal() {
        float vx = this.x2 - this.x1;
        float vy = this.y2 - this.y1;
        float vz = this.z2 - this.z1;
        float wx = this.x3 - this.x1;
        float wy = this.y3 - this.y1;
        float wz = this.z3 - this.z1;
        this.normalX = vy * wz - vz * wy;
        this.normalY = vz * wx - vx * wz;
        this.normalZ = vx * wy - vy * wx;
        float norm = MathHelper.func_76129_c((float)(this.normalX * this.normalX + this.normalY * this.normalY + this.normalZ * this.normalZ));
        this.normalX /= norm;
        this.normalY /= norm;
        this.normalZ /= norm;
    }

    protected void recalcUV() {
        float a = Trig.getDistance(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2) * 16.0f;
        float b = Trig.getDistance(this.x2, this.y2, this.z2, this.x3, this.y3, this.z3) * 16.0f;
        float c = Trig.getDistance(this.x3, this.y3, this.z3, this.x1, this.y1, this.z1) * 16.0f;
        float cosA = (b * b + c * c - a * a) / 2.0f * (b * c);
        cosA = (float)Math.pow((float)Math.cos(cosA), -1.0);
        float cosB = (c * c + a * a - b * b) / 2.0f * (c * a);
        cosB = (float)Math.pow((float)Math.cos(cosB), -1.0);
        float cosC = (180.0f - cosA * 57.295776f - cosB * 57.295776f) * ((float)Math.PI / 180);
        this.u1 = 0.0f;
        this.v1 = 0.0f;
        this.u2 = this.u1 + a;
        this.v2 = 0.0f;
        this.u3 = this.u1 + (float)(Math.sin(cosC * ((float)Math.PI / 180)) * (double)c);
        this.v3 = this.v1 + (float)(Math.cos(cosC * ((float)Math.PI / 180)) * (double)c);
        this.calcCenter();
    }

    @Override
    public void addUVMapToImage(BufferedImage image) {
        float x = this.tx();
        float y = this.ty();
        float x1 = x + this.u1;
        float y1 = y + this.v1;
        float x2 = x + this.u2;
        float y2 = y + this.v2;
        float x3 = x + this.u3;
        float y3 = y + this.v3;
        if (x1 < 0.0f) {
            x1 = 0.0f;
        }
        if (x2 < 0.0f) {
            x2 = 0.0f;
        }
        if (x3 < 0.0f) {
            x3 = 0.0f;
        }
        if (y1 < 0.0f) {
            y1 = 0.0f;
        }
        if (y2 < 0.0f) {
            y2 = 0.0f;
        }
        if (y3 < 0.0f) {
            y3 = 0.0f;
        }
        ArrayList<Point2i> points = new ArrayList<Point2i>();
        PrimitiveTriangle.plotLine3((int)x1, (int)y1, (int)x2, (int)y2, points);
        for (Point2i point : points) {
            image.setRGB(point.x, point.y, -65536);
        }
        points.clear();
        PrimitiveTriangle.plotLine3((int)x2, (int)y2, (int)x3, (int)y3, points);
        for (Point2i point : points) {
            image.setRGB(point.x, point.y, -65536);
        }
        points.clear();
        PrimitiveTriangle.plotLine3((int)x3, (int)y3, (int)x1, (int)y1, points);
        for (Point2i point : points) {
            image.setRGB(point.x, point.y, -65536);
        }
        points.clear();
        image.setRGB((int)(this.tx() + this.cx()), (int)(this.ty() + this.cy()), -65536);
    }

    public static void plotLine3(int x1, int y1, int x2, int y2, List<Point2i> points) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        int x = x1;
        int y = y1;
        while (true) {
            points.add(new Point2i(x, y));
            if (x == x2 && y == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (x == x2 && y == y2) {
                points.add(new Point2i(x, y));
                break;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
    }

    public static class Point2i {
        public int x;
        public int y;

        public Point2i(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

