/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.network;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;

public abstract class PacketBase {
    private static HashMap<Integer, Class<? extends PacketBase>> packetTypes = new HashMap();
    private static HashMap<Class<? extends PacketBase>, Integer> packetIDs = new HashMap();

    public static void registerPacketType(int typeNum, Class<? extends PacketBase> packetClz) {
        packetTypes.put(typeNum, packetClz);
        packetIDs.put(packetClz, typeNum);
    }

    protected void writeHeaderToStream(ByteBuf data) {
        data.writeByte(packetIDs.get(this.getClass()).intValue());
    }

    protected static PacketBase readHeaderFromStream(ByteBuf data) {
        byte typeNum = data.readByte();
        try {
            return packetTypes.get(typeNum).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract void writeToStream(ByteBuf var1);

    protected abstract void readFromStream(ByteBuf var1);

    protected void execute() {
    }

    protected void execute(EntityPlayer player) {
        this.execute();
    }

    public static PacketBase readPacket(ByteBuf data) {
        PacketBase pkt = PacketBase.readHeaderFromStream(data);
        pkt.readFromStream(data);
        return pkt;
    }

    public final FMLProxyPacket getFMLPacket() {
        ByteBuf buf = Unpooled.buffer();
        this.writeHeaderToStream(buf);
        this.writeToStream(buf);
        return new FMLProxyPacket(buf, "AWCORE");
    }
}

