/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.core.interfaces.IItemClickable;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.network.PacketBase;

public class PacketItemInteraction
extends PacketBase {
    private byte type;
    private byte key;

    public PacketItemInteraction() {
    }

    public PacketItemInteraction(int type) {
        this.type = (byte)type;
    }

    public PacketItemInteraction(int type, IItemKeyInterface.ItemKey iKey) {
        this.type = (byte)type;
        this.key = (byte)iKey.ordinal();
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        data.writeByte((int)this.type);
        data.writeByte((int)this.key);
    }

    @Override
    protected void readFromStream(ByteBuf data) {
        this.type = data.readByte();
        this.key = data.readByte();
    }

    @Override
    protected void execute(EntityPlayer player) {
        if (player != null) {
            ItemStack stack = player.func_70694_bm();
            if (stack == null) {
                return;
            }
            if (this.type == 0) {
                if (this.key >= 0 && this.key < IItemKeyInterface.ItemKey.values().length && stack.func_77973_b() instanceof IItemKeyInterface) {
                    ((IItemKeyInterface)stack.func_77973_b()).onKeyAction(player, stack, IItemKeyInterface.ItemKey.values()[this.key]);
                }
            } else if (this.type == 1) {
                if (stack.func_77973_b() instanceof IItemClickable) {
                    ((IItemClickable)stack.func_77973_b()).onLeftClick(player, stack);
                }
            } else if (this.type == 2 && stack.func_77973_b() instanceof IItemClickable) {
                ((IItemClickable)stack.func_77973_b()).onRightClick(player, stack);
            }
        }
    }
}

