/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.render;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.model.crafting_table.ModelCraftingBase;
import org.lwjgl.opengl.GL11;

public class TileCraftingTableRender
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private final ModelCraftingBase model;
    private final ResourceLocation texture;

    public TileCraftingTableRender(ModelCraftingBase model, String tex) {
        this.model = model;
        this.texture = new ResourceLocation("ancientwarfare", tex);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.5f);
        GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(this.texture);
        this.model.renderModel();
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float delta) {
        float rotation = te instanceof BlockRotationHandler.IRotatableTile ? this.getRotation(((BlockRotationHandler.IRotatableTile)te).getPrimaryFacing()) : 0.0f;
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.func_147499_a(this.texture);
        this.model.renderModel(te);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private float getRotation(ForgeDirection d) {
        switch (d) {
            case NORTH: {
                return 0.0f;
            }
            case SOUTH: {
                return 180.0f;
            }
            case EAST: {
                return 270.0f;
            }
            case WEST: {
                return 90.0f;
            }
        }
        return 0.0f;
    }
}

