/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.research;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.StringTools;

public class ResearchGoal {
    private static boolean hasInit = false;
    private static HashMap<Integer, ResearchGoal> goalsByID = new HashMap();
    private static HashMap<String, ResearchGoal> goalsByName = new HashMap();
    private final Random random;
    private final int researchId;
    private final String researchName;
    private final Set<Integer> dependencies;
    private final List<ItemStack> researchResources;
    private final List<OreSized> researchOres;
    private int researchTime;
    private Set<Integer> resolvedDependencies;

    public ResearchGoal(int id, String name) {
        this.researchId = id;
        this.researchName = name;
        this.dependencies = new HashSet<Integer>();
        this.researchResources = new ArrayList<ItemStack>();
        this.researchOres = new ArrayList<OreSized>();
        this.random = new Random(this.researchName.hashCode());
    }

    public void addResource(ItemStack resource) {
        this.researchResources.add(resource);
    }

    public void addOre(String[] ore) {
        int size = 1;
        if (ore.length > 3) {
            size = StringTools.safeParseInt(ore[3]);
        } else if (ore.length == 3) {
            size = StringTools.safeParseInt(ore[2]);
        }
        this.researchOres.add(new OreSized(ore[1].trim(), size));
    }

    public void setResearchTime(int time) {
        this.researchTime = time;
    }

    public int getTotalResearchTime() {
        return this.researchTime;
    }

    public String getName() {
        return this.researchName;
    }

    public int getId() {
        return this.researchId;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ResearchGoal && this.researchName.equals(((ResearchGoal)o).researchName);
    }

    public int hashCode() {
        return this.researchName.hashCode();
    }

    public ResearchGoal addDependencies(ResearchGoal ... deps) {
        for (ResearchGoal dep : deps) {
            this.dependencies.add(dep.researchId);
        }
        return this;
    }

    public List<ItemStack> getResources() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.addAll(this.researchResources);
        for (OreSized ore : this.researchOres) {
            result.add(ore.getEquivalent(this.random));
        }
        return result;
    }

    public Set<ResearchGoal> getDependencies() {
        return ResearchGoal.getGoalsFor(this.dependencies);
    }

    public boolean canResearch(Set<Integer> knownResearch) {
        Set<Integer> fullDependencies = ResearchGoal.resolveDependeciesFor(this);
        return knownResearch.containsAll(fullDependencies);
    }

    /*
     * WARNING - void declaration
     */
    public boolean tryStart(IInventory inventory, int side) {
        if (!AWCoreStatics.enableResearchResourceUse) {
            return true;
        }
        for (ItemStack itemStack : this.researchResources) {
            if (InventoryTools.getCountOf(inventory, side, itemStack) >= itemStack.field_77994_a) continue;
            return false;
        }
        for (OreSized ore : this.researchOres) {
            ItemStack temp;
            int count = 0;
            Iterator<Object> iterator = ore.getEquivalents().iterator();
            while (iterator.hasNext() && (count += InventoryTools.getCountOf(inventory, side, temp = (ItemStack)iterator.next())) < ore.size) {
            }
            if (count >= ore.size) continue;
            return false;
        }
        for (ItemStack stack : this.researchResources) {
            InventoryTools.removeItems(inventory, side, stack, stack.field_77994_a);
        }
        for (OreSized ore : this.researchOres) {
            void var4_9;
            ItemStack temp;
            ItemStack remove;
            int n = ore.size;
            Iterator<ItemStack> iterator = ore.getEquivalents().iterator();
            while (iterator.hasNext() && ((remove = InventoryTools.removeItems(inventory, side, temp = iterator.next(), (int)var4_9)) == null || (var4_9 -= remove.field_77994_a) > 0)) {
            }
        }
        return true;
    }

    public static void initializeResearch() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        ResearchGoal.parseGoalNames(StringTools.getResourceLines("/assets/ancientwarfare/resources/research_data.csv"));
        ResearchGoal.parseGoalDependencies(StringTools.getResourceLines("/assets/ancientwarfare/resources/research_dependencies.csv"));
        ResearchGoal.parseGoalResources(StringTools.getResourceLines("/assets/ancientwarfare/resources/research_resources.csv"));
    }

    private static void parseGoalNames(List<String> lines) {
        for (String line : lines) {
            String[] split = StringTools.parseStringArray(line);
            if (split.length < 3) {
                AWLog.logError("Could not parse research data for line: " + line);
                continue;
            }
            int id = StringTools.safeParseInt(split[0]);
            String name = split[1].startsWith("research.") ? split[1] : "research." + split[1];
            int time = AWCoreStatics.getResearchTimeFor(name, StringTools.safeParseInt(split[2]));
            ResearchGoal goal = new ResearchGoal(id, name);
            goalsByID.put(id, goal);
            goalsByName.put(name, goal);
            goal.setResearchTime(time);
        }
    }

    private static void parseGoalDependencies(List<String> lines) {
        for (String line : lines) {
            String dep;
            String[] split = StringTools.parseStringArray(line);
            if (split.length < 2) {
                AWLog.logError("Could not parse goal dependency for line: " + line);
                continue;
            }
            String name = split[0].startsWith("research.") ? split[0] : "research." + split[0];
            String string = dep = split[1].startsWith("research.") ? split[1] : "research." + split[1];
            if (!goalsByName.containsKey(name) || !goalsByName.containsKey(dep)) continue;
            goalsByName.get(name).addDependencies(goalsByName.get(dep));
        }
    }

    private static void parseGoalResources(List<String> lines) {
        for (String line : lines) {
            String name;
            String[] split = StringTools.parseStringArray(line);
            String string = name = split[0].startsWith("research.") ? split[0] : "research." + split[0];
            if (!goalsByName.containsKey(name)) {
                AWLog.logError("Could not locate goal for name: " + name);
                continue;
            }
            ItemStack stack = null;
            if (split.length > 3) {
                stack = StringTools.safeParseStack(split[1], split[2], split[3], false);
            } else if (split.length > 1) {
                stack = StringTools.safeParseStack(split[1], "0", split.length > 2 ? split[2] : "1", false);
            }
            if (stack != null) {
                ResearchGoal.getGoal(name).addResource(stack);
                continue;
            }
            if (!OreDictionary.getOres((String)split[1].trim()).isEmpty()) {
                ResearchGoal.getGoal(name).addOre(split);
                continue;
            }
            AWLog.logError("Could not define item from line: " + line);
        }
    }

    public static ResearchGoal getGoal(String name) {
        return goalsByName.get(name);
    }

    public static ResearchGoal getGoal(int id) {
        return goalsByID.get(id);
    }

    public static Set<ResearchGoal> getGoalsFor(Collection<Integer> researchNums) {
        HashSet<ResearchGoal> out = new HashSet<ResearchGoal>();
        for (Integer i : researchNums) {
            if (!goalsByID.containsKey(i)) continue;
            out.add(goalsByID.get(i));
        }
        return out;
    }

    public static Set<Integer> resolveDependeciesFor(ResearchGoal goal) {
        if (goal.resolvedDependencies != null) {
            return goal.resolvedDependencies;
        }
        HashSet<Integer> foundDependencies = new HashSet<Integer>();
        LinkedList<Integer> openList = new LinkedList<Integer>();
        openList.addAll(goal.dependencies);
        while (!openList.isEmpty()) {
            Integer dep = (Integer)openList.poll();
            foundDependencies.add(dep);
            ResearchGoal g1 = goalsByID.get(dep);
            Set<Integer> gDeps = g1.dependencies;
            for (Integer i : gDeps) {
                if (foundDependencies.contains(i)) continue;
                foundDependencies.add(i);
                openList.add(i);
            }
        }
        goal.resolvedDependencies = foundDependencies;
        return foundDependencies;
    }

    public static Set<Integer> getResearchableGoalsFor(Collection<Integer> knownResearch, Collection<Integer> queuedResearch, int inProgress) {
        HashSet<Integer> totalKnowledge = new HashSet<Integer>();
        totalKnowledge.addAll(knownResearch);
        totalKnowledge.addAll(queuedResearch);
        if (inProgress >= 0) {
            totalKnowledge.add(inProgress);
        }
        HashSet<Integer> researchableGoals = new HashSet<Integer>();
        for (Integer g : goalsByID.keySet()) {
            ResearchGoal goal;
            if (totalKnowledge.contains(g) || !(goal = goalsByID.get(g)).canResearch(totalKnowledge)) continue;
            researchableGoals.add(goal.getId());
        }
        return researchableGoals;
    }

    public static Collection<ResearchGoal> getResearchGoals() {
        return goalsByName.values();
    }

    private class OreSized {
        private final String name;
        private final int size;

        private OreSized(String ore, int size) {
            this.name = ore;
            this.size = size <= 0 ? 1 : size;
        }

        public List<ItemStack> getEquivalents() {
            return OreDictionary.getOres((String)this.name);
        }

        public ItemStack getEquivalent(Random random) {
            List<ItemStack> temps = this.getEquivalents();
            ItemStack temp = temps.get(random.nextInt(temps.size())).func_77946_l();
            temp.field_77994_a = this.size;
            return temp;
        }
    }
}

