/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.tile;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.shadowmage.ancientwarfare.core.interfaces.IOwnable;

public class TileOwned
extends TileEntity
implements IOwnable {
    private String ownerName;
    private UUID owner;
    private final String tagKey;

    public TileOwned() {
        this.tagKey = "ownerName";
    }

    public TileOwned(String tag) {
        this.tagKey = tag;
    }

    @Override
    public final void setOwner(EntityPlayer player) {
        this.ownerName = player.func_70005_c_();
        this.owner = player.func_110124_au();
    }

    @Override
    public final String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public final boolean isOwner(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (this.owner != null) {
            return player.func_110124_au().equals(this.owner);
        }
        return player.func_70005_c_().equals(this.ownerName);
    }

    private void checkOwnerName() {
        if (this.func_145830_o()) {
            EntityPlayer player;
            if (this.owner != null) {
                EntityPlayer player2 = this.field_145850_b.func_152378_a(this.owner);
                if (player2 != null) {
                    this.setOwner(player2);
                }
            } else if (this.ownerName != null && (player = this.field_145850_b.func_72924_a(this.ownerName)) != null) {
                this.setOwner(player);
            }
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.ownerName = tag.func_74779_i(this.tagKey);
        if (tag.func_74764_b("ownerId")) {
            this.owner = UUID.fromString(tag.func_74779_i("ownerId"));
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.checkOwnerName();
        tag.func_74778_a(this.tagKey, this.ownerName);
        if (this.owner != null) {
            tag.func_74778_a("ownerId", this.owner.toString());
        }
    }
}

