/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.tile;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.item.ItemResearchBook;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.research.ResearchGoal;
import net.shadowmage.ancientwarfare.core.research.ResearchTracker;
import net.shadowmage.ancientwarfare.core.tile.TileOwned;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;

public class TileResearchStation
extends TileOwned
implements IWorkSite,
IInventory,
IInvBasic,
ITorque.ITorqueTile,
IInteractableTile,
BlockRotationHandler.IRotatableTile {
    ForgeDirection orientation = ForgeDirection.NORTH;
    private final net.shadowmage.ancientwarfare.core.inventory.InventoryBasic bookInventory = new net.shadowmage.ancientwarfare.core.inventory.InventoryBasic(1, this);
    private final net.shadowmage.ancientwarfare.core.inventory.InventoryBasic resourceInventory = new net.shadowmage.ancientwarfare.core.inventory.InventoryBasic(9, this);
    int startCheckDelay = 0;
    int startCheckDelayMax = 40;
    public boolean useAdjacentInventory;
    public ForgeDirection inventoryDirection = ForgeDirection.NORTH;
    public ForgeDirection inventorySide = ForgeDirection.NORTH;
    double maxEnergyStored = 1600.0;
    double maxInput = 100.0;
    private double storedEnergy;

    public TileResearchStation() {
        super("owningPlayer");
    }

    @Override
    public void onBlockBroken() {
    }

    @Override
    public EnumSet<WorksiteUpgrade> getUpgrades() {
        return EnumSet.noneOf(WorksiteUpgrade.class);
    }

    @Override
    public EnumSet<WorksiteUpgrade> getValidUpgrades() {
        return EnumSet.noneOf(WorksiteUpgrade.class);
    }

    @Override
    public void addUpgrade(WorksiteUpgrade upgrade) {
    }

    @Override
    public void removeUpgrade(WorksiteUpgrade upgrade) {
    }

    @Override
    public float getClientOutputRotation(ForgeDirection from, float delta) {
        return 0.0f;
    }

    @Override
    public boolean useOutputRotation(ForgeDirection from) {
        return false;
    }

    @Override
    public double getMaxTorqueOutput(ForgeDirection from) {
        return 0.0;
    }

    @Override
    public boolean canOutputTorque(ForgeDirection towards) {
        return false;
    }

    @Override
    public double addTorque(ForgeDirection from, double energy) {
        if (this.canInputTorque(from)) {
            if (energy + this.getTorqueStored(from) > this.getMaxTorque(from)) {
                energy = this.getMaxTorque(from) - this.getTorqueStored(from);
            }
            if (energy > this.getMaxTorqueInput(from)) {
                energy = this.getMaxTorqueInput(from);
            }
            this.storedEnergy += energy;
            return energy;
        }
        return 0.0;
    }

    @Override
    public double getMaxTorque(ForgeDirection from) {
        return this.maxEnergyStored;
    }

    @Override
    public double getTorqueStored(ForgeDirection from) {
        return this.storedEnergy;
    }

    @Override
    public double getMaxTorqueInput(ForgeDirection from) {
        return this.maxInput;
    }

    @Override
    public boolean canInputTorque(ForgeDirection from) {
        return true;
    }

    public String getCrafterName() {
        return ItemResearchBook.getResearcherName(this.bookInventory.func_70301_a(0));
    }

    public void func_145845_h() {
        boolean started;
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        String name = this.getCrafterName();
        if (name == null) {
            return;
        }
        int goal = ResearchTracker.INSTANCE.getCurrentGoal(this.field_145850_b, name);
        boolean bl = started = goal >= 0;
        if (started && this.storedEnergy >= AWCoreStatics.energyPerResearchUnit) {
            this.workTick(name, goal, 1);
        } else if (!started) {
            --this.startCheckDelay;
            if (this.startCheckDelay <= 0) {
                this.tryStartNextResearch(name);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.bookInventory.readFromNBT(tag.func_74775_l("bookInventory"));
        this.resourceInventory.readFromNBT(tag.func_74775_l("resourceInventory"));
        this.useAdjacentInventory = tag.func_74767_n("useAdjacentInventory");
        this.storedEnergy = tag.func_74769_h("storedEnergy");
        if (tag.func_74764_b("orientation")) {
            this.setPrimaryFacing(ForgeDirection.values()[tag.func_74762_e("orientation")]);
        }
        this.inventoryDirection = ForgeDirection.getOrientation((int)tag.func_74762_e("inventoryDirection"));
        this.inventorySide = ForgeDirection.getOrientation((int)tag.func_74762_e("inventorySide"));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74782_a("bookInventory", (NBTBase)this.bookInventory.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("resourceInventory", (NBTBase)this.resourceInventory.writeToNBT(new NBTTagCompound()));
        tag.func_74757_a("useAdjacentInventory", this.useAdjacentInventory);
        tag.func_74780_a("storedEnergy", this.storedEnergy);
        tag.func_74768_a("orientation", this.orientation.ordinal());
        tag.func_74768_a("inventoryDirection", this.inventoryDirection.ordinal());
        tag.func_74768_a("inventorySide", this.inventorySide.ordinal());
    }

    @Override
    public boolean hasWork() {
        return this.storedEnergy < this.maxEnergyStored;
    }

    private void workTick(String name, int goal, int tickCount) {
        ResearchGoal g1 = ResearchGoal.getGoal(goal);
        int progress = ResearchTracker.INSTANCE.getProgress(this.field_145850_b, name);
        if ((progress += tickCount) >= g1.getTotalResearchTime()) {
            ResearchTracker.INSTANCE.finishResearch(this.field_145850_b, this.getCrafterName(), goal);
            this.tryStartNextResearch(name);
        } else {
            ResearchTracker.INSTANCE.setProgress(this.field_145850_b, name, progress);
        }
        this.storedEnergy -= AWCoreStatics.energyPerResearchUnit;
    }

    private void tryStartNextResearch(String name) {
        List<Integer> queue = ResearchTracker.INSTANCE.getResearchQueueFor(this.field_145850_b, name);
        if (!queue.isEmpty()) {
            int goalId = queue.get(0);
            ResearchGoal goalInstance = ResearchGoal.getGoal(goalId);
            if (goalInstance == null) {
                return;
            }
            if (goalInstance.tryStart((IInventory)this.resourceInventory, -1)) {
                ResearchTracker.INSTANCE.startResearch(this.field_145850_b, name, goalId);
            } else if (this.useAdjacentInventory) {
                boolean started = false;
                int x = this.field_145851_c + this.inventoryDirection.offsetX;
                int y = this.field_145848_d + this.inventoryDirection.offsetY;
                int z = this.field_145849_e + this.inventoryDirection.offsetZ;
                TileEntity t = this.field_145850_b.func_147438_o(x, y, z);
                if (t instanceof IInventory) {
                    int side = this.inventorySide.ordinal();
                    started = goalInstance.tryStart((IInventory)t, side);
                }
                if (started) {
                    ResearchTracker.INSTANCE.startResearch(this.field_145850_b, name, goalId);
                }
            }
        }
        this.startCheckDelay = this.startCheckDelayMax;
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.RESEARCH;
    }

    @Override
    public final Team getTeam() {
        return this.field_145850_b.func_96441_U().func_96509_i(this.getOwnerName());
    }

    public int func_70302_i_() {
        return this.bookInventory.func_70302_i_() + this.resourceInventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        if (var1 < this.bookInventory.func_70302_i_()) {
            return this.bookInventory.func_70301_a(var1);
        }
        return this.resourceInventory.func_70301_a(var1 - this.bookInventory.func_70302_i_());
    }

    public ItemStack func_70298_a(int var1, int var2) {
        if (var1 < this.bookInventory.func_70302_i_()) {
            return this.bookInventory.func_70298_a(var1, var2);
        }
        return this.resourceInventory.func_70298_a(var1 - this.bookInventory.func_70302_i_(), var2);
    }

    public ItemStack func_70304_b(int var1) {
        if (var1 < this.bookInventory.func_70302_i_()) {
            return this.bookInventory.func_70304_b(var1);
        }
        return this.resourceInventory.func_70304_b(var1 - this.bookInventory.func_70302_i_());
    }

    public void func_70299_a(int var1, ItemStack var2) {
        if (var1 < this.bookInventory.func_70302_i_()) {
            this.bookInventory.func_70299_a(var1, var2);
            return;
        }
        this.resourceInventory.func_70299_a(var1 - this.bookInventory.func_70302_i_(), var2);
    }

    public void func_76316_a(InventoryBasic internal) {
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "research.station";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return var1 >= this.bookInventory.func_70302_i_() || ItemResearchBook.getResearcherName(var2) != null;
    }

    @Override
    public void addEnergyFromWorker(IWorker worker) {
        this.storedEnergy += AWCoreStatics.energyPerWorkUnit * (double)worker.getWorkEffectiveness(this.getWorkType());
        if (this.storedEnergy > this.getMaxTorque(null)) {
            this.storedEnergy = this.getMaxTorque(null);
        }
    }

    @Override
    public void addEnergyFromPlayer(EntityPlayer player) {
        this.storedEnergy += AWCoreStatics.energyPerWorkUnit;
        if (this.storedEnergy > this.getMaxTorque(null)) {
            this.storedEnergy = this.getMaxTorque(null);
        }
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 12, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public ForgeDirection getPrimaryFacing() {
        return this.orientation;
    }

    @Override
    public void setPrimaryFacing(ForgeDirection face) {
        this.orientation = face;
    }

    @Override
    public double drainTorque(ForgeDirection from, double energy) {
        return 0.0;
    }
}

