/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.shadowmage.ancientwarfare.core.util.Json;

public class JsonTagReader {
    public static NBTTagCompound parseTagCompound(String tag) {
        Json.JsonObject object = Json.parseJson(tag);
        return JsonTagReader.getTagFrom(object);
    }

    public static NBTTagCompound getTagFrom(Json.JsonObject compoundTagObject) {
        return (NBTTagCompound)JsonTagReader.getTagFor(compoundTagObject);
    }

    private static NBTBase getTagFor(Json.JsonObject jsonTagBase) {
        Json.JsonValue val = jsonTagBase.getValue("id");
        String id = val.getStringValue();
        Json.JsonAbstract value = jsonTagBase.getAbstract("val");
        if ("ct".equals(id)) {
            return JsonTagReader.getCompoundTagFor((Json.JsonObject)value);
        }
        if ("ls".equals(id)) {
            return JsonTagReader.getListTagFor((Json.JsonArray)value);
        }
        if ("pb".equals(id)) {
            return JsonTagReader.getByteTagFor((Json.JsonValue)value);
        }
        if ("ps".equals(id)) {
            return JsonTagReader.getShortTagFor((Json.JsonValue)value);
        }
        if ("pi".equals(id)) {
            return JsonTagReader.getIntTagFor((Json.JsonValue)value);
        }
        if ("pl".equals(id)) {
            return JsonTagReader.getLongTagFor((Json.JsonValue)value);
        }
        if ("pf".equals(id)) {
            return JsonTagReader.getFloatTagFor((Json.JsonValue)value);
        }
        if ("pd".equals(id)) {
            return JsonTagReader.getDoubleTagFor((Json.JsonValue)value);
        }
        if ("ab".equals(id)) {
            return JsonTagReader.getByteArrayTagFor((Json.JsonArray)value);
        }
        if ("ai".equals(id)) {
            return JsonTagReader.getIntArrayTagFor((Json.JsonArray)value);
        }
        if ("ss".equals(id)) {
            return JsonTagReader.getStringTagFor((Json.JsonValue)value);
        }
        return null;
    }

    private static NBTTagCompound getCompoundTagFor(Json.JsonObject compoundTagValues) {
        NBTTagCompound tag = new NBTTagCompound();
        for (String key : compoundTagValues.keySet()) {
            tag.func_74782_a(key, JsonTagReader.getTagFor(compoundTagValues.getObject(key)));
        }
        return tag;
    }

    private static NBTTagList getListTagFor(Json.JsonArray listTagValues) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < listTagValues.size(); ++i) {
            list.func_74742_a(JsonTagReader.getTagFor(listTagValues.getObject(i)));
        }
        return list;
    }

    private static NBTTagIntArray getIntArrayTagFor(Json.JsonArray value) {
        int[] array = new int[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            array[i] = (int)value.getValue(i).getIntegerValue();
        }
        return new NBTTagIntArray(array);
    }

    private static NBTTagByteArray getByteArrayTagFor(Json.JsonArray value) {
        byte[] array = new byte[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            array[i] = (byte)value.getValue(i).getIntegerValue();
        }
        return new NBTTagByteArray(array);
    }

    private static NBTTagByte getByteTagFor(Json.JsonValue value) {
        return new NBTTagByte((byte)value.getIntegerValue());
    }

    private static NBTTagShort getShortTagFor(Json.JsonValue value) {
        return new NBTTagShort((short)value.getIntegerValue());
    }

    private static NBTTagInt getIntTagFor(Json.JsonValue value) {
        return new NBTTagInt((int)value.getIntegerValue());
    }

    private static NBTTagLong getLongTagFor(Json.JsonValue value) {
        return new NBTTagLong(value.getIntegerValue());
    }

    private static NBTTagFloat getFloatTagFor(Json.JsonValue value) {
        return new NBTTagFloat((float)value.getFloatValue());
    }

    private static NBTTagDouble getDoubleTagFor(Json.JsonValue value) {
        return new NBTTagDouble(value.getFloatValue());
    }

    private static NBTTagString getStringTagFor(Json.JsonValue value) {
        return new NBTTagString(value.getStringValue());
    }
}

