/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.Trig;

public class RayTraceUtils {
    public static MovingObjectPosition getPlayerTarget(EntityPlayer player, float range, float border) {
        HashSet<Entity> excluded = new HashSet<Entity>();
        excluded.add((Entity)player);
        if (player.field_70154_o != null) {
            excluded.add(player.field_70154_o);
        }
        float yOffset = player.field_70170_p.field_72995_K ? 0.0f : 1.62f;
        Vec3 look = player.func_70040_Z();
        look.field_72450_a *= (double)range;
        look.field_72448_b *= (double)range;
        look.field_72449_c *= (double)range;
        look.field_72450_a += player.field_70165_t;
        look.field_72448_b += player.field_70163_u + (double)yOffset;
        look.field_72449_c += player.field_70161_v;
        return RayTraceUtils.tracePath(player.field_70170_p, player.field_70165_t, player.field_70163_u + (double)yOffset, player.field_70161_v, look.field_72450_a, look.field_72448_b, look.field_72449_c, border, excluded);
    }

    public static MovingObjectPosition tracePathWithYawPitch(World world, float x, float y, float z, float yaw, float pitch, float range, float borderSize, HashSet<Entity> excluded) {
        float tx = x + Trig.sinDegrees(yaw + 180.0f) * range * Trig.cosDegrees(pitch);
        float ty = -Trig.sinDegrees(pitch) * range + y;
        float tz = z + Trig.cosDegrees(yaw) * range * Trig.cosDegrees(pitch);
        return RayTraceUtils.tracePath(world, x, y, z, tx, ty, tz, borderSize, excluded);
    }

    public static MovingObjectPosition tracePath(World world, double x, double y, double z, double tx, double ty, double tz, float borderSize, HashSet<Entity> excluded) {
        double minX = x < tx ? x : tx;
        double minY = y < ty ? y : ty;
        double minZ = z < tz ? z : tz;
        double maxX = x > tx ? x : tx;
        double maxY = y > ty ? y : ty;
        double maxZ = z > tz ? z : tz;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
        List allEntities = world.func_72839_b(null, bb);
        Entity closestHitEntity = null;
        float closestHit = Float.POSITIVE_INFINITY;
        Vec3 startVec = Vec3.func_72443_a((double)x, (double)y, (double)z);
        Vec3 endVec = Vec3.func_72443_a((double)tx, (double)ty, (double)tz);
        for (Entity ent : allEntities) {
            float currentHit;
            float entBorder;
            MovingObjectPosition intercept;
            AxisAlignedBB entityBb;
            if (!ent.func_70067_L() || excluded.contains(ent) || (entityBb = ent.field_70121_D) == null || (intercept = entityBb.func_72314_b((double)(entBorder = ent.func_70111_Y()), (double)entBorder, (double)entBorder).func_72327_a(startVec, endVec)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(startVec)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            closestHitEntity = ent;
        }
        if (closestHitEntity != null) {
            return new MovingObjectPosition(closestHitEntity);
        }
        startVec = Vec3.func_72443_a((double)x, (double)y, (double)z);
        endVec = Vec3.func_72443_a((double)tx, (double)ty, (double)tz);
        return world.func_72933_a(startVec, endVec);
    }
}

