/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemRecord;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class SongPlayData {
    private boolean random = false;
    private boolean playOnPlayerEntry = false;
    private int minDelay;
    private int maxDelay;
    private List<SongEntry> tunes = new ArrayList<SongEntry>();

    public int size() {
        return this.tunes.size();
    }

    public SongEntry get(int index) {
        return this.tunes.get(index);
    }

    public void addNewEntry() {
        SongEntry e = new SongEntry();
        this.tunes.add(e);
    }

    public void decrementEntry(int index) {
        if (index <= 0 || index >= this.tunes.size()) {
            return;
        }
        SongEntry e = this.tunes.remove(index);
        this.tunes.add(--index, e);
    }

    public void incrementEntry(int index) {
        if (index < 0 || index >= this.tunes.size() - 1) {
            return;
        }
        SongEntry e = this.tunes.remove(index);
        this.tunes.add(++index, e);
    }

    public void deleteEntry(int index) {
        if (index < 0 || index >= this.tunes.size()) {
            return;
        }
        this.tunes.remove(index);
    }

    public int getMinDelay() {
        return this.minDelay;
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public boolean getPlayOnPlayerEntry() {
        return this.playOnPlayerEntry;
    }

    public boolean getIsRandom() {
        return this.random;
    }

    public void setMinDelay(int val) {
        this.minDelay = val;
    }

    public void setMaxDelay(int val) {
        this.maxDelay = val;
    }

    public void setPlayOnPlayerEntry(boolean val) {
        this.playOnPlayerEntry = val;
    }

    public void setRandom(boolean val) {
        this.random = val;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.minDelay = tag.func_74762_e("minDelay");
        this.maxDelay = tag.func_74762_e("maxDelay");
        this.random = tag.func_74767_n("random");
        this.playOnPlayerEntry = tag.func_74767_n("playerEntry");
        this.tunes.clear();
        NBTTagList l = tag.func_150295_c("entries", 10);
        for (int i = 0; i < l.func_74745_c(); ++i) {
            SongEntry d = new SongEntry();
            d.readFromNBT(l.func_150305_b(i));
            this.tunes.add(d);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("minDelay", this.minDelay);
        tag.func_74768_a("maxDelay", this.maxDelay);
        tag.func_74757_a("random", this.random);
        tag.func_74757_a("playerEntry", this.playOnPlayerEntry);
        NBTTagList l = new NBTTagList();
        for (SongEntry tune : this.tunes) {
            l.func_74742_a((NBTBase)tune.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("entries", (NBTBase)l);
        return tag;
    }

    public static final class SongEntry {
        String name = "";
        float length = 5.0f;
        int volume = 100;

        public void setLength(float length) {
            this.length = length;
        }

        public void setName(String name) {
            if (name == null) {
                this.name = "";
            } else {
                boolean isRecord;
                this.name = name;
                ResourceLocation resource = new ResourceLocation(name);
                boolean bl = isRecord = resource.func_110623_a().startsWith("records.") || ItemRecord.func_150926_b((String)("records." + resource.func_110623_a())) != null;
                if (isRecord && this.length() < 120.0f) {
                    this.setLength(120.0f);
                }
            }
        }

        public void setVolume(int volume) {
            this.volume = volume;
        }

        public int volume() {
            return this.volume;
        }

        public String name() {
            return this.name;
        }

        public float length() {
            return this.length;
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.name = tag.func_74779_i("name");
            this.length = tag.func_74760_g("length");
            this.volume = tag.func_74762_e("volume");
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            if (this.name != null && !this.name.isEmpty()) {
                tag.func_74778_a("name", this.name);
            }
            tag.func_74776_a("length", this.length);
            tag.func_74768_a("volume", this.volume);
            return tag;
        }

        public int play(World world, int x, int y, int z) {
            world.func_72934_a(null, x, y, z);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.name, (float)this.volume * 0.03f, 1.0f);
            return (int)(this.length * 20.0f);
        }
    }
}

