/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import cpw.mods.fml.common.registry.GameData;
import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;

public class StringTools {
    public static String getCSVfor(Set<String> values) {
        StringBuilder b = new StringBuilder();
        Iterator<String> it = values.iterator();
        while (it.hasNext()) {
            b.append(it.next());
            if (!it.hasNext()) continue;
            b.append(",");
        }
        return b.toString();
    }

    public static Set<String> safeParseStringsToSet(Set<String> toFill, String test, String line, boolean lowerCase) {
        String[] lines = StringTools.safeParseStringArray("=", line);
        return StringTools.parseStringsToSet(toFill, lines, lowerCase);
    }

    public static Set<String> parseStringsToSet(Set<String> toFill, String[] data, boolean lowerCase) {
        for (String name : data) {
            toFill.add(lowerCase ? name.toLowerCase(Locale.ENGLISH) : name);
        }
        return toFill;
    }

    public static String getCSVStringForArray(float[] values) {
        String line = "";
        for (int i = 0; i < values.length; ++i) {
            if (i >= 1) {
                line = line + ",";
            }
            line = line + values[i];
        }
        return line;
    }

    public static String getCSVStringForArray(byte[] values) {
        String line = "";
        for (int i = 0; i < values.length; ++i) {
            if (i >= 1) {
                line = line + ",";
            }
            line = line + values[i];
        }
        return line;
    }

    public static String getCSVStringForArray(int[] values) {
        if (values == null) {
            return "";
        }
        String line = "";
        for (int i = 0; i < values.length; ++i) {
            if (i >= 1) {
                line = line + ",";
            }
            line = line + values[i];
        }
        return line;
    }

    public static String getCSVValueFor(String[] values) {
        String line = "";
        for (int i = 0; i < values.length; ++i) {
            if (i >= 1) {
                line = line + ",";
            }
            line = line + values[i];
        }
        return line;
    }

    public static int[] safeParseIntArray(String regex, String test) {
        String[] splits = test.split(regex);
        if (splits.length > 1) {
            return StringTools.parseIntArray(splits[1]);
        }
        return new int[0];
    }

    public static int[] parseIntArray(String csv) {
        String[] splits = csv.split(",");
        int[] array = new int[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            array[i] = Integer.parseInt(splits[i].trim());
        }
        return array;
    }

    public static short[] safeParseShortArray(String regex, String test) {
        String[] splits = test.split(regex);
        if (splits.length > 1) {
            return StringTools.parseShortArray(splits[1]);
        }
        return new short[0];
    }

    public static short[] parseShortArray(String csv) {
        String[] splits = csv.split(",");
        short[] array = new short[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            array[i] = Short.parseShort(splits[i].trim());
        }
        return array;
    }

    public static byte[] safeParseByteArray(String regex, String test) {
        String[] splits = test.split(regex);
        if (splits.length > 1) {
            return StringTools.parseByteArray(splits[1].trim());
        }
        return new byte[0];
    }

    public static byte[] parseByteArray(String csv) {
        String[] splits = csv.split(",");
        byte[] array = new byte[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            array[i] = Byte.parseByte(splits[i].trim());
        }
        return array;
    }

    public static float[] safeParseFloatArray(String regex, String test) {
        String[] splits = test.split(regex);
        if (splits.length > 1) {
            return StringTools.parseFloatArray(splits[1].trim());
        }
        return new float[0];
    }

    public static float[] parseFloatArray(String csv) {
        String[] splits = csv.split(",");
        float[] array = new float[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            array[i] = Float.parseFloat(splits[i].trim());
        }
        return array;
    }

    public static String[] safeParseStringArray(String regex, String test) {
        String[] splits = test.split(regex);
        if (splits.length > 1) {
            return StringTools.parseStringArray(splits[1]);
        }
        splits = new String[]{};
        return splits;
    }

    public static String[] parseStringArray(String csv) {
        return csv.split(",", -1);
    }

    public static String subStringBeginning(String in, int len) {
        return len > in.length() ? in : in.substring(0, len);
    }

    public static boolean safeParseBoolean(String regex, String test) {
        String[] split = test.split(regex);
        return split.length > 1 && Boolean.parseBoolean(split[1].trim());
    }

    public static boolean safeParseBoolean(String test) {
        return Boolean.parseBoolean(test);
    }

    public static boolean safeParseIntAsBoolean(String regex, String test) {
        String[] split = test.split(regex);
        return split.length > 1 && Integer.parseInt(split[1].trim()) == 1;
    }

    public static float safeParseFloat(String regex, String test) {
        String[] split = test.trim().split(regex);
        if (split.length > 1) {
            return StringTools.safeParseFloat(split[1]);
        }
        return 0.0f;
    }

    public static float safeParseFloat(String val) {
        try {
            return Float.parseFloat(val.trim());
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static String safeParseString(String regex, String test) {
        String[] split = test.split(regex);
        if (split.length > 1) {
            return split[1];
        }
        return "";
    }

    public static Item safeParseItem(String name) {
        Item item = (Item)GameData.getItemRegistry().func_82594_a(name);
        if (item == GameData.getItemRegistry().getDefaultValue()) {
            Block block = (Block)GameData.getBlockRegistry().func_82594_a(name);
            if (block == GameData.getBlockRegistry().getDefaultValue()) {
                return null;
            }
            return Item.func_150898_a((Block)block);
        }
        return item;
    }

    public static ItemStack safeParseStack(String name, String meta, String qty) {
        return StringTools.safeParseStack(name, meta, qty, true);
    }

    public static ItemStack safeParseStack(String name, String meta, String qty, boolean dictionary) {
        int i = StringTools.safeParseInt(qty);
        if (i <= 0) {
            return null;
        }
        Item item = StringTools.safeParseItem(name);
        if (item == null) {
            if (dictionary) {
                ArrayList list = OreDictionary.getOres((String)name);
                for (ItemStack temp : list) {
                    if (temp == null || temp.func_77976_d() < i) continue;
                    ItemStack result = temp.func_77946_l();
                    result.field_77994_a = i;
                    return result;
                }
            }
            return null;
        }
        return new ItemStack(item, i, StringTools.safeParseInt(meta));
    }

    public static int safeParseInt(String num) {
        try {
            return Integer.parseInt(num.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static double safeParseDouble(String num) {
        try {
            return Double.parseDouble(num.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public static long safeParseLong(String num) {
        try {
            return Long.parseLong(num.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static byte safeParseByte(String num) {
        try {
            return Byte.parseByte(num.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static short safeParseShort(String num) {
        try {
            return Short.parseShort(num.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int safeParseInt(String regex, String test) {
        String[] split = test.split(regex);
        if (split.length > 1) {
            return Integer.parseInt(split[1].trim());
        }
        return 0;
    }

    public static byte safeParseByte(String regex, String test) {
        String[] split = test.split(regex);
        if (split.length > 1) {
            return Byte.parseByte(split[1].trim());
        }
        return 0;
    }

    public static short safeParseShort(String regex, String test) {
        String[] split = test.split(regex);
        if (split.length > 1) {
            return Short.parseShort(split[1].trim());
        }
        return 0;
    }

    public static boolean isNumber(String test) {
        try {
            Integer.parseInt(test.trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static byte[] getByteArray(List<String> lines) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (String line : lines) {
            line = line + "\n";
            baos.write(line.getBytes("UTF-8"));
        }
        return baos.toByteArray();
    }

    public static List<String> getLines(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ArrayList<String> lines = new ArrayList<String>();
        Scanner scan = new Scanner((InputStream)bais, "UTF-8");
        while (scan.hasNext()) {
            lines.add(scan.nextLine());
        }
        scan.close();
        return lines;
    }

    public static List<String> getResourceLines(String path) {
        InputStream is = AncientWarfareCore.class.getResourceAsStream(path);
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                lines.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines;
    }

    public static void writeString(ByteBuf out, String string) {
        byte[] nameBytes = string.getBytes();
        out.writeShort(nameBytes.length);
        out.writeBytes(nameBytes);
    }

    public static String readString(ByteBuf in) {
        short len = in.readShort();
        byte[] nameBytes = new byte[len];
        in.readBytes(nameBytes);
        return new String(nameBytes);
    }

    public static boolean doStringsMatch(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return b != null && a.equals(b);
    }
}

