/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class Trig {
    public static final float PI = (float)Math.PI;
    public static final float TORADIANS = (float)Math.PI / 180;
    public static final float TODEGREES = 57.295776f;
    public static final float GRAVITY = 9.81f;
    public static final double gravityTick = 0.02452500104904175;

    private Trig() {
    }

    public static int getPower(int num, int exp) {
        return Double.valueOf(Math.floor(Math.pow(num, exp))).intValue();
    }

    public static float toRadians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static float toDegrees(float radians) {
        return radians * 57.295776f;
    }

    public static float cosDegrees(float degrees) {
        return MathHelper.func_76134_b((float)(degrees * ((float)Math.PI / 180)));
    }

    public static float sinDegrees(float degrees) {
        return MathHelper.func_76126_a((float)(degrees * ((float)Math.PI / 180)));
    }

    public static float cos(float radians) {
        return MathHelper.func_76134_b((float)radians);
    }

    public static float sin(float radians) {
        return MathHelper.func_76126_a((float)radians);
    }

    public static boolean getLineIntersection(Vec3 p0, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 out) {
        double s1_x = p1.field_72450_a - p0.field_72450_a;
        double s1_z = p1.field_72449_c - p0.field_72449_c;
        double s2_x = p3.field_72450_a - p2.field_72450_a;
        double s2_z = p3.field_72449_c - p2.field_72449_c;
        double s = (-s1_z * (p0.field_72450_a - p2.field_72450_a) + s1_x * (p0.field_72449_c - p2.field_72449_c)) / (-s2_x * s1_z + s1_x * s2_z);
        double t = (s2_x * (p0.field_72449_c - p2.field_72449_c) - s2_z * (p0.field_72450_a - p2.field_72450_a)) / (-s2_x * s1_z + s1_x * s2_z);
        if (s >= 0.0 && s <= 1.0 && t >= 0.0 && t <= 1.0) {
            if (out != null) {
                out.field_72450_a = p0.field_72450_a + t * s1_x;
                out.field_72449_c = p0.field_72449_c + t * s1_z;
            }
            return true;
        }
        return false;
    }

    public static boolean getLineIntersection2(Vec3 p0, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 out) {
        boolean denomPositive;
        double s10_x = p1.field_72450_a - p0.field_72450_a;
        double s32_y = p3.field_72449_c - p2.field_72449_c;
        double s32_x = p3.field_72450_a - p2.field_72450_a;
        double s10_y = p1.field_72449_c - p0.field_72449_c;
        double denom = s10_x * s32_y - s32_x * s10_y;
        if (denom == 0.0) {
            return false;
        }
        double s02_y = p0.field_72449_c - p2.field_72449_c;
        double s02_x = p0.field_72450_a - p2.field_72450_a;
        double s_numer = s10_x * s02_y - s10_y * s02_x;
        if (s_numer < 0.0 == (denomPositive = denom > 0.0)) {
            return false;
        }
        double t_numer = s32_x * s02_y - s32_y * s02_x;
        if (t_numer < 0.0 == denomPositive) {
            return false;
        }
        if (s_numer > denom == denomPositive || t_numer > denom == denomPositive) {
            return false;
        }
        double t = t_numer / denom;
        if (out != null) {
            out.field_72450_a = p0.field_72450_a + t * s10_x;
            out.field_72449_c = p0.field_72449_c + t * s10_y;
        }
        return true;
    }

    public static double getOverlap(double minA, double maxA, double minB, double maxB) {
        if (minA > maxB || maxA < minB) {
            return 0.0;
        }
        if (minA < minB) {
            return minB - maxA;
        }
        return maxB - minA;
    }

    public static double wrapTo360(double in) {
        while (in >= 360.0) {
            in -= 360.0;
        }
        while (in < 0.0) {
            in += 360.0;
        }
        return in;
    }

    public static float wrapTo360(float in) {
        while (in >= 360.0f) {
            in -= 360.0f;
        }
        while (in < 0.0f) {
            in += 360.0f;
        }
        return in;
    }

    public static boolean isBetween(int test, int a, int b) {
        if (a < b) {
            return test >= a && test <= b;
        }
        return test >= b && test <= a;
    }

    public static boolean isAngleBetween(float test, float min, float max) {
        test = Trig.wrapTo360(test);
        if ((min = Trig.wrapTo360(min)) > (max = Trig.wrapTo360(max))) {
            return test >= min || test <= max;
        }
        return test >= min && test <= max;
    }

    public static float getVelocity(float x, float y, float z) {
        return MathHelper.func_76129_c((float)(x * x + y * y + z * z));
    }

    public static float getVelocity(double x, double y, double z) {
        return MathHelper.func_76133_a((double)(x * x + y * y + z * z));
    }

    public static float getDistance(double x, double y, double z, double x1, double y1, double z1) {
        return Math.abs(Trig.getVelocity(x1 - x, y1 - y, z1 - z));
    }

    public static float getVelocity(double x, double z) {
        return MathHelper.func_76129_c((float)((float)(x * x + z * z)));
    }

    public static int getDifference(int a, int b) {
        return a < b ? b - a : a - b;
    }

    public static float getAngle(float x, float y) {
        return Trig.toDegrees((float)Math.atan2(y, x));
    }

    public static float getYawTowards(double x, double z, double tx, double tz) {
        float xAO = (float)(tx - x);
        float zAO = (float)(tz - z);
        float yaw = Trig.toDegrees((float)Math.atan2(zAO, xAO));
        for (yaw = -yaw; yaw < -180.0f; yaw += 360.0f) {
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw;
    }

    public static float getYawTowardsTarget(double xStart, double zStart, double x, double z, float originYaw) {
        float yawDiff;
        float vehYaw;
        float xAO = (float)(xStart - x);
        float zAO = (float)(zStart - z);
        float yaw = Trig.toDegrees((float)Math.atan2(xAO, zAO));
        for (vehYaw = originYaw; vehYaw < 0.0f; vehYaw += 360.0f) {
        }
        while (vehYaw >= 360.0f) {
            vehYaw -= 360.0f;
        }
        for (yawDiff = yaw - vehYaw; yawDiff < -180.0f; yawDiff += 360.0f) {
        }
        while (yawDiff >= 180.0f) {
            yawDiff -= 360.0f;
        }
        return yawDiff;
    }

    public static float getYawDifference(float yaw, float dest) {
        float diff;
        for (diff = Math.abs(dest - yaw); diff < -180.0f; diff += 360.0f) {
        }
        while (diff >= 180.0f) {
            diff -= 360.0f;
        }
        return diff;
    }

    public static byte getTurnDirection(float yaw, float dest) {
        float diff = Math.signum(Trig.getYawDifference(yaw, dest));
        return (byte)diff;
    }

    public static double min(double ... vals) {
        double min = vals[0];
        for (int i = 1; i < vals.length; ++i) {
            if (!(vals[i] < min)) continue;
            min = vals[i];
        }
        return min;
    }

    public static double max(double ... vals) {
        double max = vals[0];
        for (int i = 1; i < vals.length; ++i) {
            if (!(vals[i] > max)) continue;
            max = vals[i];
        }
        return max;
    }

    public static float min(float ... vals) {
        float min = Float.MAX_VALUE;
        for (float val : vals) {
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static float max(float ... vals) {
        float max = Float.MIN_VALUE;
        for (float val : vals) {
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }
}

