/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.interfaces.INBTSerialable;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;

public class Zone
implements INBTSerialable {
    public BlockPosition min;
    public BlockPosition max;

    public Zone() {
        this.min = new BlockPosition();
        this.max = new BlockPosition();
    }

    public Zone(BlockPosition p1, BlockPosition p2) {
        this.min = BlockTools.getMin(p1, p2);
        this.max = BlockTools.getMax(p1, p2);
    }

    public boolean crossWith(Zone z) {
        return this.max.x >= z.min.x && this.max.y >= z.min.y && this.max.z >= z.min.z && this.min.x <= z.max.x && this.min.y <= z.max.y && this.min.z <= z.max.z;
    }

    public boolean isPositionIn(int x, int y, int z) {
        return x >= this.min.x && y >= this.min.y && z >= this.min.z && x <= this.max.x && z <= this.max.z && y <= this.max.y;
    }

    public boolean isPositionIn(BlockPosition pos) {
        return this.isPositionIn(pos.x, pos.y, pos.z);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.min = new BlockPosition(tag.func_74775_l("min"));
        this.max = new BlockPosition(tag.func_74775_l("max"));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74782_a("min", (NBTBase)this.min.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("max", (NBTBase)this.max.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    public boolean equals(BlockPosition min, BlockPosition max) {
        return min.equals(this.min) && max.equals(this.max);
    }

    public boolean equals(Object object) {
        return object instanceof Zone && this.equals(((Zone)object).min, ((Zone)object).max);
    }

    public int hashCode() {
        return 31 * this.min.hashCode() + this.max.hashCode();
    }

    public String toString() {
        return String.format("From %s to %s", this.min, this.max);
    }
}

