/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.nei_plugin;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.DefaultOverlayHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.shadowmage.ancientwarfare.automation.gui.GuiWarehouseCraftingStation;
import net.shadowmage.ancientwarfare.automation.gui.GuiWorksiteAutoCrafting;
import net.shadowmage.ancientwarfare.core.api.AWBlocks;
import net.shadowmage.ancientwarfare.core.api.ModuleStatus;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.gui.crafting.GuiEngineeringStation;
import net.shadowmage.ancientwarfare.core.interfaces.IResearchRecipe;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class AWNeiRecipeHandler
extends TemplateRecipeHandler {
    public AWNeiRecipeHandler() {
        API.registerRecipeHandler((ICraftingHandler)this);
        API.registerUsageHandler((IUsageHandler)this);
        this.register(GuiEngineeringStation.class, new DefaultOverlayHandler(37, 2));
        if (ModuleStatus.automationLoaded) {
            this.register(GuiWarehouseCraftingStation.class, new DefaultOverlayHandler(37, 2));
            this.register(GuiWorksiteAutoCrafting.class, new DefaultOverlayHandler(37, 2));
        }
        if (ModuleStatus.structuresLoaded) {
            API.hideItem((ItemStack)new ItemStack(AWBlocks.gateProxy));
        }
    }

    private void register(Class<? extends GuiContainer> cl, DefaultOverlayHandler handler) {
        API.registerGuiOverlay(cl, (String)"awcrafting", (int)handler.offsetx, (int)handler.offsety);
        API.registerGuiOverlayHandler(cl, (IOverlayHandler)handler, (String)"awcrafting");
        API.registerGuiOverlayHandler(cl, (IOverlayHandler)handler, (String)"crafting");
    }

    public String getRecipeName() {
        return "AW Crafting";
    }

    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    public String getOverlayIdentifier() {
        return "awcrafting";
    }

    public TemplateRecipeHandler newInstance() {
        this.arecipes.clear();
        return this;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(-31, 7, 18, 18), "awcrafting", new Object[0]));
    }

    public List<Class<? extends GuiContainer>> getRecipeTransferRectGuis() {
        LinkedList<Class<? extends GuiContainer>> list = new LinkedList<Class<? extends GuiContainer>>();
        list.add(GuiEngineeringStation.class);
        if (ModuleStatus.automationLoaded) {
            list.add(GuiWarehouseCraftingStation.class);
            list.add(GuiWorksiteAutoCrafting.class);
        }
        return list;
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<IResearchRecipe> allrecipes = AWCraftingManager.INSTANCE.getRecipes();
        for (IResearchRecipe irecipe : allrecipes) {
            if (!InventoryTools.doItemStacksMatch(irecipe.func_77571_b(), result)) continue;
            this.arecipes.add(new AWCachedRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<IResearchRecipe> allrecipes = AWCraftingManager.INSTANCE.getRecipes();
        for (IResearchRecipe irecipe : allrecipes) {
            for (Object target : irecipe.getInputs()) {
                if (target == null) continue;
                if (target instanceof ItemStack) {
                    if (!OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)ingredient, (boolean)false)) {
                        continue;
                    }
                } else if (target instanceof Iterable) {
                    boolean matched = false;
                    Iterator itr = ((Iterable)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)ingredient, (boolean)false);
                    }
                    if (!matched) continue;
                }
                this.arecipes.add(new AWCachedRecipe(irecipe));
            }
        }
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return super.hasOverlay(gui, container, recipe) || RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)"crafting");
    }

    public class AWCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final ArrayList<PositionedStack> ingredients;
        private final PositionedStack result;

        public AWCachedRecipe(IResearchRecipe recipe) {
            super((TemplateRecipeHandler)AWNeiRecipeHandler.this);
            this.result = new PositionedStack((Object)recipe.func_77571_b().func_77946_l(), 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(recipe.getRecipeWidth(), recipe.getRecipeHeight(), recipe.getInputs());
        }

        private void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(AWNeiRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

