/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.shadowmage.ancientwarfare.core.api.ModuleStatus;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.gamedata.WorldData;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.npc.block.AWNPCBlockLoader;
import net.shadowmage.ancientwarfare.npc.command.CommandDebugAI;
import net.shadowmage.ancientwarfare.npc.command.CommandFaction;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.container.ContainerCombatOrder;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcBard;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcCreativeControls;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcFactionBard;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcFactionTradeSetup;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcFactionTradeView;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcInventory;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcPlayerOwnedTrade;
import net.shadowmage.ancientwarfare.npc.container.ContainerRoutingOrder;
import net.shadowmage.ancientwarfare.npc.container.ContainerTownHall;
import net.shadowmage.ancientwarfare.npc.container.ContainerTradeOrder;
import net.shadowmage.ancientwarfare.npc.container.ContainerUpkeepOrder;
import net.shadowmage.ancientwarfare.npc.container.ContainerWorkOrder;
import net.shadowmage.ancientwarfare.npc.crafting.AWNpcCrafting;
import net.shadowmage.ancientwarfare.npc.entity.AWNPCEntityLoader;
import net.shadowmage.ancientwarfare.npc.event.EventHandler;
import net.shadowmage.ancientwarfare.npc.faction.FactionTracker;
import net.shadowmage.ancientwarfare.npc.item.AWNpcItemLoader;
import net.shadowmage.ancientwarfare.npc.network.PacketFactionUpdate;
import net.shadowmage.ancientwarfare.npc.network.PacketNpcCommand;
import net.shadowmage.ancientwarfare.npc.proxy.NpcCommonProxy;

@Mod(name="Ancient Warfare NPCs", modid="AncientWarfareNpc", version="2.4.114-beta-MC1.7.10", dependencies="required-after:AncientWarfare")
public class AncientWarfareNPC {
    @Mod.Instance(value="AncientWarfareNpc")
    public static AncientWarfareNPC instance;
    @SidedProxy(clientSide="net.shadowmage.ancientwarfare.npc.proxy.NpcClientProxy", serverSide="net.shadowmage.ancientwarfare.npc.proxy.NpcCommonProxy")
    public static NpcCommonProxy proxy;
    public static AWNPCStatics statics;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        ModuleStatus.npcsLoaded = true;
        statics = new AWNPCStatics("AncientWarfareNpc");
        proxy.registerClient();
        FMLCommonHandler.instance().bus().register((Object)FactionTracker.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
        AWNpcItemLoader.load();
        AWNPCBlockLoader.load();
        AWNPCEntityLoader.load();
        NetworkHandler.registerContainer(4, ContainerNpcInventory.class);
        NetworkHandler.registerContainer(34, ContainerWorkOrder.class);
        NetworkHandler.registerContainer(35, ContainerUpkeepOrder.class);
        NetworkHandler.registerContainer(36, ContainerCombatOrder.class);
        NetworkHandler.registerContainer(39, ContainerNpcFactionTradeSetup.class);
        NetworkHandler.registerContainer(42, ContainerNpcFactionTradeView.class);
        NetworkHandler.registerContainer(37, ContainerRoutingOrder.class);
        NetworkHandler.registerContainer(41, ContainerTownHall.class);
        NetworkHandler.registerContainer(43, ContainerNpcBard.class);
        NetworkHandler.registerContainer(44, ContainerNpcCreativeControls.class);
        NetworkHandler.registerContainer(6, ContainerTradeOrder.class);
        NetworkHandler.registerContainer(47, ContainerNpcPlayerOwnedTrade.class);
        NetworkHandler.registerContainer(49, ContainerNpcFactionBard.class);
        PacketBase.registerPacketType(12, PacketNpcCommand.class);
        PacketBase.registerPacketType(13, PacketFactionUpdate.class);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        AWNpcCrafting.loadRecipes();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        statics.postInitCallback();
        proxy.loadSkins();
        AWNPCEntityLoader.loadNpcSubtypeEquipment();
        statics.save();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
        if ("AncientWarfare".equals(evt.modID)) {
            statics.save();
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandFaction());
        evt.registerServerCommand((ICommand)new CommandDebugAI());
    }

    @SubscribeEvent
    public void worldLoaded(WorldEvent.Load evt) {
        WorldData d;
        if (!evt.world.field_72995_K && (d = AWGameData.INSTANCE.getPerWorldData(evt.world, WorldData.class)) != null) {
            AWNPCStatics.npcAIDebugMode = d.get("NpcAIDebugMode");
        }
    }
}

