/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;

public class NpcAIDoor
extends EntityAIBase {
    protected final EntityLiving theEntity;
    private final boolean close;
    protected int doorPosX;
    protected int doorPosY;
    protected int doorPosZ;
    protected Block door;
    private int timer;
    private float interactionPosX;
    private float interactionPosZ;
    private boolean allDoors;

    public NpcAIDoor(EntityLiving living, boolean closeBehind) {
        this.theEntity = living;
        this.close = closeBehind;
    }

    public EntityAIBase enableAllDoors() {
        this.allDoors = true;
        return this;
    }

    public final boolean func_75250_a() {
        PathNavigate pathnavigate = this.theEntity.func_70661_as();
        if (!pathnavigate.func_75507_c() || pathnavigate.func_75500_f()) {
            return false;
        }
        PathEntity pathentity = pathnavigate.func_75505_d();
        for (int i = 0; i < Math.min(pathentity.func_75873_e() + 2, pathentity.func_75874_d()); ++i) {
            PathPoint pathpoint = pathentity.func_75877_a(i);
            this.doorPosX = pathpoint.field_75839_a;
            this.doorPosZ = pathpoint.field_75838_c;
            if (!(this.theEntity.func_70092_e((double)this.doorPosX, this.theEntity.field_70163_u, (double)this.doorPosZ) <= 2.25)) continue;
            this.doorPosY = pathpoint.field_75837_b;
            if (this.findDoor()) {
                return true;
            }
            ++this.doorPosY;
            if (!this.findDoor()) continue;
            return true;
        }
        if (!this.theEntity.field_70123_F) {
            return false;
        }
        this.doorPosX = MathHelper.func_76128_c((double)this.theEntity.field_70165_t);
        this.doorPosY = MathHelper.func_76128_c((double)this.theEntity.field_70163_u);
        this.doorPosZ = MathHelper.func_76128_c((double)this.theEntity.field_70161_v);
        if (this.findDoor()) {
            return true;
        }
        ++this.doorPosY;
        return this.findDoor();
    }

    public final boolean func_75253_b() {
        return this.close && this.timer > 0;
    }

    public final void func_75249_e() {
        this.doDoorInteraction(true);
        this.timer = 20;
        this.interactionPosX = (float)((double)((float)this.doorPosX + 0.5f) - this.theEntity.field_70165_t);
        this.interactionPosZ = (float)((double)((float)this.doorPosZ + 0.5f) - this.theEntity.field_70161_v);
    }

    public final void func_75246_d() {
        --this.timer;
        float f = (float)((double)((float)this.doorPosX + 0.5f) - this.theEntity.field_70165_t);
        float f1 = (float)((double)((float)this.doorPosZ + 0.5f) - this.theEntity.field_70161_v);
        float f2 = this.interactionPosX * f + this.interactionPosZ * f1;
        if (f2 < 0.0f) {
            this.timer = 0;
        }
    }

    public final void func_75251_c() {
        if (this.close) {
            this.doDoorInteraction(false);
        }
    }

    protected boolean findDoor() {
        this.door = this.theEntity.field_70170_p.func_147439_a(this.doorPosX, this.doorPosY, this.doorPosZ);
        if (this.door instanceof BlockDoor) {
            return this.allDoors || this.door.func_149688_o() == Material.field_151575_d;
        }
        if (this.door instanceof BlockFenceGate) {
            return true;
        }
        this.door = null;
        return false;
    }

    protected void doDoorInteraction(boolean isOpening) {
        if (this.door instanceof BlockDoor) {
            ((BlockDoor)this.door).func_150014_a(this.theEntity.field_70170_p, this.doorPosX, this.doorPosY, this.doorPosZ, isOpening);
        } else if (this.door instanceof BlockFenceGate) {
            int meta = this.theEntity.field_70170_p.func_72805_g(this.doorPosX, this.doorPosY, this.doorPosZ);
            if (isOpening) {
                if (!BlockFenceGate.func_149896_b((int)meta)) {
                    int k1 = meta & 3;
                    int j1 = (MathHelper.func_76128_c((double)((double)(this.theEntity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) % 4;
                    if (k1 == (j1 + 2) % 4) {
                        meta = j1;
                    }
                    this.theEntity.field_70170_p.func_72921_c(this.doorPosX, this.doorPosY, this.doorPosZ, meta | 4, 2);
                    this.theEntity.field_70170_p.func_72889_a(null, 1003, this.doorPosX, this.doorPosY, this.doorPosZ, 0);
                    Block block = this.theEntity.field_70170_p.func_147439_a(this.doorPosX, this.doorPosY + 1, this.doorPosZ);
                    if (block instanceof BlockFenceGate && !BlockFenceGate.func_149896_b((int)(meta = this.theEntity.field_70170_p.func_72805_g(this.doorPosX, this.doorPosY + 1, this.doorPosZ)))) {
                        k1 = meta & 3;
                        if (k1 == (j1 + 2) % 4) {
                            meta = j1;
                        }
                        this.theEntity.field_70170_p.func_72921_c(this.doorPosX, this.doorPosY + 1, this.doorPosZ, meta | 4, 2);
                    }
                }
            } else if (BlockFenceGate.func_149896_b((int)meta)) {
                this.theEntity.field_70170_p.func_72921_c(this.doorPosX, this.doorPosY, this.doorPosZ, meta & 0xFFFFFFFB, 2);
                this.theEntity.field_70170_p.func_72889_a(null, 1003, this.doorPosX, this.doorPosY, this.doorPosZ, 0);
                Block block = this.theEntity.field_70170_p.func_147439_a(this.doorPosX, this.doorPosY + 1, this.doorPosZ);
                if (block instanceof BlockFenceGate && BlockFenceGate.func_149896_b((int)(meta = this.theEntity.field_70170_p.func_72805_g(this.doorPosX, this.doorPosY + 1, this.doorPosZ)))) {
                    this.theEntity.field_70170_p.func_72921_c(this.doorPosX, this.doorPosY + 1, this.doorPosZ, meta & 0xFFFFFFFB, 2);
                }
            }
        }
    }
}

