/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;

public class NpcAIFleeHostiles
extends NpcAI<NpcPlayerOwned> {
    private static int MAX_STAY_HOME = 400;
    private static int MAX_FLEE_RANGE = 16;
    private static int HEIGHT_CHECK = 7;
    private static int PURSUE_RANGE = 256;
    private final IEntitySelector selector = new IEntitySelector(){

        public boolean func_82704_a(Entity var1) {
            if (var1.func_70089_S()) {
                if (var1 instanceof NpcBase) {
                    return ((NpcBase)var1).isHostileTowards((Entity)NpcAIFleeHostiles.this.npc);
                }
                return AncientWarfareNPC.statics.shouldEntityTargetNpcs(EntityList.func_75621_b((Entity)var1));
            }
            return false;
        }
    };
    private final Comparator sorter;
    double distanceFromEntity = 16.0;
    private Vec3 fleeVector;
    private int stayAtHomeTimer = 0;

    public NpcAIFleeHostiles(NpcPlayerOwned npc) {
        super(npc);
        this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)npc);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!((NpcPlayerOwned)this.npc).getIsAIEnabled()) {
            return false;
        }
        List list = ((NpcPlayerOwned)this.npc).field_70170_p.func_82733_a(EntityLiving.class, ((NpcPlayerOwned)this.npc).field_70121_D.func_72314_b(this.distanceFromEntity, 3.0, this.distanceFromEntity), this.selector);
        if (list.isEmpty()) {
            return false;
        }
        Collections.sort(list, this.sorter);
        EntityLiving fleeTarget = (EntityLiving)list.get(0);
        boolean flee = false;
        if (((NpcPlayerOwned)this.npc).getTownHallPosition() != null || ((NpcPlayerOwned)this.npc).func_110175_bO()) {
            flee = true;
        } else {
            this.fleeVector = RandomPositionGenerator.func_75461_b((EntityCreature)this.npc, (int)MAX_FLEE_RANGE, (int)HEIGHT_CHECK, (Vec3)Vec3.func_72443_a((double)fleeTarget.field_70165_t, (double)fleeTarget.field_70163_u, (double)fleeTarget.field_70161_v));
            flee = this.fleeVector != null && !(fleeTarget.func_70092_e(this.fleeVector.field_72450_a, this.fleeVector.field_72448_b, this.fleeVector.field_72449_c) < fleeTarget.func_70068_e((Entity)this.npc));
        }
        if (flee) {
            ((NpcPlayerOwned)this.npc).func_70624_b((EntityLivingBase)fleeTarget);
        }
        return flee;
    }

    public boolean func_75253_b() {
        if (!((NpcPlayerOwned)this.npc).getIsAIEnabled() || ((NpcPlayerOwned)this.npc).func_70638_az() == null || ((NpcPlayerOwned)this.npc).func_70638_az().field_70128_L) {
            return false;
        }
        return this.stayAtHomeTimer != 0 || ((NpcPlayerOwned)this.npc).func_70638_az().func_70068_e((Entity)this.npc) < this.distanceFromEntity * this.distanceFromEntity;
    }

    public void func_75246_d() {
        double distSq;
        if (((NpcPlayerOwned)this.npc).func_70638_az() == null || ((NpcPlayerOwned)this.npc).func_70638_az().field_70128_L) {
            ((NpcPlayerOwned)this.npc).func_70624_b(null);
            this.stayAtHomeTimer = 0;
            return;
        }
        BlockPosition pos = null;
        if (((NpcPlayerOwned)this.npc).getTownHallPosition() != null) {
            pos = ((NpcPlayerOwned)this.npc).getTownHallPosition();
            distSq = ((NpcPlayerOwned)this.npc).getDistanceSq(pos);
        } else if (((NpcPlayerOwned)this.npc).func_110175_bO()) {
            distSq = ((NpcPlayerOwned)this.npc).getDistanceSqFromHome();
            ChunkCoordinates cc = ((NpcPlayerOwned)this.npc).func_110172_bL();
            pos = new BlockPosition(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
        } else {
            if (this.fleeVector == null) {
                return;
            }
            distSq = ((NpcPlayerOwned)this.npc).func_70092_e(this.fleeVector.field_72450_a, this.fleeVector.field_72448_b, this.fleeVector.field_72449_c);
            if (distSq > 9.0) {
                this.moveToPosition(this.fleeVector.field_72450_a, this.fleeVector.field_72448_b, this.fleeVector.field_72449_c, distSq);
            } else if (((NpcPlayerOwned)this.npc).func_70068_e((Entity)((NpcPlayerOwned)this.npc).func_70638_az()) < (double)PURSUE_RANGE) {
                this.fleeVector = RandomPositionGenerator.func_75461_b((EntityCreature)this.npc, (int)MAX_FLEE_RANGE, (int)HEIGHT_CHECK, (Vec3)Vec3.func_72443_a((double)((NpcPlayerOwned)this.npc).func_70638_az().field_70165_t, (double)((NpcPlayerOwned)this.npc).func_70638_az().field_70163_u, (double)((NpcPlayerOwned)this.npc).func_70638_az().field_70161_v));
                if (this.fleeVector == null) {
                    ((NpcPlayerOwned)this.npc).func_70624_b(null);
                }
            } else {
                ((NpcPlayerOwned)this.npc).func_70624_b(null);
            }
        }
        if (pos != null && distSq > 9.0) {
            this.moveToPosition(pos, distSq);
            this.stayAtHomeTimer = MAX_STAY_HOME;
        } else if (this.stayAtHomeTimer > 0) {
            --this.stayAtHomeTimer;
        }
    }

    public void func_75251_c() {
        this.fleeVector = null;
        ((NpcPlayerOwned)this.npc).func_70661_as().func_75499_g();
        ((NpcPlayerOwned)this.npc).func_70624_b(null);
    }
}

