/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.item.ItemNpcSpawner;
import net.shadowmage.ancientwarfare.npc.tile.TileTownHall;

public class NpcAIPriestPlayerOwned
extends NpcAI {
    int lastCheckTicks = -1;
    TileTownHall.NpcDeathEntry entryToRes;
    int resurrectionDelay = 0;

    public NpcAIPriestPlayerOwned(NpcBase npc) {
        super(npc);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.npc.getIsAIEnabled()) {
            return false;
        }
        return (this.lastCheckTicks == -1 || this.npc.field_70173_aa - this.lastCheckTicks > 200) && this.npc.getTownHall() != null && !this.npc.getTownHall().getDeathList().isEmpty();
    }

    public boolean func_75253_b() {
        if (!this.npc.getIsAIEnabled()) {
            return false;
        }
        return this.npc.getTownHall() != null && this.entryToRes != null && !this.entryToRes.resurrected && this.entryToRes.beingResurrected;
    }

    public void func_75249_e() {
        List<TileTownHall.NpcDeathEntry> list = this.npc.getTownHall().getDeathList();
        for (TileTownHall.NpcDeathEntry entry : list) {
            if (!entry.canRes || entry.resurrected || entry.beingResurrected) continue;
            this.entryToRes = entry;
            entry.beingResurrected = true;
            break;
        }
    }

    public void func_75246_d() {
        if (this.entryToRes == null || this.entryToRes.resurrected) {
            return;
        }
        BlockPosition pos = this.npc.getTownHallPosition();
        double dist = this.npc.func_70092_e((double)pos.x + 0.5, pos.y, (double)pos.z + 0.5);
        if (dist > 25.0) {
            this.moveToPosition(pos, dist);
            this.resurrectionDelay = 0;
        } else {
            ++this.resurrectionDelay;
            this.npc.func_71038_i();
            if (this.resurrectionDelay > 100) {
                this.resurrectionDelay = 0;
                this.resurrectTarget();
            }
        }
    }

    protected void resurrectTarget() {
        this.entryToRes.resurrected = true;
        this.entryToRes.beingResurrected = false;
        this.npc.getTownHall().informViewers();
        ItemStack stack = this.entryToRes.stackToSpawn;
        NpcBase resdNpc = ItemNpcSpawner.createNpcFromItem(this.npc.field_70170_p, stack);
        if (resdNpc != null) {
            resdNpc.ordersStack = null;
            resdNpc.upkeepStack = null;
            for (int i = 0; i < 5; ++i) {
                resdNpc.func_70062_b(i, null);
            }
            resdNpc.setShieldStack(null);
            resdNpc.func_70606_j(resdNpc.func_110138_aP() / 2.0f);
            resdNpc.func_70080_a(this.npc.field_70165_t, this.npc.field_70163_u, this.npc.field_70161_v, this.npc.field_70177_z, this.npc.field_70125_A);
            this.npc.field_70170_p.func_72838_d((Entity)resdNpc);
        }
        this.entryToRes = null;
    }

    public void func_75251_c() {
        if (this.entryToRes != null && !this.entryToRes.resurrected) {
            this.entryToRes.beingResurrected = false;
        }
        this.entryToRes = null;
    }
}

