/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IRangedAttackMob;
import net.shadowmage.ancientwarfare.npc.ai.AIHelper;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttack;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAIPlayerOwnedAttackRanged
extends NpcAIAttack<NpcBase> {
    private final IRangedAttackMob rangedAttacker;
    private double attackDistance = 256.0;

    public NpcAIPlayerOwnedAttackRanged(NpcBase npc) {
        super(npc);
        this.rangedAttacker = (IRangedAttackMob)npc;
        this.moveSpeed = 1.0;
    }

    @Override
    protected boolean shouldCloseOnTarget(double dist) {
        return dist > this.attackDistance || !this.npc.func_70635_at().func_75522_a((Entity)this.getTarget());
    }

    @Override
    protected void doAttack(double dist) {
        this.npc.removeAITask(512);
        this.npc.func_70661_as().func_75499_g();
        if (this.getAttackDelay() <= 0) {
            int val = AIHelper.doQuiverBowThing((EntityLiving)this.npc, (Entity)this.getTarget());
            if (val > 0) {
                this.setAttackDelay(val);
                return;
            }
            float pwr = (float)(this.attackDistance / dist);
            pwr = pwr < 0.1f ? 0.1f : (pwr > 1.0f ? 1.0f : pwr);
            this.rangedAttacker.func_82196_d(this.getTarget(), pwr);
            this.setAttackDelay(35);
        }
    }
}

