/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcWorker;

public class NpcAIPlayerOwnedFindWorksite
extends NpcAI<NpcWorker> {
    int lastExecuted = -1;
    int checkFrequency = 200;
    int range = 40;

    public NpcAIPlayerOwnedFindWorksite(NpcWorker npc) {
        super(npc);
    }

    public boolean func_75250_a() {
        if (!((NpcWorker)this.npc).getIsAIEnabled()) {
            return false;
        }
        return ((NpcWorker)this.npc).ordersStack == null && ((NpcWorker)this.npc).autoWorkTarget == null && (this.lastExecuted == -1 || ((NpcWorker)this.npc).field_70173_aa - this.lastExecuted > this.checkFrequency);
    }

    public boolean func_75253_b() {
        return false;
    }

    public void func_75249_e() {
        this.lastExecuted = ((NpcWorker)this.npc).field_70173_aa;
        if (((NpcWorker)this.npc).autoWorkTarget != null) {
            BlockPosition pos = ((NpcWorker)this.npc).autoWorkTarget;
            TileEntity te = ((NpcWorker)this.npc).field_70170_p.func_147438_o(pos.x, pos.y, pos.z);
            if (te instanceof IWorkSite) {
                IWorkSite site = (IWorkSite)te;
                if (!((NpcWorker)this.npc).canWorkAt(site.getWorkType()) || site.getTeam() != null && !site.getTeam().func_142054_a(((NpcWorker)this.npc).func_96124_cp()) || !site.hasWork()) {
                    ((NpcWorker)this.npc).autoWorkTarget = null;
                }
            } else {
                ((NpcWorker)this.npc).autoWorkTarget = null;
            }
        }
        if (((NpcWorker)this.npc).autoWorkTarget == null) {
            this.findWorkTarget();
        }
    }

    private void findWorkTarget() {
        int x = MathHelper.func_76128_c((double)((NpcWorker)this.npc).field_70165_t);
        int y = MathHelper.func_76128_c((double)((NpcWorker)this.npc).field_70163_u);
        int z = MathHelper.func_76128_c((double)((NpcWorker)this.npc).field_70161_v);
        List<TileEntity> tiles = WorldTools.getTileEntitiesInArea(((NpcWorker)this.npc).field_70170_p, x - this.range, y - this.range / 2, z - this.range, x + this.range, y + this.range / 2, z + this.range);
        TileEntity closestSite = null;
        double closestDist = -1.0;
        for (TileEntity te : tiles) {
            IWorkSite site;
            if (!(te instanceof IWorkSite) || (site = (IWorkSite)te).getTeam() != ((NpcWorker)this.npc).func_96124_cp() || !((NpcWorker)this.npc).canWorkAt(site.getWorkType()) || !site.hasWork()) continue;
            double dist = ((NpcWorker)this.npc).func_70092_e((double)te.field_145851_c + 0.5, te.field_145848_d, (double)te.field_145849_e + 0.5);
            if (closestDist != -1.0 && !(dist < closestDist)) continue;
            closestDist = dist;
            closestSite = te;
        }
        if (closestSite != null) {
            ((NpcWorker)this.npc).autoWorkTarget = new BlockPosition(closestSite.field_145851_c, closestSite.field_145848_d, closestSite.field_145849_e);
        }
    }
}

