/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityHorse;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.npc_command.NpcCommand;

public class NpcAIPlayerOwnedFollowCommand
extends NpcAI<NpcPlayerOwned> {
    BlockPosition moveTargetPos = null;

    public NpcAIPlayerOwnedFollowCommand(NpcPlayerOwned npc) {
        super(npc);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!((NpcPlayerOwned)this.npc).getIsAIEnabled()) {
            return false;
        }
        NpcCommand.Command cmd = ((NpcPlayerOwned)this.npc).getCurrentCommand();
        if (cmd == null) {
            return false;
        }
        if (cmd.type == NpcCommand.CommandType.GUARD || cmd.type == NpcCommand.CommandType.ATTACK_AREA) {
            return ((NpcPlayerOwned)this.npc).func_70638_az() == null;
        }
        return true;
    }

    public void func_75251_c() {
        NpcCommand.Command cmd = ((NpcPlayerOwned)this.npc).getCurrentCommand();
        if (!(cmd == null || ((NpcPlayerOwned)this.npc).func_70638_az() != null && cmd.type.isPersistent())) {
            ((NpcPlayerOwned)this.npc).handlePlayerCommand(null);
        }
    }

    public void func_75249_e() {
    }

    public void func_75246_d() {
        NpcCommand.Command cmd = ((NpcPlayerOwned)this.npc).getCurrentCommand();
        switch (cmd.type) {
            case CLEAR_HOME: {
                ((NpcPlayerOwned)this.npc).func_110177_bN();
                break;
            }
            case CLEAR_UPKEEP: {
                ((NpcPlayerOwned)this.npc).setUpkeepAutoPosition(null);
                break;
            }
            case SET_HOME: {
                ((NpcPlayerOwned)this.npc).func_110171_b(cmd.x, cmd.y, cmd.z, ((NpcPlayerOwned)this.npc).getHomeRange());
                break;
            }
            case SET_UPKEEP: {
                ((NpcPlayerOwned)this.npc).setUpkeepAutoPosition(new BlockPosition(cmd.x, cmd.y, cmd.z));
                break;
            }
            case CLEAR_COMMAND: 
            case ATTACK: {
                ((NpcPlayerOwned)this.npc).setPlayerCommand(null);
                break;
            }
            case ATTACK_AREA: {
                this.handleAttackMoveCommand(cmd);
                break;
            }
            case GUARD: {
                this.handleGuardCommand(cmd);
                break;
            }
            case MOVE: {
                this.handleMoveCommand(cmd);
                return;
            }
        }
        if (!cmd.type.isPersistent()) {
            ((NpcPlayerOwned)this.npc).setPlayerCommand(null);
        }
    }

    private void handleMoveCommand(NpcCommand.Command cmd) {
        double sqDist;
        if (this.moveTargetPos == null || this.moveTargetPos.x != cmd.x || this.moveTargetPos.y != cmd.y || this.moveTargetPos.z != cmd.z) {
            this.moveTargetPos = new BlockPosition(cmd.x, cmd.y, cmd.z);
        }
        if ((sqDist = ((NpcPlayerOwned)this.npc).getDistanceSq(this.moveTargetPos)) > 9.0) {
            this.moveToPosition(this.moveTargetPos, sqDist);
        } else {
            ((NpcPlayerOwned)this.npc).setPlayerCommand(null);
        }
    }

    private void handleGuardCommand(NpcCommand.Command cmd) {
        Entity e = cmd.getEntityTarget(((NpcPlayerOwned)this.npc).field_70170_p);
        if (e == null) {
            ((NpcPlayerOwned)this.npc).setPlayerCommand(null);
            return;
        }
        double sqDist = ((NpcPlayerOwned)this.npc).func_70068_e(e);
        if (sqDist > 9.0) {
            this.moveToEntity(e, sqDist);
        } else {
            ((NpcPlayerOwned)this.npc).func_70661_as().func_75499_g();
            if (e instanceof EntityHorse && e.field_70153_n == null) {
                ((NpcPlayerOwned)this.npc).func_70078_a(e);
                e.field_70126_B = e.field_70177_z = ((NpcPlayerOwned)this.npc).field_70177_z % 360.0f;
                ((NpcPlayerOwned)this.npc).setPlayerCommand(null);
            }
        }
    }

    private void handleAttackMoveCommand(NpcCommand.Command cmd) {
        double sqDist;
        if (this.moveTargetPos == null || this.moveTargetPos.x != cmd.x || this.moveTargetPos.y != cmd.y || this.moveTargetPos.z != cmd.z) {
            this.moveTargetPos = new BlockPosition(cmd.x, cmd.y, cmd.z);
        }
        if ((sqDist = ((NpcPlayerOwned)this.npc).getDistanceSq(this.moveTargetPos)) > 9.0) {
            this.moveToPosition(this.moveTargetPos, sqDist);
        } else {
            ((NpcPlayerOwned)this.npc).setPlayerCommand(null);
        }
    }
}

