/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.orders.CombatOrder;

public class NpcAIPlayerOwnedPatrol
extends NpcAI<NpcBase> {
    double moveSpeed = 1.0;
    boolean init = false;
    int patrolIndex;
    boolean atPoint;
    int ticksAtPoint;
    int maxTicksAtPoint = 50;
    public CombatOrder orders;
    ItemStack ordersStack;

    public NpcAIPlayerOwnedPatrol(NpcBase npc) {
        super(npc);
        this.func_75248_a(3);
    }

    public void onOrdersInventoryChanged() {
        this.patrolIndex = 0;
        this.ordersStack = this.npc.ordersStack;
        this.orders = CombatOrder.getCombatOrder(this.ordersStack);
    }

    public boolean func_75250_a() {
        if (!this.init) {
            this.init = true;
            this.ordersStack = this.npc.ordersStack;
            this.orders = CombatOrder.getCombatOrder(this.ordersStack);
            if (this.orders == null || this.patrolIndex >= this.orders.size()) {
                this.patrolIndex = 0;
            }
        }
        return this.func_75253_b();
    }

    public boolean func_75253_b() {
        if (!this.npc.getIsAIEnabled() || this.npc.func_70638_az() != null) {
            return false;
        }
        return this.orders != null && this.ordersStack != null && this.orders.getPatrolDimension() == this.npc.field_70170_p.field_73011_w.field_76574_g && !this.orders.isEmpty();
    }

    public void func_75249_e() {
        this.npc.addAITask(32);
    }

    public void func_75246_d() {
        if (this.atPoint) {
            this.npc.removeAITask(512);
            ++this.ticksAtPoint;
            if (this.ticksAtPoint > this.maxTicksAtPoint) {
                this.setMoveToNextPoint();
            }
        } else {
            BlockPosition pos = (BlockPosition)this.orders.get(this.patrolIndex);
            double dist = this.npc.func_70092_e((double)pos.x + 0.5, pos.y, (double)pos.z + 0.5);
            if (dist > 4.0) {
                this.moveToPosition(pos, dist);
            } else {
                this.atPoint = true;
                this.ticksAtPoint = 0;
            }
        }
    }

    private void setMoveToNextPoint() {
        this.atPoint = false;
        this.ticksAtPoint = 0;
        ++this.patrolIndex;
        this.moveRetryDelay = 0;
        if (this.patrolIndex >= this.orders.size()) {
            this.patrolIndex = 0;
        }
    }

    public void func_75251_c() {
        this.ticksAtPoint = 0;
        this.moveRetryDelay = 0;
        this.npc.removeAITask(544);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.patrolIndex = tag.func_74762_e("patrolIndex");
        this.atPoint = tag.func_74767_n("atPoint");
        this.ticksAtPoint = tag.func_74762_e("ticksAtPoint");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("patrolIndex", this.patrolIndex);
        tag.func_74757_a("atPoint", this.atPoint);
        tag.func_74768_a("ticksAtPoint", this.ticksAtPoint);
        return tag;
    }
}

