/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.shadowmage.ancientwarfare.core.inventory.InventoryBackpack;
import net.shadowmage.ancientwarfare.core.item.ItemBackpack;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.orders.TradeOrder;

public class NpcAIPlayerOwnedTrader
extends NpcAI<NpcPlayerOwned> {
    private boolean shelter;
    private boolean upkeep;
    private boolean restock;
    private boolean deposit;
    private boolean waiting;
    private boolean at_shelter;
    private boolean at_upkeep;
    private boolean at_deposit;
    private boolean at_withdraw;
    private boolean at_waypoint;
    private int delayCounter;
    private int waypointIndex;
    private BlockPosition waypoint;
    private BlockPosition shelterPoint;
    private TradeOrder orders;

    public NpcAIPlayerOwnedTrader(NpcPlayerOwned npc) {
        super(npc);
        this.func_75248_a(3);
    }

    public void onOrdersUpdated() {
        this.orders = TradeOrder.getTradeOrder(((NpcPlayerOwned)this.npc).ordersStack);
        this.waypoint = null;
        this.shelterPoint = null;
        this.upkeep = false;
        this.restock = false;
        this.deposit = false;
        this.waiting = false;
        this.at_deposit = false;
        this.at_shelter = false;
        this.at_upkeep = false;
        this.at_waypoint = false;
        this.at_withdraw = false;
        this.waypointIndex = 0;
        this.delayCounter = 0;
        if (this.orders != null && this.orders.getRoute().size() > 0) {
            this.waypoint = this.orders.getRoute().get(this.waypointIndex).getPosition();
        }
    }

    public boolean func_75250_a() {
        return this.orders != null && this.waypoint != null;
    }

    public void func_75249_e() {
    }

    public void func_75251_c() {
    }

    public void func_75246_d() {
        if (((NpcPlayerOwned)this.npc).shouldBeAtHome() || this.shelter) {
            this.updateShelter();
        } else if (this.upkeep) {
            this.updateUpkeep();
        } else if (this.restock) {
            this.updateRestock();
        } else {
            this.updatePatrol();
        }
    }

    private void updateShelter() {
        ((NpcPlayerOwned)this.npc).addAITask(8);
        this.shelter = true;
        if (this.at_shelter) {
            if (!((NpcPlayerOwned)this.npc).shouldBeAtHome()) {
                this.shelter = false;
                this.at_shelter = false;
                this.shelterPoint = null;
                this.upkeep = false;
                this.at_upkeep = false;
                this.deposit = false;
                this.restock = false;
                this.at_deposit = false;
                this.at_withdraw = false;
                this.waiting = false;
                this.delayCounter = 0;
                ((NpcPlayerOwned)this.npc).removeAITask(8);
            }
        } else if (this.shelterPoint == null) {
            double d2;
            int index = this.waypointIndex - 1;
            if (index < 0) {
                index = this.orders.getRoute().size() - 1;
            }
            BlockPosition wp2 = this.orders.getRoute().get(index).getPosition();
            double d1 = ((NpcPlayerOwned)this.npc).getDistanceSq(this.waypoint);
            this.shelterPoint = d1 < (d2 = ((NpcPlayerOwned)this.npc).getDistanceSq(wp2)) ? this.waypoint : wp2;
        } else {
            double d = ((NpcPlayerOwned)this.npc).getDistanceSq(this.shelterPoint);
            if (d > 9.0) {
                ((NpcPlayerOwned)this.npc).addAITask(512);
                this.moveToPosition(this.shelterPoint, d);
            } else {
                ((NpcPlayerOwned)this.npc).removeAITask(512);
                this.at_shelter = true;
            }
        }
    }

    private void updateUpkeep() {
        ((NpcPlayerOwned)this.npc).addAITask(2);
        if (this.at_upkeep) {
            if (this.tryWithdrawUpkeep()) {
                this.at_upkeep = false;
                this.upkeep = false;
                this.restock = true;
                this.deposit = true;
                ((NpcPlayerOwned)this.npc).removeAITask(2);
                ((NpcPlayerOwned)this.npc).removeAITask(4);
            }
        } else if (((NpcPlayerOwned)this.npc).getUpkeepPoint() != null) {
            double d = ((NpcPlayerOwned)this.npc).getDistanceSq(((NpcPlayerOwned)this.npc).getUpkeepPoint());
            if (d > 9.0) {
                ((NpcPlayerOwned)this.npc).addAITask(512);
                this.moveToPosition(((NpcPlayerOwned)this.npc).getUpkeepPoint(), d);
            } else {
                ((NpcPlayerOwned)this.npc).removeAITask(512);
                this.at_upkeep = true;
            }
        } else {
            ((NpcPlayerOwned)this.npc).addAITask(4);
            ((NpcPlayerOwned)this.npc).removeAITask(2);
        }
    }

    protected boolean tryWithdrawUpkeep() {
        BlockPosition p = ((NpcPlayerOwned)this.npc).getUpkeepPoint();
        TileEntity te = ((NpcPlayerOwned)this.npc).field_70170_p.func_147438_o(p.x, p.y, p.z);
        if (te instanceof IInventory) {
            return ((NpcPlayerOwned)this.npc).withdrawFood((IInventory)te, ((NpcPlayerOwned)this.npc).getUpkeepBlockSide());
        }
        return false;
    }

    private void updateRestock() {
        if (this.deposit) {
            this.updateDeposit();
        } else {
            this.updateWithdraw();
        }
    }

    private void updateDeposit() {
        if (this.at_deposit) {
            this.doDeposit();
            this.deposit = false;
            this.at_deposit = false;
        } else if (this.orders.getRestockData().getDepositPoint() != null) {
            BlockPosition p = this.orders.getRestockData().getDepositPoint();
            double d = ((NpcPlayerOwned)this.npc).getDistanceSq(p);
            if (d > 9.0) {
                ((NpcPlayerOwned)this.npc).addAITask(512);
                this.moveToPosition(p, d);
            } else {
                ((NpcPlayerOwned)this.npc).removeAITask(512);
                this.at_deposit = true;
            }
        } else {
            this.deposit = false;
        }
    }

    private void updateWithdraw() {
        if (this.at_withdraw) {
            this.doWithdraw();
            this.setNextWaypoint();
            this.restock = false;
            this.at_withdraw = false;
        } else if (this.orders.getRestockData().getWithdrawPoint() != null) {
            BlockPosition p = this.orders.getRestockData().getWithdrawPoint();
            double d = ((NpcPlayerOwned)this.npc).getDistanceSq(p);
            if (d > 9.0) {
                ((NpcPlayerOwned)this.npc).addAITask(512);
                this.moveToPosition(p, d);
            } else {
                ((NpcPlayerOwned)this.npc).removeAITask(512);
                this.at_withdraw = true;
            }
        } else {
            this.restock = false;
            this.setNextWaypoint();
        }
    }

    private void updatePatrol() {
        if (this.at_waypoint) {
            if (this.waiting) {
                ++this.delayCounter;
                if (this.delayCounter >= this.orders.getRoute().get(this.waypointIndex).getDelay()) {
                    this.delayCounter = 0;
                    this.waiting = false;
                    this.at_waypoint = false;
                    if (this.orders.getRoute().get(this.waypointIndex).shouldUpkeep()) {
                        this.upkeep = true;
                    } else {
                        this.setNextWaypoint();
                    }
                }
            } else {
                this.waiting = true;
                this.delayCounter = 0;
            }
        } else {
            ((NpcPlayerOwned)this.npc).addAITask(512);
            double d = ((NpcPlayerOwned)this.npc).getDistanceSq(this.waypoint);
            if (d < 9.0) {
                this.at_waypoint = true;
                this.waiting = false;
                ((NpcPlayerOwned)this.npc).removeAITask(512);
            } else {
                this.moveToPosition(this.waypoint, d);
            }
        }
    }

    private void setNextWaypoint() {
        ++this.waypointIndex;
        if (this.waypointIndex >= this.orders.getRoute().size()) {
            this.waypointIndex = 0;
        }
        this.waypoint = this.orders.getRoute().get(this.waypointIndex).getPosition();
    }

    private void doDeposit() {
        ItemStack backpack = ((NpcPlayerOwned)this.npc).func_70694_bm();
        if (backpack != null && backpack.func_77973_b() instanceof ItemBackpack) {
            InventoryBackpack inv = ItemBackpack.getInventoryFor(backpack);
            BlockPosition pos = this.orders.getRestockData().getDepositPoint();
            TileEntity te = ((NpcPlayerOwned)this.npc).field_70170_p.func_147438_o(pos.x, pos.y, pos.z);
            if (te instanceof IInventory) {
                IInventory dep = (IInventory)te;
                this.orders.getRestockData().doDeposit((IInventory)inv, dep, this.orders.getRestockData().getDepositSide());
                ItemBackpack.writeBackpackToItem(inv, backpack);
            }
        }
    }

    private void doWithdraw() {
        ItemStack backpack = ((NpcPlayerOwned)this.npc).func_70694_bm();
        if (backpack != null && backpack.func_77973_b() instanceof ItemBackpack) {
            InventoryBackpack inv = ItemBackpack.getInventoryFor(backpack);
            BlockPosition pos = this.orders.getRestockData().getWithdrawPoint();
            TileEntity te = ((NpcPlayerOwned)this.npc).field_70170_p.func_147438_o(pos.x, pos.y, pos.z);
            if (te instanceof IInventory) {
                this.orders.getRestockData().doWithdraw((IInventory)inv, (IInventory)te, this.orders.getRestockData().getWithdrawSide());
                ItemBackpack.writeBackpackToItem(inv, backpack);
            }
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.orders = TradeOrder.getTradeOrder(((NpcPlayerOwned)this.npc).ordersStack);
        this.waypointIndex = tag.func_74762_e("waypoint");
        this.waypoint = this.orders == null || this.orders.getRoute().size() == 0 ? null : this.orders.getRoute().get(this.waypointIndex).getPosition();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("waypoint", this.waypointIndex);
        return tag;
    }
}

