/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.orders.WorkOrder;

public class NpcAIPlayerOwnedWork
extends NpcAI<NpcBase> {
    public int ticksAtSite = 0;
    public int workIndex;
    public WorkOrder order;
    boolean init = false;

    public NpcAIPlayerOwnedWork(NpcBase npc) {
        super(npc);
        if (!(npc instanceof IWorker)) {
            throw new IllegalArgumentException("cannot instantiate work ai task on non-worker npc");
        }
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.init) {
            this.order = WorkOrder.getWorkOrder(this.npc.ordersStack);
            this.init = true;
            if (this.order == null || this.workIndex >= this.order.size()) {
                this.workIndex = 0;
            }
        }
        return this.func_75253_b();
    }

    public boolean func_75253_b() {
        if (!this.npc.getIsAIEnabled()) {
            return false;
        }
        if (this.npc.getFoodRemaining() <= 0 || this.npc.shouldBeAtHome()) {
            return false;
        }
        return this.order != null && !this.order.isEmpty();
    }

    public void func_75246_d() {
        WorkOrder.WorkEntry entry = (WorkOrder.WorkEntry)this.order.get(this.workIndex);
        BlockPosition pos = entry.getPosition();
        double dist = this.npc.func_70092_e(pos.x, pos.y, pos.z);
        if (dist > ((IWorker)((Object)this.npc)).getWorkRangeSq()) {
            this.npc.addAITask(512);
            this.ticksAtSite = 0;
            this.moveToPosition(pos, dist);
        } else {
            if (dist < 10.0 || this.shouldMoveFromTimeAtSite(entry) || this.shouldMoveFromNoWork(entry)) {
                this.npc.func_70661_as().func_75499_g();
                this.npc.removeAITask(512);
            }
            this.workAtSite(entry);
        }
    }

    public void func_75249_e() {
        this.npc.addAITask(16);
    }

    protected void workAtSite(WorkOrder.WorkEntry entry) {
        TileEntity te;
        BlockPosition pos;
        ++this.ticksAtSite;
        if (this.ticksAtSite == 1) {
            pos = entry.getPosition();
            te = this.npc.field_70170_p.func_147438_o(pos.x, pos.y, pos.z);
            if (!(te instanceof IWorkSite && ((IWorker)((Object)this.npc)).canWorkAt(((IWorkSite)te).getWorkType()) && ((IWorkSite)te).hasWork())) {
                this.setMoveToNextSite();
                return;
            }
        }
        if (this.npc.field_70173_aa % 10 == 0) {
            this.npc.func_71038_i();
        }
        if (this.ticksAtSite >= AWNPCStatics.npcWorkTicks) {
            IWorkSite site;
            this.ticksAtSite = 0;
            pos = entry.getPosition();
            te = this.npc.field_70170_p.func_147438_o(pos.x, pos.y, pos.z);
            if (te instanceof IWorkSite && ((IWorker)((Object)this.npc)).canWorkAt((site = (IWorkSite)te).getWorkType())) {
                if (site.hasWork()) {
                    this.npc.addExperience(AWNPCStatics.npcXpFromWork);
                    site.addEnergyFromWorker((IWorker)((Object)this.npc));
                } else if (this.shouldMoveFromNoWork(entry)) {
                    this.setMoveToNextSite();
                }
                if (this.shouldMoveFromTimeAtSite(entry)) {
                    this.setMoveToNextSite();
                }
                return;
            }
            this.setMoveToNextSite();
        }
    }

    protected boolean shouldMoveFromNoWork(WorkOrder.WorkEntry entry) {
        return !this.order.getPriorityType().isTimed() && this.order.size() > 1;
    }

    protected boolean shouldMoveFromTimeAtSite(WorkOrder.WorkEntry entry) {
        return this.order.getPriorityType().isTimed() && this.ticksAtSite > entry.getWorkLength();
    }

    protected void setMoveToNextSite() {
        this.ticksAtSite = 0;
        this.moveRetryDelay = 0;
        this.workIndex = this.order.getPriorityType().getNextWorkIndex(this.workIndex, this.order.getEntries(), this.npc);
    }

    public void onOrdersChanged() {
        this.order = WorkOrder.getWorkOrder(this.npc.ordersStack);
        this.workIndex = 0;
        this.ticksAtSite = 0;
    }

    public void func_75251_c() {
        this.ticksAtSite = 0;
        this.npc.removeAITask(528);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.ticksAtSite = tag.func_74762_e("ticksAtSite");
        this.workIndex = tag.func_74762_e("workIndex");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("ticksAtSite", this.ticksAtSite);
        tag.func_74768_a("workIndex", this.workIndex);
        return tag;
    }
}

