/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.command;

import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.faction.FactionTracker;

public class CommandFaction
extends CommandBase {
    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "awfaction";
    }

    public String func_71518_a(ICommandSender var1) {
        return "command.aw.faction.usage";
    }

    public void func_71515_b(ICommandSender var1, String[] var2) {
        block11: {
            String playerName;
            String cmd;
            block12: {
                block10: {
                    if (var2.length < 2) {
                        throw new WrongUsageException(this.func_71518_a(var1), new Object[0]);
                    }
                    cmd = var2[0];
                    playerName = var2[1];
                    if (!cmd.toLowerCase(Locale.ENGLISH).equals("set")) break block10;
                    if (var2.length < 4) {
                        throw new WrongUsageException("command.aw.faction.set.usage", new Object[0]);
                    }
                    String faction = var2[2];
                    if (!this.isFactionNameValid(faction)) {
                        throw new WrongUsageException("command.aw.faction.set.usage", new Object[0]);
                    }
                    String amount = var2[3];
                    int amt = 0;
                    try {
                        amt = Integer.parseInt(amount);
                    }
                    catch (NumberFormatException e) {
                        throw new WrongUsageException("command.aw.faction.set.usage", new Object[0]);
                    }
                    FactionTracker.INSTANCE.setStandingFor(var1.func_130014_f_(), playerName, faction, amt);
                    var1.func_145747_a((IChatComponent)new ChatComponentTranslation("command.aw.faction.set", new Object[]{playerName, faction, amt}));
                    break block11;
                }
                if (!cmd.toLowerCase(Locale.ENGLISH).equals("setall")) break block12;
                if (var2.length < 3) {
                    throw new WrongUsageException("command.aw.faction.setall.usage", new Object[0]);
                }
                String amount = var2[2];
                int amt = 0;
                try {
                    amt = Integer.parseInt(amount);
                }
                catch (NumberFormatException e) {
                    throw new WrongUsageException("command.aw.faction.setall.usage", new Object[0]);
                }
                for (String faction : AWNPCStatics.factionNames) {
                    FactionTracker.INSTANCE.setStandingFor(var1.func_130014_f_(), playerName, faction, amt);
                    var1.func_145747_a((IChatComponent)new ChatComponentTranslation("command.aw.faction.set", new Object[]{playerName, faction, amt}));
                }
                break block11;
            }
            if (!cmd.toLowerCase(Locale.ENGLISH).equals("get")) break block11;
            World world = var1.func_130014_f_();
            var1.func_145747_a((IChatComponent)new ChatComponentTranslation("command.aw.faction.status.player", new Object[]{playerName}));
            for (String faction : AWNPCStatics.factionNames) {
                int standing = FactionTracker.INSTANCE.getStandingFor(world, playerName, faction);
                var1.func_145747_a((IChatComponent)new ChatComponentTranslation("command.aw.faction.status.value", new Object[]{faction, standing}));
            }
        }
    }

    private boolean isFactionNameValid(String factionName) {
        for (String name : AWNPCStatics.factionNames) {
            if (!name.equalsIgnoreCase(factionName)) continue;
            return true;
        }
        return false;
    }

    public List func_71516_a(ICommandSender var1, String[] var2) {
        if (var2.length == 1) {
            return CommandBase.func_71530_a((String[])var2, (String[])new String[]{"set", "setall", "get"});
        }
        if (var2.length == 2) {
            return CommandBase.func_71530_a((String[])var2, (String[])MinecraftServer.func_71276_C().func_71213_z());
        }
        if (var2.length == 3) {
            if (var2[0].toLowerCase(Locale.ENGLISH).equals("set")) {
                return CommandBase.func_71530_a((String[])var2, (String[])AWNPCStatics.factionNames);
            }
        } else if (var2.length == 4) {
            // empty if block
        }
        return null;
    }

    public boolean func_82358_a(String[] var1, int var2) {
        return var2 == 1;
    }
}

