/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.shadowmage.ancientwarfare.core.config.ModConfiguration;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class AWNPCStatics
extends ModConfiguration {
    public static int maxNpcLevel = 10;
    public static int npcXpFromWork = 1;
    public static int npcXpFromTrade = 1;
    public static int npcXpFromAttack = 1;
    public static int npcXpFromKill = 5;
    public static int npcXpFromMoveItem = 1;
    public static int npcWorkTicks = 50;
    public static int npcDefaultUpkeepWithdraw = 6000;
    public static boolean npcAllowUpkeepAnyInventory = true;
    public static int townMaxRange = 100;
    public static int townUpdateFreq = 100;
    public static boolean exportEntityNames = false;
    public static boolean npcAIDebugMode = false;
    public static double npcLevelDamageMultiplier = 0.05;
    public static int npcArcherAttackDamage = 3;
    public static boolean loadDefaultSkinPack = true;
    public static Property renderAI;
    public static Property renderWorkPoints;
    public static Property renderFriendlyNames;
    public static Property renderHostileNames;
    public static Property renderFriendlyHealth;
    public static Property renderHostileHealth;
    public static Property renderTeamColors;
    private static final String recipeSettings = "04_recipe_settings";
    private Configuration foodConfig;
    private static final String foodSettings = "01_food_settings";
    private HashMap<String, Integer> foodValues;
    private int foodMultiplier = 750;
    private Configuration targetConfig;
    private static final String targetSettings = "01_target_settings";
    private HashMap<String, List<String>> entityTargetSettings;
    private List<String> entitiesToTargetNpcs;
    private Configuration factionConfig;
    private static final String factionSettings = "01_faction_settings";
    public static int factionLossOnDeath;
    public static int factionGainOnTrade;
    private HashMap<String, Integer> defaultFactionStandings;
    private HashMap<String, HashMap<String, Boolean>> factionVsFactionStandings;
    public static final String[] factionNames;
    public static final String[] factionNpcSubtypes;
    private Configuration valuesConfig;
    private HashMap<String, Attribute> attributes;
    private Configuration pathConfig;
    private HashMap<String, Path> pathValues;
    private static final String npcDefaultWeapons = "01_npc_weapons";
    private static final String npcOffhandItems = "02_npc_offhand";
    private static final String npcArmorHead = "03_npc_helmet";
    private static final String npcArmorChest = "04_npc_chest";
    private static final String npcArmorLegs = "05_npc_legs";
    private static final String npcArmorBoots = "06_npc_boots";
    private static final String npcWorkItem = "07_npc_work_slot";
    private static final String npcUpkeepItem = "08_npc_upkeep_slot";
    private Configuration equipmentConfig;
    private HashMap<String, String[]> eqmp;

    public AWNPCStatics(String mod) {
        super(mod);
    }

    @Override
    public void initializeCategories() {
        this.config.addCustomCategoryComment("01_shared_settings", "General Options\nAffect both client and server.  These configs must match for client and server, or\nstrange and probably BAD things WILL happen.");
        this.config.addCustomCategoryComment("02_server_settings", "Server Options\nAffect only server-side operations.  Will need to be set for dedicated servers, and single\nplayer (or LAN worlds).  Clients playing on remote servers can ignore these settings.");
        this.config.addCustomCategoryComment("03_client_settings", "Client Options\nAffect only client-side operations.  Many of these options can be set from the in-game Options GUI.\nServer admins can ignore these settings.");
        this.config.addCustomCategoryComment(recipeSettings, "Recipe Options\nEnable / Disable specific recipes, or remove the research requirements from specific recipes.\nAffect only server-side operations.  Will need to be set for dedicated servers, and single\nplayer (or LAN worlds).  Clients playing on remote servers can ignore these settings.");
        this.foodConfig = AWNPCStatics.getConfigFor("AncientWarfareNpcFood");
        this.foodConfig.addCustomCategoryComment(foodSettings, "Food Value Options\nThe value specified is the number of ticks that the item will feed the NPC for.\nAdd a new line for each item. The item type is not checked, and the default multiplier is not applied.\n0 or under will make the item unusable as a food.\nAffect only server-side operations.  Will need to be set for dedicated servers, and single\nplayer (or LAN worlds).  Clients playing on remote servers can ignore these settings.");
        this.targetConfig = AWNPCStatics.getConfigFor("AncientWarfareNpcTargeting");
        this.targetConfig.addCustomCategoryComment(targetSettings, "Custom NPC Targeting Options\nAdd / remove vanilla / mod-added entities from the NPC targeting lists.\nAffect only server-side operations.  Will need to be set for dedicated servers, and single\nplayer (or LAN worlds).  Clients playing on remote servers can ignore these settings.");
        this.factionConfig = AWNPCStatics.getConfigFor("AncientWarfareNpcFactionStandings");
        this.factionConfig.addCustomCategoryComment(factionSettings, "Faction Options\nSet starting faction values, and alter the amount of standing gained/lost from player actions.\nAffect only server-side operations.  Will need to be set for dedicated servers, and single\nplayer (or LAN worlds).  Clients playing on remote servers can ignore these settings.");
        this.equipmentConfig = AWNPCStatics.getConfigFor("AncientWarfareNpcEquipment");
        this.equipmentConfig.addCustomCategoryComment(npcDefaultWeapons, "Default Equipped Weapons\n");
        this.equipmentConfig.addCustomCategoryComment(npcOffhandItems, "Default Equipped Offhand Items\n");
        this.equipmentConfig.addCustomCategoryComment(npcArmorHead, "Default Equipped Helmets\n");
        this.equipmentConfig.addCustomCategoryComment(npcArmorChest, "Default Equipped Chest Armor\n");
        this.equipmentConfig.addCustomCategoryComment(npcArmorLegs, "Default Equipped Leg Armor\n");
        this.equipmentConfig.addCustomCategoryComment(npcArmorBoots, "Default Equipped Foot Armor\n");
        this.equipmentConfig.addCustomCategoryComment(npcWorkItem, "Default Equipped Order Item (drop-on-death only)\n");
        this.equipmentConfig.addCustomCategoryComment(npcUpkeepItem, "Default Equipped Upkeep Item (drop-on-death only)\n");
    }

    @Override
    public void initializeValues() {
        this.loadFoodValues();
        this.loadTargetValues();
        this.loadDefaultFactionStandings();
        this.initializeCustomValues();
        this.initializeNpcEquipmentConfigs();
        maxNpcLevel = this.config.get("02_server_settings", "npc_max_level", maxNpcLevel, "Max NPC Level\nDefault=" + maxNpcLevel + "\n" + "How high can NPCs level up?  Npcs gain more health, attack damage, and overall\n" + "improved stats with each level.  Levels can go very high, but higher values may\n" + "result in overpowered NPCs once leveled up.").getInt();
        npcXpFromAttack = this.config.get("02_server_settings", "npc_xp_per_attack", npcXpFromAttack, "XP Per Attack\nDefault=" + npcXpFromAttack + "\n" + "How much xp should an NPC gain each time they damage but do not kill an enemy?\n" + "Higher values will result in faster npc leveling.\n" + "Applies to both player-owned and faction-based NPCs.").getInt();
        npcXpFromKill = this.config.get("02_server_settings", "npc_xp_per_kill", npcXpFromKill, "XP Per Killnefault=" + npcXpFromKill + "\n" + "How much xp should an NPC gain each time they kill an enemy?\n" + "Higher values will result in faster npc leveling.\n" + "Applies to both player-owned and faction-based NPCs.").getInt();
        npcXpFromTrade = this.config.get("02_server_settings", "npc_xp_per_trade", npcXpFromTrade, "XP Per Trade\nDefault=" + npcXpFromTrade + "\n" + "How much xp should an NPC gain each time successfully traded with?\n" + "Higher values will result in faster npc leveling and unlock more trade recipes.\n" + "Applies to both player-owned and faction-based NPCs.").getInt();
        npcXpFromWork = this.config.get("02_server_settings", "npc_xp_per_work", npcXpFromWork, "XP Per Work\nDefault=" + npcXpFromWork + "\n" + "How much xp should an NPC gain each time it works at a worksite?\n" + "Higher values will result in faster npc leveling.\n" + "Applies to player-owned NPCs only.").getInt();
        npcXpFromMoveItem = this.config.get("02_server_settings", "npc_xp_per_item_moved", npcXpFromMoveItem, "XP Per Courier\nDefault=" + npcXpFromMoveItem + "\n" + "How much xp should an NPC gain each time it moves an item?\n" + "Higher values will result in faster npc leveling.\n" + "Applies to player-owned NPCs only.").getInt();
        npcWorkTicks = this.config.get("02_server_settings", "npc_work_ticks", npcWorkTicks, "Time Between Work Ticks\nDefault=" + npcWorkTicks + "\n" + "How many game ticks should pass between workers' processing work at a work-site.\n" + "Lower values result in more work output, higher values result in less work output.").getInt();
        npcAllowUpkeepAnyInventory = this.config.get("02_server_settings", "allow_upkeep_any_inventory", npcAllowUpkeepAnyInventory, "Allow NPC upkeep location at any inventory\nDefault=" + npcAllowUpkeepAnyInventory + "\n" + "By default, the Upkeep Order slip can be used to assign upkeep locations to any valid inventory block.\n" + "If set to false, only Town Hall blocks will be allowed as valid upkeep locations.").getBoolean();
        townMaxRange = this.config.get("02_server_settings", "town_hall_max_range", townMaxRange, "Town Hall Max Activation Range\nDefault=" + townMaxRange + "\n" + "How many blocks can a Town Hall be away from an NPC, while still detecting their death for possible resurrection.\n" + "This is a maximum, for server efficiency sake. Lower individual values can be setup from each block interaction GUI.").getInt();
        townUpdateFreq = this.config.get("02_server_settings", "town_hall_ticks", townUpdateFreq, "Default=" + townUpdateFreq + "\n" + "How many game ticks should pass between Town Hall updates." + "This affect how an NPC can change its selected Town Hall by moving to different places.\n" + "Lower values will make an NPC change its Town Hall faster, but is more costly for a server.").getInt();
        factionLossOnDeath = this.factionConfig.get(factionSettings, "faction_loss_on_kill", factionLossOnDeath, "Faction Loss On Kill\nDefault=10\nHow much faction standing should be lost if you or one of your minions kills a faction based NPC.").getInt();
        factionGainOnTrade = this.factionConfig.get(factionSettings, "faction_gain_on_trade", factionGainOnTrade, "Faction Gain On Trade\nDefault=2\nHow much faction standing should be gained when you trade with a faction based trader.").getInt();
        loadDefaultSkinPack = this.config.get("03_client_settings", "load_default_skin_pack", loadDefaultSkinPack, "Load Default Skin Pack\nDefault=true\nIf true, default skin pack will be loaded.\nIf false, default skin pack will NOT be loaded -- you will need to supply your own\nskin packs or all npcs will use the default skin.").getBoolean();
        exportEntityNames = this.config.get("02_server_settings", "export_entity_names", exportEntityNames, "Export entity name list\nDefault=" + exportEntityNames + "\n" + "If true, a text file will be created in the main ancientwarfare config directory containing a list of all registered in-game entity names.\n" + "These names may be used to populate the NPC target lists.").getBoolean();
        renderAI = this.config.get("03_client_settings", "render_npc_ai", true);
        renderWorkPoints = this.config.get("03_client_settings", "render_work_points", true);
        renderFriendlyNames = this.config.get("03_client_settings", "render_friendly_nameplates", true);
        renderHostileNames = this.config.get("03_client_settings", "render_hostile_nameplates", true);
        renderFriendlyHealth = this.config.get("03_client_settings", "render_friendly_health", true);
        renderHostileHealth = this.config.get("03_client_settings", "render_hostile_health", true);
        renderTeamColors = this.config.get("03_client_settings", "render_team_colors", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInitCallback() {
        if (exportEntityNames) {
            File file = new File("config/ancientwarfare");
            file.mkdirs();
            file = new File(file, "entity_names.txt");
            FileWriter wr = null;
            try {
                wr = new FileWriter(file);
                for (Object obj : EntityList.field_75625_b.keySet()) {
                    wr.write(String.valueOf(obj) + "\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (wr != null) {
                    try {
                        wr.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void loadTargetValues() {
        this.entityTargetSettings = new HashMap();
        String[] defaultTargets = new String[]{"Zombie", "Skeleton", "Slime"};
        String[] targets = this.targetConfig.get(targetSettings, "combat.targets", defaultTargets, "Default targets for: unassigned combat npc").getStringList();
        this.addTargetMapping("combat", "", targets);
        targets = this.targetConfig.get(targetSettings, "combat.archer.targets", defaultTargets, "Default targets for: player-owned archer").getStringList();
        this.addTargetMapping("combat", "archer", targets);
        targets = this.targetConfig.get(targetSettings, "combat.soldier.targets", defaultTargets, "Default targets for: player-owned soldier").getStringList();
        this.addTargetMapping("combat", "soldier", targets);
        targets = this.targetConfig.get(targetSettings, "combat.leader.targets", defaultTargets, "Default targets for: player-owned leader npc").getStringList();
        this.addTargetMapping("combat", "leader", targets);
        targets = this.targetConfig.get(targetSettings, "combat.medic.targets", defaultTargets, "Default targets for: player-owned medic npc").getStringList();
        this.addTargetMapping("combat", "medic", targets);
        targets = this.targetConfig.get(targetSettings, "combat.engineer.targets", defaultTargets, "Default targets for: player-owned engineer npc").getStringList();
        this.addTargetMapping("combat", "engineer", targets);
        for (String name : factionNames) {
            for (String sub : factionNpcSubtypes) {
                targets = this.targetConfig.get(targetSettings, name + "." + sub + ".targets", defaultTargets, "Default targets for: " + name + " " + this.asName(sub)).getStringList();
                this.addTargetMapping(name, sub, targets);
            }
        }
        targets = this.targetConfig.get(targetSettings, "enemies_to_target_npcs", defaultTargets, "What mob types should have AI inserted to enable them to target NPCs?\nShould work with any new-ai enabled mob type; vanilla or mod-added (but might not work with mod-added entities with custom AI).").getStringList();
        this.entitiesToTargetNpcs = new ArrayList<String>();
        Collections.addAll(this.entitiesToTargetNpcs, targets);
    }

    private String asName(String npcSubtype) {
        String[] txt = npcSubtype.split("\\.");
        StringBuilder build = new StringBuilder();
        for (int i = txt.length - 1; i >= 0; --i) {
            build.append(txt[i]).append(" ");
        }
        return build.replace(build.length() - 1, build.length(), "s").toString().replace("_", " ");
    }

    private void addTargetMapping(String npcType, String npcSubtype, String[] targets) {
        String type = npcType + (npcSubtype.isEmpty() ? "" : "." + npcSubtype);
        List<Object> collection = !this.entityTargetSettings.containsKey(type) ? new ArrayList() : this.entityTargetSettings.get(type);
        Collections.addAll(collection, targets);
        this.entityTargetSettings.put(type, collection);
    }

    public boolean shouldEntityTargetNpcs(String entityName) {
        return this.entitiesToTargetNpcs.contains(entityName);
    }

    public List<String> getValidTargetsFor(String npcType, String npcSubtype) {
        String type = npcType + (npcSubtype.isEmpty() ? "" : "." + npcSubtype);
        if (this.entityTargetSettings.containsKey(type)) {
            return this.entityTargetSettings.get(type);
        }
        return Collections.emptyList();
    }

    private void loadFoodValues() {
        this.foodMultiplier = this.foodConfig.getInt("Food Multiplier", "Default", this.foodMultiplier, 0, 0xCCCCCCC, "Food items which don't have a custom duration time set will have their nourishing amount multiplied by this number, to get the number of ticks feeding the npc.");
        this.foodConfig.get(foodSettings, "minecraft:apple", 3000, "Example of a food usual tick duration. Default food multiplier included.");
        this.foodConfig.get(foodSettings, "minecraft:mushroom_stew", 4500, "Example of a food usual tick duration. Default food multiplier included.");
        this.foodConfig.get(foodSettings, "minecraft:rotten_flesh", 0, "Rotten flesh is a rejected food by default.");
        this.foodConfig.get(foodSettings, "minecraft:poisonous_potato", 0, "Poisonous potato is a rejected food by default.");
        this.foodConfig.get(foodSettings, "minecraft:spider_eye", 0, "Spider eye is a rejected food by default.");
        ConfigCategory category = this.foodConfig.getCategory(foodSettings);
        this.foodValues = new HashMap();
        for (Map.Entry entry : category.entrySet()) {
            String name = (String)entry.getKey();
            int value = ((Property)entry.getValue()).getInt(0);
            this.foodValues.put(name, value);
        }
    }

    private void loadDefaultFactionStandings() {
        this.defaultFactionStandings = new HashMap();
        this.factionVsFactionStandings = new HashMap();
        for (String name : factionNames) {
            if (!this.factionVsFactionStandings.containsKey(name)) {
                this.factionVsFactionStandings.put(name, new HashMap());
            }
            this.defaultFactionStandings.put(name, this.factionConfig.get(factionSettings, name + ".starting_faction_standing", -50, "Default faction standing for: [" + name + "] for new players joining a game." + " Less than 0 will be hostile, greater than or equal to zero will be neutral/friendly." + " Default value is -50 for all factions, starting all players with a minor hostile standing." + " Players will need to trade with faction-owned traders to improve their standing to become friendly.").getInt());
            for (String name2 : factionNames) {
                if (name.equals(name2)) continue;
                String key = name + ":" + name2;
                boolean val = this.factionConfig.get(factionSettings, key, false, "How does: " + name + " faction view: " + name2 + " faction?\n" + "If true, " + name + "s will be hostile towards " + name2 + "s").getBoolean();
                this.factionVsFactionStandings.get(name).put(name2, val);
            }
        }
    }

    public int getFoodValue(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return 0;
        }
        String name = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
        if (this.foodValues.containsKey(name)) {
            return this.foodValues.get(name);
        }
        if (stack.func_77973_b() instanceof ItemFood) {
            return ((ItemFood)stack.func_77973_b()).func_150905_g(stack) * this.foodMultiplier;
        }
        return 0;
    }

    public int getDefaultFaction(String factionName) {
        if (this.defaultFactionStandings.containsKey(factionName)) {
            return this.defaultFactionStandings.get(factionName);
        }
        return 0;
    }

    private void initializeCustomValues() {
        this.valuesConfig = AWNPCStatics.getConfigFor("AncientWarfareNpcValues");
        this.pathConfig = AWNPCStatics.getConfigFor("AncientWarfareNpcPath");
        this.attributes = new HashMap();
        this.pathValues = new HashMap();
        for (String name : factionNames) {
            for (String type : factionNpcSubtypes) {
                String key = name + "." + type;
                this.attributes.put(key, this.getDefault(key));
                this.pathValues.put(key, this.getDefaultPath(key));
            }
        }
        this.attributes.put("combat", this.getDefault("combat"));
        this.attributes.put("worker", this.getDefault("worker"));
        this.attributes.put("courier", this.getDefault("courier"));
        this.attributes.put("trader", this.getDefault("trader"));
        this.attributes.put("priest", this.getDefault("priest"));
        this.attributes.put("bard", this.getDefault("bard"));
        this.pathValues.put("combat", this.getDefaultPath("combat"));
        this.pathValues.put("worker", this.getDefaultPath("worker"));
        this.pathValues.put("courier", this.getDefaultPath("courier"));
        this.pathValues.put("trader", this.getDefaultPath("trader"));
        this.pathValues.put("priest", this.getDefaultPath("priest"));
        this.pathValues.put("bard", this.getDefaultPath("bard"));
    }

    private Attribute getDefault(String type) {
        return new Attribute(this.valuesConfig.get("01_npc_base_health", type, 20).getDouble(), this.valuesConfig.get("02_npc_base_attack", type, 1).getDouble(), this.valuesConfig.get("03_npc_base_speed", type, 0.325).getDouble(), this.valuesConfig.get("05_npc_base_range", type, 60).getDouble(), this.valuesConfig.get("04_npc_exp_drop", type, 0).getInt());
    }

    public double getMaxHealthFor(String type) {
        return this.attributes.get(type).baseHealth();
    }

    public double getAttack(NpcBase npcBase) {
        String type = npcBase.getNpcType();
        Attribute attribute = this.attributes.get(type);
        if (attribute != null) {
            double dmg = attribute.baseAttack();
            int level = npcBase.getLevelingStats().getLevel();
            return dmg * (1.0 + (double)level * npcLevelDamageMultiplier);
        }
        return 0.0;
    }

    private Path getDefaultPath(String key) {
        return new Path(this.pathConfig.get("01_npc_path_avoidWater", key, false).getBoolean(), this.pathConfig.get("02_npc_path_breakDoors", key, true).getBoolean());
    }

    public void applyAttributes(NpcBase npc) {
        Attribute type = this.attributes.get(npc.getNpcType());
        if (type != null) {
            npc.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(type.baseHealth());
            npc.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(type.baseSpeed());
            npc.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(type.baseAttack());
            npc.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(type.baseRange());
            npc.setExperienceDrop(type.expDrop());
        }
    }

    public void applyPathConfig(NpcBase npc) {
        Path path = this.pathValues.get(npc.getNpcType());
        if (path != null) {
            path.applyTo(npc.func_70661_as());
        }
    }

    public boolean shouldFactionBeHostileTowards(String faction1, String faction2) {
        if (this.factionVsFactionStandings.containsKey(faction1) && this.factionVsFactionStandings.get(faction1).containsKey(faction2)) {
            return this.factionVsFactionStandings.get(faction1).get(faction2);
        }
        return false;
    }

    public void initializeNpcEquipmentConfigs() {
        this.eqmp = new HashMap();
        for (String faction : factionNames) {
            for (String type : factionNpcSubtypes) {
                String fullType = faction + "." + type;
                this.eqmp.put(fullType, new String[8]);
            }
            this.eqmp.get((Object)new StringBuilder().append((String)faction).append((String)".soldier").toString())[0] = "minecraft:iron_sword";
            this.eqmp.get((Object)new StringBuilder().append((String)faction).append((String)".soldier.elite").toString())[0] = "minecraft:iron_sword";
            this.eqmp.get((Object)new StringBuilder().append((String)faction).append((String)".cavalry").toString())[0] = "minecraft:iron_sword";
            this.eqmp.get((Object)new StringBuilder().append((String)faction).append((String)".archer").toString())[0] = "minecraft:bow";
            this.eqmp.get((Object)new StringBuilder().append((String)faction).append((String)".archer.elite").toString())[0] = "minecraft:bow";
            this.eqmp.get((Object)new StringBuilder().append((String)faction).append((String)".mounted_archer").toString())[0] = "minecraft:bow";
            this.eqmp.get((Object)new StringBuilder().append((String)faction).append((String)".leader").toString())[0] = "minecraft:diamond_sword";
            this.eqmp.get((Object)new StringBuilder().append((String)faction).append((String)".leader.elite").toString())[0] = "minecraft:diamond_sword";
            this.eqmp.get((Object)new StringBuilder().append((String)faction).append((String)".trader").toString())[0] = "minecraft:book";
            this.eqmp.get((Object)new StringBuilder().append((String)faction).append((String)".priest").toString())[0] = "minecraft:book";
            this.eqmp.get((Object)new StringBuilder().append((String)faction).append((String)".bard").toString())[0] = "AncientWarfareNpc:bard_instrument";
        }
        for (String key : this.eqmp.keySet()) {
            String[] array = this.eqmp.get(key);
            String item = array[0];
            item = item == null ? "null" : item;
            array[0] = item = this.equipmentConfig.get(npcDefaultWeapons, key, item).getString();
            item = array[4];
            item = item == null ? "null" : item;
            array[4] = item = this.equipmentConfig.get(npcArmorHead, key, item).getString();
            item = array[3];
            item = item == null ? "null" : item;
            array[3] = item = this.equipmentConfig.get(npcArmorChest, key, item).getString();
            item = array[2];
            item = item == null ? "null" : item;
            array[2] = item = this.equipmentConfig.get(npcArmorLegs, key, item).getString();
            item = array[1];
            item = item == null ? "null" : item;
            array[1] = item = this.equipmentConfig.get(npcArmorBoots, key, item).getString();
            item = array[5];
            item = item == null ? "null" : item;
            array[5] = item = this.equipmentConfig.get(npcWorkItem, key, item).getString();
            item = array[6];
            item = item == null ? "null" : item;
            array[6] = item = this.equipmentConfig.get(npcUpkeepItem, key, item).getString();
            item = array[7];
            item = item == null ? "null" : item;
            array[7] = item = this.equipmentConfig.get(npcOffhandItems, key, item).getString();
        }
    }

    public ItemStack getStartingEquipmentForSlot(String type, int slot) {
        Item item;
        String itemName = null;
        if (this.eqmp.containsKey(type)) {
            itemName = this.eqmp.get(type)[slot];
        }
        if (itemName != null && !itemName.isEmpty() && !itemName.equals("null") && (item = (Item)Item.field_150901_e.func_82594_a(itemName)) != null) {
            return new ItemStack(item);
        }
        return null;
    }

    @Override
    public void save() {
        super.save();
        this.equipmentConfig.save();
        this.targetConfig.save();
        this.valuesConfig.save();
        this.pathConfig.save();
        this.foodConfig.save();
        this.factionConfig.save();
    }

    static {
        factionLossOnDeath = 10;
        factionGainOnTrade = 2;
        factionNames = new String[]{"bandit", "viking", "pirate", "desert", "native", "custom_1", "custom_2", "custom_3"};
        factionNpcSubtypes = new String[]{"soldier", "soldier.elite", "cavalry", "archer", "archer.elite", "mounted_archer", "leader", "leader.elite", "priest", "trader", "civilian.male", "civilian.female", "bard"};
    }

    private static class Attribute {
        private final double health;
        private final double attack;
        private final double speed;
        private final double range;
        private final int exp;

        private Attribute(double hp, double ap, double sp, double rg, int xp) {
            this.health = hp;
            this.attack = ap;
            this.speed = sp;
            this.range = rg;
            this.exp = xp;
        }

        public double baseHealth() {
            return this.health;
        }

        public double baseAttack() {
            return this.attack;
        }

        public double baseRange() {
            return this.range;
        }

        public double baseSpeed() {
            return this.speed;
        }

        public int expDrop() {
            return this.exp;
        }
    }

    private static class Path {
        private final boolean avoidWater;
        private final boolean breakDoor;

        private Path(boolean water, boolean door) {
            this.avoidWater = water;
            this.breakDoor = door;
        }

        public void applyTo(PathNavigate navigate) {
            navigate.func_75491_a(this.avoidWater);
            navigate.func_75498_b(this.breakDoor);
        }
    }
}

