/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.inventory.InventoryBackpack;
import net.shadowmage.ancientwarfare.core.item.ItemBackpack;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcTrader;
import net.shadowmage.ancientwarfare.npc.trade.TradeList;

public class ContainerNpcPlayerOwnedTrade
extends ContainerNpcBase<NpcTrader> {
    public TradeList tradeList;
    public final InventoryBackpack storage;

    public ContainerNpcPlayerOwnedTrade(EntityPlayer player, int x, int y, int z) {
        super(player, x);
        this.tradeList = ((NpcTrader)this.entity).getTradeList();
        ((NpcTrader)this.entity).startTrade(player);
        this.addPlayerSlots();
        this.storage = ItemBackpack.getInventoryFor(((NpcTrader)this.entity).func_70694_bm());
        if (this.storage != null) {
            for (int i = 0; i < this.storage.func_70302_i_(); ++i) {
                this.func_75146_a(new Slot((IInventory)this.storage, i, 100000, 100000));
            }
        }
    }

    @Override
    public void sendInitData() {
        if (this.tradeList != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.tradeList.writeToNBT(tag);
            NBTTagCompound packetTag = new NBTTagCompound();
            packetTag.func_74782_a("tradeData", (NBTBase)tag);
            this.sendDataToClient(packetTag);
        }
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("tradeData")) {
            this.tradeList = new TradeList();
            this.tradeList.readFromNBT(tag.func_74775_l("tradeData"));
        } else if (tag.func_74764_b("doTrade")) {
            this.tradeList.performTrade(this.player, (IInventory)this.storage, tag.func_74762_e("doTrade"));
        }
        this.refreshGui();
    }

    public void func_75134_a(EntityPlayer player) {
        ((NpcTrader)this.entity).closeTrade();
        if (this.storage != null) {
            ItemBackpack.writeBackpackToItem(this.storage, ((NpcTrader)this.entity).func_70694_bm());
        }
        super.func_75134_a(player);
    }

    public void doTrade(int tradeIndex) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("doTrade", tradeIndex);
        this.sendDataToServer(tag);
    }
}

