/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity;

import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.api.AWItems;
import net.shadowmage.ancientwarfare.core.entity.AWEntityRegistry;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.entity.NpcBard;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcCombat;
import net.shadowmage.ancientwarfare.npc.entity.NpcCourier;
import net.shadowmage.ancientwarfare.npc.entity.NpcPriest;
import net.shadowmage.ancientwarfare.npc.entity.NpcTrader;
import net.shadowmage.ancientwarfare.npc.entity.NpcWorker;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcBanditArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcBanditArcherElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcBanditBard;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcBanditCivilianFemale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcBanditCivilianMale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcBanditLeader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcBanditLeaderElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcBanditMountedArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcBanditMountedSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcBanditPriest;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcBanditSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcBanditSoldierElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcBanditTrader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_1Archer;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_1ArcherElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_1Bard;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_1CivilianFemale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_1CivilianMale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_1Leader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_1LeaderElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_1MountedArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_1MountedSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_1Priest;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_1Soldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_1SoldierElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_1Trader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_2Archer;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_2ArcherElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_2Bard;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_2CivilianFemale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_2CivilianMale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_2Leader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_2LeaderElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_2MountedArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_2MountedSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_2Priest;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_2Soldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_2SoldierElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_2Trader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_3Archer;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_3ArcherElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_3Bard;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_3CivilianFemale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_3CivilianMale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_3Leader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_3LeaderElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_3MountedArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_3MountedSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_3Priest;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_3Soldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_3SoldierElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcCustom_3Trader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcDesertArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcDesertArcherElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcDesertBard;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcDesertCivilianFemale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcDesertCivilianMale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcDesertLeader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcDesertLeaderElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcDesertMountedArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcDesertMountedSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcDesertPriest;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcDesertSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcDesertSoldierElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcDesertTrader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcNativeArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcNativeArcherElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcNativeBard;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcNativeCivilianFemale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcNativeCivilianMale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcNativeLeader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcNativeLeaderElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcNativeMountedArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcNativeMountedSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcNativePriest;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcNativeSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcNativeSoldierElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcNativeTrader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcPirateArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcPirateArcherElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcPirateBard;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcPirateCivilianFemale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcPirateCivilianMale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcPirateLeader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcPirateLeaderElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcPirateMountedArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcPirateMountedSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcPiratePriest;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcPirateSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcPirateSoldierElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcPirateTrader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcVikingArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcVikingArcherElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcVikingBard;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcVikingCivilianFemale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcVikingCivilianMale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcVikingLeader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcVikingLeaderElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcVikingMountedArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcVikingMountedSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcVikingPriest;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcVikingSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcVikingSoldierElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcVikingTrader;
import net.shadowmage.ancientwarfare.npc.item.AWNpcItemLoader;
import net.shadowmage.ancientwarfare.npc.item.ItemNpcSpawner;

public class AWNPCEntityLoader {
    private static int nextID = 0;
    private static HashMap<String, NpcDeclaration> npcMap = new HashMap();

    public static void load() {
        AWNPCEntityLoader.addPlayerOwnedNpcs();
        AWNPCEntityLoader.addBandits();
        AWNPCEntityLoader.addDesertNatives();
        AWNPCEntityLoader.addJungleNatives();
        AWNPCEntityLoader.addPirates();
        AWNPCEntityLoader.addVikings();
        AWNPCEntityLoader.addCustom1();
        AWNPCEntityLoader.addCustom2();
        AWNPCEntityLoader.addCustom3();
    }

    private static void addPlayerOwnedNpcs() {
        NpcDeclaration reg = new NpcDeclaration(NpcCombat.class, "aw_npc_combat", nextID++, AncientWarfareNPC.instance, 120, 3, true, "combat");
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_combat");
        AWNPCEntityLoader.addNpcSubtypeEntry("combat", "commander", "ancientwarfare:npc/spawner_commander");
        AWNPCEntityLoader.addNpcSubtypeEntry("combat", "soldier", "ancientwarfare:npc/spawner_combat");
        AWNPCEntityLoader.addNpcSubtypeEntry("combat", "archer", "ancientwarfare:npc/spawner_archer");
        AWNPCEntityLoader.addNpcSubtypeEntry("combat", "medic", "ancientwarfare:npc/spawner_medic");
        AWNPCEntityLoader.addNpcSubtypeEntry("combat", "engineer", "ancientwarfare:npc/spawner_engineer");
        reg = new NpcDeclaration(NpcWorker.class, "aw_npc_worker", nextID++, AncientWarfareNPC.instance, 120, 3, true, "worker");
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_miner");
        AWNPCEntityLoader.addNpcSubtypeEntry("worker", "miner", "ancientwarfare:npc/spawner_miner");
        AWNPCEntityLoader.addNpcSubtypeEntry("worker", "farmer", "ancientwarfare:npc/spawner_farmer");
        AWNPCEntityLoader.addNpcSubtypeEntry("worker", "lumberjack", "ancientwarfare:npc/spawner_lumberjack");
        AWNPCEntityLoader.addNpcSubtypeEntry("worker", "researcher", "ancientwarfare:npc/spawner_researcher");
        AWNPCEntityLoader.addNpcSubtypeEntry("worker", "craftsman", "ancientwarfare:npc/spawner_craftsman");
        reg = new NpcDeclaration(NpcCourier.class, "aw_npc_courier", nextID++, AncientWarfareNPC.instance, 120, 3, true, "courier");
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_courier");
        reg = new NpcDeclaration(NpcTrader.class, "aw_npc_trader", nextID++, AncientWarfareNPC.instance, 120, 3, true, "trader");
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_trader");
        reg = new NpcDeclaration(NpcPriest.class, "aw_npc_priest", nextID++, AncientWarfareNPC.instance, 120, 3, true, "priest");
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_priest");
        reg = new NpcDeclaration(NpcBard.class, "aw_npc_bard", nextID++, AncientWarfareNPC.instance, 120, 3, true, "bard");
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bard");
    }

    private static void addBandits() {
        NpcFactionDeclaration reg = new NpcFactionDeclaration(NpcBanditArcher.class, "bandit.archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bandit_archer");
        reg = new NpcFactionDeclaration(NpcBanditSoldier.class, "bandit.soldier", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bandit_soldier");
        reg = new NpcFactionDeclaration(NpcBanditLeader.class, "bandit.leader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bandit_leader");
        reg = new NpcFactionDeclaration(NpcBanditPriest.class, "bandit.priest", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bandit_priest");
        reg = new NpcFactionDeclaration(NpcBanditTrader.class, "bandit.trader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bandit_trader");
        reg = new NpcFactionDeclaration(NpcBanditMountedSoldier.class, "bandit.cavalry", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bandit_soldier");
        reg = new NpcFactionDeclaration(NpcBanditMountedArcher.class, "bandit.mounted_archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bandit_archer");
        reg = new NpcFactionDeclaration(NpcBanditCivilianMale.class, "bandit.civilian.male", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bandit_civilian_male");
        reg = new NpcFactionDeclaration(NpcBanditCivilianFemale.class, "bandit.civilian.female", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bandit_civilian_female");
        reg = new NpcFactionDeclaration(NpcBanditArcherElite.class, "bandit.archer.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bandit_archer");
        reg = new NpcFactionDeclaration(NpcBanditSoldierElite.class, "bandit.soldier.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bandit_soldier");
        reg = new NpcFactionDeclaration(NpcBanditLeaderElite.class, "bandit.leader.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bandit_leader");
        reg = new NpcFactionDeclaration(NpcBanditBard.class, "bandit.bard", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_bandit_bard");
    }

    private static void addDesertNatives() {
        NpcFactionDeclaration reg = new NpcFactionDeclaration(NpcDesertArcher.class, "desert.archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_desert_archer");
        reg = new NpcFactionDeclaration(NpcDesertSoldier.class, "desert.soldier", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_desert_soldier");
        reg = new NpcFactionDeclaration(NpcDesertLeader.class, "desert.leader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_desert_leader");
        reg = new NpcFactionDeclaration(NpcDesertPriest.class, "desert.priest", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_desert_priest");
        reg = new NpcFactionDeclaration(NpcDesertTrader.class, "desert.trader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_desert_trader");
        reg = new NpcFactionDeclaration(NpcDesertMountedSoldier.class, "desert.cavalry", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_desert_soldier");
        reg = new NpcFactionDeclaration(NpcDesertMountedArcher.class, "desert.mounted_archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_desert_archer");
        reg = new NpcFactionDeclaration(NpcDesertCivilianMale.class, "desert.civilian.male", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_desert_civilian_male");
        reg = new NpcFactionDeclaration(NpcDesertCivilianFemale.class, "desert.civilian.female", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_desert_civilian_female");
        reg = new NpcFactionDeclaration(NpcDesertArcherElite.class, "desert.archer.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_desert_archer");
        reg = new NpcFactionDeclaration(NpcDesertSoldierElite.class, "desert.soldier.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_desert_soldier");
        reg = new NpcFactionDeclaration(NpcDesertLeaderElite.class, "desert.leader.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_desert_leader");
        reg = new NpcFactionDeclaration(NpcDesertBard.class, "desert.bard", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_desert_bard");
    }

    private static void addJungleNatives() {
        NpcFactionDeclaration reg = new NpcFactionDeclaration(NpcNativeArcher.class, "native.archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_native_archer");
        reg = new NpcFactionDeclaration(NpcNativeSoldier.class, "native.soldier", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_native_soldier");
        reg = new NpcFactionDeclaration(NpcNativeLeader.class, "native.leader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_native_leader");
        reg = new NpcFactionDeclaration(NpcNativePriest.class, "native.priest", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_native_priest");
        reg = new NpcFactionDeclaration(NpcNativeTrader.class, "native.trader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_native_trader");
        reg = new NpcFactionDeclaration(NpcNativeMountedSoldier.class, "native.cavalry", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_native_soldier");
        reg = new NpcFactionDeclaration(NpcNativeMountedArcher.class, "native.mounted_archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_native_archer");
        reg = new NpcFactionDeclaration(NpcNativeCivilianMale.class, "native.civilian.male", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_native_civilian_male");
        reg = new NpcFactionDeclaration(NpcNativeCivilianFemale.class, "native.civilian.female", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_native_civilian_female");
        reg = new NpcFactionDeclaration(NpcNativeArcherElite.class, "native.archer.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_native_archer");
        reg = new NpcFactionDeclaration(NpcNativeSoldierElite.class, "native.soldier.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_native_soldier");
        reg = new NpcFactionDeclaration(NpcNativeLeaderElite.class, "native.leader.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_native_leader");
        reg = new NpcFactionDeclaration(NpcNativeBard.class, "native.bard", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_native_bard");
    }

    private static void addPirates() {
        NpcFactionDeclaration reg = new NpcFactionDeclaration(NpcPirateArcher.class, "pirate.archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_pirate_archer");
        reg = new NpcFactionDeclaration(NpcPirateSoldier.class, "pirate.soldier", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_pirate_soldier");
        reg = new NpcFactionDeclaration(NpcPirateLeader.class, "pirate.leader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_pirate_leader");
        reg = new NpcFactionDeclaration(NpcPiratePriest.class, "pirate.priest", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_pirate_priest");
        reg = new NpcFactionDeclaration(NpcPirateTrader.class, "pirate.trader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_pirate_trader");
        reg = new NpcFactionDeclaration(NpcPirateMountedSoldier.class, "pirate.cavalry", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_pirate_soldier");
        reg = new NpcFactionDeclaration(NpcPirateMountedArcher.class, "pirate.mounted_archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_pirate_archer");
        reg = new NpcFactionDeclaration(NpcPirateCivilianMale.class, "pirate.civilian.male", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_pirate_civilian_male");
        reg = new NpcFactionDeclaration(NpcPirateCivilianFemale.class, "pirate.civilian.female", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_pirate_civilian_female");
        reg = new NpcFactionDeclaration(NpcPirateArcherElite.class, "pirate.archer.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_pirate_archer");
        reg = new NpcFactionDeclaration(NpcPirateSoldierElite.class, "pirate.soldier.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_pirate_soldier");
        reg = new NpcFactionDeclaration(NpcPirateLeaderElite.class, "pirate.leader.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_pirate_leader");
        reg = new NpcFactionDeclaration(NpcPirateBard.class, "pirate.bard", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_pirate_bard");
    }

    private static void addVikings() {
        NpcFactionDeclaration reg = new NpcFactionDeclaration(NpcVikingArcher.class, "viking.archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_viking_archer");
        reg = new NpcFactionDeclaration(NpcVikingSoldier.class, "viking.soldier", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_viking_soldier");
        reg = new NpcFactionDeclaration(NpcVikingLeader.class, "viking.leader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_viking_leader");
        reg = new NpcFactionDeclaration(NpcVikingPriest.class, "viking.priest", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_viking_priest");
        reg = new NpcFactionDeclaration(NpcVikingTrader.class, "viking.trader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_viking_trader");
        reg = new NpcFactionDeclaration(NpcVikingMountedSoldier.class, "viking.cavalry", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_viking_soldier");
        reg = new NpcFactionDeclaration(NpcVikingMountedArcher.class, "viking.mounted_archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_viking_archer");
        reg = new NpcFactionDeclaration(NpcVikingCivilianMale.class, "viking.civilian.male", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_viking_civilian_male");
        reg = new NpcFactionDeclaration(NpcVikingCivilianFemale.class, "viking.civilian.female", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_viking_civilian_female");
        reg = new NpcFactionDeclaration(NpcVikingArcherElite.class, "viking.archer.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_viking_archer");
        reg = new NpcFactionDeclaration(NpcVikingSoldierElite.class, "viking.soldier.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_viking_soldier");
        reg = new NpcFactionDeclaration(NpcVikingLeaderElite.class, "viking.leader.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_viking_leader");
        reg = new NpcFactionDeclaration(NpcVikingBard.class, "viking.bard", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_viking_bard");
    }

    private static void addCustom1() {
        NpcFactionDeclaration reg = new NpcFactionDeclaration(NpcCustom_1Archer.class, "custom_1.archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_1_archer");
        reg = new NpcFactionDeclaration(NpcCustom_1Soldier.class, "custom_1.soldier", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_1_soldier");
        reg = new NpcFactionDeclaration(NpcCustom_1Leader.class, "custom_1.leader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_1_leader");
        reg = new NpcFactionDeclaration(NpcCustom_1Priest.class, "custom_1.priest", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_1_priest");
        reg = new NpcFactionDeclaration(NpcCustom_1Trader.class, "custom_1.trader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_1_trader");
        reg = new NpcFactionDeclaration(NpcCustom_1MountedSoldier.class, "custom_1.cavalry", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_1_soldier");
        reg = new NpcFactionDeclaration(NpcCustom_1MountedArcher.class, "custom_1.mounted_archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_1_archer");
        reg = new NpcFactionDeclaration(NpcCustom_1CivilianMale.class, "custom_1.civilian.male", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_1_civilian_male");
        reg = new NpcFactionDeclaration(NpcCustom_1CivilianFemale.class, "custom_1.civilian.female", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_1_civilian_female");
        reg = new NpcFactionDeclaration(NpcCustom_1ArcherElite.class, "custom_1.archer.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_1_archer");
        reg = new NpcFactionDeclaration(NpcCustom_1SoldierElite.class, "custom_1.soldier.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_1_soldier");
        reg = new NpcFactionDeclaration(NpcCustom_1LeaderElite.class, "custom_1.leader.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_1_leader");
        reg = new NpcFactionDeclaration(NpcCustom_1Bard.class, "custom_1.bard", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_1_bard");
    }

    private static void addCustom2() {
        NpcFactionDeclaration reg = new NpcFactionDeclaration(NpcCustom_2Archer.class, "custom_2.archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_2_archer");
        reg = new NpcFactionDeclaration(NpcCustom_2Soldier.class, "custom_2.soldier", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_2_soldier");
        reg = new NpcFactionDeclaration(NpcCustom_2Leader.class, "custom_2.leader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_2_leader");
        reg = new NpcFactionDeclaration(NpcCustom_2Priest.class, "custom_2.priest", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_2_priest");
        reg = new NpcFactionDeclaration(NpcCustom_2Trader.class, "custom_2.trader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_2_trader");
        reg = new NpcFactionDeclaration(NpcCustom_2MountedSoldier.class, "custom_2.cavalry", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_2_soldier");
        reg = new NpcFactionDeclaration(NpcCustom_2MountedArcher.class, "custom_2.mounted_archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_2_archer");
        reg = new NpcFactionDeclaration(NpcCustom_2CivilianMale.class, "custom_2.civilian.male", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_2_civilian_male");
        reg = new NpcFactionDeclaration(NpcCustom_2CivilianFemale.class, "custom_2.civilian.female", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_2_civilian_female");
        reg = new NpcFactionDeclaration(NpcCustom_2ArcherElite.class, "custom_2.archer.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_2_archer");
        reg = new NpcFactionDeclaration(NpcCustom_2SoldierElite.class, "custom_2.soldier.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_2_soldier");
        reg = new NpcFactionDeclaration(NpcCustom_2LeaderElite.class, "custom_2.leader.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_2_leader");
        reg = new NpcFactionDeclaration(NpcCustom_2Bard.class, "custom_2.bard", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_2_bard");
    }

    private static void addCustom3() {
        NpcFactionDeclaration reg = new NpcFactionDeclaration(NpcCustom_3Archer.class, "custom_3.archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_3_archer");
        reg = new NpcFactionDeclaration(NpcCustom_3Soldier.class, "custom_3.soldier", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_3_soldier");
        reg = new NpcFactionDeclaration(NpcCustom_3Leader.class, "custom_3.leader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_3_leader");
        reg = new NpcFactionDeclaration(NpcCustom_3Priest.class, "custom_3.priest", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_3_priest");
        reg = new NpcFactionDeclaration(NpcCustom_3Trader.class, "custom_3.trader", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_3_trader");
        reg = new NpcFactionDeclaration(NpcCustom_3MountedSoldier.class, "custom_3.cavalry", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_3_soldier");
        reg = new NpcFactionDeclaration(NpcCustom_3MountedArcher.class, "custom_3.mounted_archer", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_3_archer");
        reg = new NpcFactionDeclaration(NpcCustom_3CivilianMale.class, "custom_3.civilian.male", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_3_civilian_male");
        reg = new NpcFactionDeclaration(NpcCustom_3CivilianFemale.class, "custom_3.civilian.female", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_3_civilian_female");
        reg = new NpcFactionDeclaration(NpcCustom_3ArcherElite.class, "custom_3.archer.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_3_archer");
        reg = new NpcFactionDeclaration(NpcCustom_3SoldierElite.class, "custom_3.soldier.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_3_soldier");
        reg = new NpcFactionDeclaration(NpcCustom_3LeaderElite.class, "custom_3.leader.elite", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_3_leader");
        reg = new NpcFactionDeclaration(NpcCustom_3Bard.class, "custom_3.bard", nextID++);
        AWNPCEntityLoader.addNpcRegistration(reg, "ancientwarfare:npc/spawner_custom_3_bard");
    }

    public static void loadNpcSubtypeEquipment() {
        AWNPCEntityLoader.addNpcSubtypeEquipment("worker", "farmer", new ItemStack(Items.field_151019_K));
        AWNPCEntityLoader.addNpcSubtypeEquipment("worker", "miner", new ItemStack(Items.field_151035_b));
        AWNPCEntityLoader.addNpcSubtypeEquipment("worker", "lumberjack", new ItemStack(Items.field_151036_c));
        AWNPCEntityLoader.addNpcSubtypeEquipment("worker", "researcher", new ItemStack(AWItems.quillIron));
        AWNPCEntityLoader.addNpcSubtypeEquipment("worker", "craftsman", new ItemStack(AWItems.automationHammerIron));
        AWNPCEntityLoader.addNpcSubtypeEquipment("combat", "commander", new ItemStack((Item)AWNpcItemLoader.commandBatonIron));
        AWNPCEntityLoader.addNpcSubtypeEquipment("combat", "soldier", new ItemStack(Items.field_151040_l));
        AWNPCEntityLoader.addNpcSubtypeEquipment("combat", "archer", new ItemStack((Item)Items.field_151031_f));
        AWNPCEntityLoader.addNpcSubtypeEquipment("combat", "engineer", new ItemStack(AWItems.automationHammerIron));
        AWNPCEntityLoader.addNpcSubtypeEquipment("combat", "medic", new ItemStack(Items.field_151036_c));
    }

    private static void addNpcRegistration(NpcDeclaration reg, String icon) {
        AWEntityRegistry.registerEntity(reg);
        if (reg.canSpawnBaseEntity) {
            ((ItemNpcSpawner)AWItems.npcSpawner).addNpcType(reg.getType(), icon);
        }
        npcMap.put(reg.getType(), reg);
    }

    public static NpcBase createNpc(World world, String npcType, String npcSubtype) {
        if (!npcMap.containsKey(npcType)) {
            return null;
        }
        NpcDeclaration reg = npcMap.get(npcType);
        return reg.createEntity(world, npcSubtype);
    }

    private static void addNpcSubtypeEntry(String npcType, String npcSubtype, String icon) {
        if (!npcMap.containsKey(npcType)) {
            throw new IllegalArgumentException("npc type must first be mapped");
        }
        npcMap.get(npcType).addSubtype(npcSubtype, icon);
        ((ItemNpcSpawner)AWItems.npcSpawner).addNpcType(npcType + "." + npcSubtype, icon);
    }

    private static void addNpcSubtypeEquipment(String npcType, String npcSubtype, ItemStack equipment) {
        if (!npcMap.containsKey(npcType)) {
            throw new IllegalArgumentException("npc type must first be mapped");
        }
        NpcDeclaration reg = npcMap.get(npcType);
        if (!reg.subTypeIcons.containsKey(npcSubtype)) {
            throw new IllegalArgumentException("npc subtype must first be mapped");
        }
        reg.spawnEquipment.put(npcSubtype, equipment);
    }

    public static void getSpawnerSubItems(List list) {
        for (NpcDeclaration dec : npcMap.values()) {
            if (dec.canSpawnBaseEntity) {
                list.add(ItemNpcSpawner.getStackForNpcType(dec.npcType, ""));
            }
            for (String sub : dec.subTypeIcons.keySet()) {
                list.add(ItemNpcSpawner.getStackForNpcType(dec.npcType, sub));
            }
        }
    }

    public static class NpcFactionDeclaration
    extends NpcDeclaration {
        public NpcFactionDeclaration(Class<? extends NpcFaction> entityClass, String entityName, int id) {
            super(entityClass, entityName, id, AncientWarfareNPC.instance, 120, 3, true, entityName);
        }

        @Override
        public NpcFaction createEntity(World world, String subType) {
            return (NpcFaction)this.createEntity(world);
        }
    }

    public static class NpcDeclaration
    extends AWEntityRegistry.EntityDeclaration {
        private boolean canSpawnBaseEntity = true;
        private final String npcType;
        private HashMap<String, String> subTypeIcons = new HashMap();
        private HashMap<String, ItemStack> spawnEquipment = new HashMap();

        public NpcDeclaration(Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, String npcType) {
            super(entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
            this.npcType = npcType;
        }

        public String getType() {
            return this.npcType;
        }

        public NpcDeclaration setCanSpawnBaseType(boolean can) {
            this.canSpawnBaseEntity = can;
            return this;
        }

        public void addSubtype(String type, String icon) {
            this.subTypeIcons.put(type, icon);
        }

        public NpcBase createEntity(World world, String subType) {
            ItemStack stack;
            NpcBase npc = (NpcBase)this.createEntity(world);
            if (!subType.isEmpty() && (stack = this.spawnEquipment.get(subType)) != null) {
                npc.func_70062_b(0, stack.func_77946_l());
            }
            return npc;
        }
    }
}

