/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.interfaces.IEntityPacketHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IOwnable;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketEntity;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.ai.NpcNavigator;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.IKeepFood;
import net.shadowmage.ancientwarfare.npc.entity.NpcLevelingStats;
import net.shadowmage.ancientwarfare.npc.item.ItemCommandBaton;
import net.shadowmage.ancientwarfare.npc.item.ItemNpcSpawner;
import net.shadowmage.ancientwarfare.npc.item.ItemShield;
import net.shadowmage.ancientwarfare.npc.skin.NpcSkinManager;

public abstract class NpcBase
extends EntityCreature
implements IEntityAdditionalSpawnData,
IOwnable,
IEntityPacketHandler {
    private String ownerName = "";
    private UUID ownerId;
    protected String followingPlayerName;
    protected NpcLevelingStats levelingStats = new NpcLevelingStats(this);
    private static final ResourceLocation baseDefaultTexture = new ResourceLocation("ancientwarfare:textures/entity/npc/npc_default.png");
    private ResourceLocation currentTexture = null;
    public static final int ORDER_SLOT = 5;
    public static final int UPKEEP_SLOT = 6;
    public static final int SHIELD_SLOT = 7;
    public ItemStack ordersStack;
    public ItemStack upkeepStack;
    private boolean aiEnabled = true;
    private int attackDamage = -1;
    private int armorValue = -1;
    private int maxHealthOverride = -1;
    private String customTexRef = "";

    public NpcBase(World par1World) {
        super(par1World);
        this.field_82174_bp = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        this.func_110163_bv();
        this.field_70699_by = new NpcNavigator((EntityLiving)this);
        AncientWarfareNPC.statics.applyPathConfig(this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(20, (Object)0);
        this.func_70096_w().func_82709_a(21, 5);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        AncientWarfareNPC.statics.applyAttributes(this);
    }

    public ItemStack getShieldStack() {
        return this.func_70096_w().func_82710_f(21);
    }

    public void setShieldStack(ItemStack stack) {
        this.func_70096_w().func_75692_b(21, (Object)stack);
    }

    public int getMaxHealthOverride() {
        return this.maxHealthOverride;
    }

    public void setMaxHealthOverride(int maxHealthOverride) {
        this.maxHealthOverride = maxHealthOverride;
        if (maxHealthOverride > 0) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxHealthOverride);
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70606_j(this.func_110138_aP());
            }
        }
    }

    public void setCustomTexRef(String customTexRef) {
        if (customTexRef == null) {
            customTexRef = "";
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!customTexRef.equals(this.customTexRef)) {
                String name;
                NBTTagCompound tagCompound;
                PacketEntity pkt = new PacketEntity((Entity)this);
                if (customTexRef.startsWith("Player:") && (tagCompound = AncientWarfareNPC.proxy.cacheProfile(name = customTexRef.split(":", 2)[1])) != null) {
                    pkt.packetData.func_74782_a("profileTex", (NBTBase)tagCompound);
                }
                pkt.packetData.func_74778_a("customTex", customTexRef);
                NetworkHandler.sendToAllTracking((Entity)this, pkt);
            }
            this.customTexRef = customTexRef;
        } else {
            this.customTexRef = customTexRef;
            this.updateTexture();
        }
    }

    public void setAttackDamageOverride(int attackDamage) {
        this.attackDamage = attackDamage;
    }

    public void setArmorValueOverride(int armorValue) {
        this.armorValue = armorValue;
    }

    public String getCustomTex() {
        return this.customTexRef;
    }

    public int getArmorValueOverride() {
        return this.armorValue;
    }

    public int getAttackDamageOverride() {
        return this.attackDamage;
    }

    public boolean func_70652_k(Entity target) {
        boolean targetHit;
        float damage = this.getAttackDamageOverride();
        ItemStack shield = null;
        if (damage < 0.0f) {
            if (this.getShieldStack() != null) {
                shield = this.getShieldStack().func_77946_l();
                this.func_110140_aT().func_111147_b(shield.func_111283_C());
            }
            damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        }
        int knockback = 0;
        if (target instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
            knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
        }
        if (targetHit = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage)) {
            int fireDamage;
            if (knockback > 0) {
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fireDamage = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                target.func_70015_d(fireDamage * 4);
            }
            if (target instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)target), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)target);
        }
        if (shield != null) {
            this.func_110140_aT().func_111148_a(shield.func_111283_C());
        }
        return targetHit;
    }

    protected float func_70655_b(DamageSource source, float amount) {
        if (!source.func_76363_c()) {
            if (this.getArmorValueOverride() >= 0) {
                return super.func_70655_b(source, amount);
            }
            float value = ISpecialArmor.ArmorProperties.ApplyArmor((EntityLivingBase)this, (ItemStack[])this.func_70035_c(), (DamageSource)source, (double)amount);
            if (value > 0.0f && this.getShieldStack() != null && this.getShieldStack().func_77973_b() instanceof ItemShield) {
                float absorb = value * (float)((ItemShield)this.getShieldStack().func_77973_b()).getArmorBonusValue() / 25.0f;
                int dmg = Math.max((int)absorb, 1);
                this.getShieldStack().func_77972_a(dmg, (EntityLivingBase)this);
                value -= absorb;
            }
            if (value < 0.0f) {
                return 0.0f;
            }
            return value;
        }
        return amount;
    }

    public int func_70658_aO() {
        if (this.getArmorValueOverride() >= 0) {
            return this.getArmorValueOverride();
        }
        int value = super.func_70658_aO();
        if (this.getShieldStack() != null && this.getShieldStack().func_77973_b() instanceof ItemShield) {
            ItemShield shield = (ItemShield)this.getShieldStack().func_77973_b();
            value += shield.getArmorBonusValue();
        }
        return value;
    }

    public final double func_70033_W() {
        return this.field_70129_M - 0.5f;
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 4 : 4 + (int)(this.func_110143_aJ() / 3.0f);
    }

    public float func_70783_a(int varX, int varY, int varZ) {
        Block below = this.field_70170_p.func_147439_a(varX, varY - 1, varZ);
        if (below.func_149688_o() == Material.field_151587_i || below.func_149688_o() == Material.field_151570_A) {
            return -10.0f;
        }
        if (below.func_149688_o().func_76224_d()) {
            return 0.0f;
        }
        float level = this.field_70170_p.func_72801_o(varX, varY, varZ);
        if (level < 0.0f) {
            return 0.0f;
        }
        return level + (float)(below.isSideSolid((IBlockAccess)this.field_70170_p, varX, varY - 1, varZ, ForgeDirection.UP) ? 1 : 0);
    }

    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_145771_j(this.field_70165_t, (this.field_70121_D.field_72338_b + this.field_70121_D.field_72337_e) / 2.0, this.field_70161_v);
        }
        super.func_70030_z();
    }

    public double getDistanceSqFromHome() {
        if (!this.func_110175_bO()) {
            return 0.0;
        }
        ChunkCoordinates home = this.func_110172_bL();
        return this.func_70092_e((double)home.field_71574_a + 0.5, home.field_71572_b, (double)home.field_71573_c + 0.5);
    }

    public BlockPosition getTownHallPosition() {
        return null;
    }

    public void setHomeAreaAtCurrentPosition() {
        this.func_110171_b(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), this.getHomeRange());
    }

    public int getHomeRange() {
        if (this.func_110175_bO()) {
            return MathHelper.func_76141_d((float)this.func_110174_bM());
        }
        return 5;
    }

    public boolean shouldBeAtHome() {
        if (this.func_70638_az() != null || !this.func_110175_bO() || this.field_70170_p.field_73011_w.field_76576_e) {
            return false;
        }
        return !this.field_70170_p.func_72935_r() || this.field_70170_p.func_72951_B(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
    }

    public void setIsAIEnabled(boolean val) {
        this.aiEnabled = val;
    }

    public boolean getIsAIEnabled() {
        return this.aiEnabled && !AWNPCStatics.npcAIDebugMode;
    }

    protected boolean func_70085_c(EntityPlayer player) {
        return this.tryCommand(player);
    }

    public void openGUI(EntityPlayer player) {
        NetworkHandler.INSTANCE.openGui(player, 4, this.func_145782_y(), 0, 0);
    }

    public void openAltGui(EntityPlayer player) {
    }

    public boolean hasAltGui() {
        return false;
    }

    public boolean canBeCommandedBy(String playerName) {
        if (this.ownerName.isEmpty()) {
            return false;
        }
        if (playerName == null) {
            return false;
        }
        Team team = this.func_96124_cp();
        if (team == null) {
            return playerName.equals(this.ownerName);
        }
        return team.func_142054_a((Team)this.field_70170_p.func_96441_U().func_96509_i(playerName));
    }

    protected boolean tryCommand(EntityPlayer player) {
        boolean baton;
        boolean bl = baton = player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemCommandBaton;
        if (!baton) {
            if (!this.field_70170_p.field_72995_K) {
                if (player.func_70093_af()) {
                    this.followingPlayerName = this.followingPlayerName != null && this.followingPlayerName.equals(player.func_70005_c_()) ? null : player.func_70005_c_();
                } else {
                    this.openGUI(player);
                }
            }
            return true;
        }
        return false;
    }

    public void func_70108_f(Entity entity) {
        if (!this.func_70090_H() && !this.isHostileTowards(entity)) {
            int d0 = (int)Math.signum(this.field_70165_t - entity.field_70165_t);
            int d1 = (int)Math.signum(this.field_70161_v - entity.field_70161_v);
            if (d0 != 0 || d1 != 0) {
                int z;
                int y;
                int x = MathHelper.func_76128_c((double)this.field_70165_t) + d0;
                Material material = this.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1, z = MathHelper.func_76128_c((double)this.field_70161_v) + d1).func_149688_o();
                if (material.func_76224_d() || material == Material.field_151570_A) {
                    return;
                }
                this.field_70144_Y = 0.9f;
            }
        }
        super.func_70108_f(entity);
        this.field_70144_Y = 0.0f;
    }

    public final boolean func_70097_a(DamageSource source, float par2) {
        if (source.func_76346_g() != null && !this.canBeAttackedBy(source.func_76346_g())) {
            return false;
        }
        if (source == DamageSource.field_76368_d && this.field_70154_o instanceof EntityLiving) {
            this.knockFromDamage(par2, this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e())), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o());
            return false;
        }
        if (source == DamageSource.field_76367_g) {
            this.knockFromDamage(par2, Material.field_151570_A);
        } else if (source == DamageSource.field_76371_c) {
            this.knockFromDamage(par2, Material.field_151587_i);
        } else if (source == DamageSource.field_76369_e) {
            this.func_70664_aZ();
        }
        return super.func_70097_a(source, par2);
    }

    private void knockFromDamage(float val, Material material) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_147439_a(x - 1, y = MathHelper.func_76128_c((double)(this.field_70121_D.field_72338_b + 0.5)), z = MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o() == material) {
            this.func_70653_a(null, val, (double)(x - 1) - this.field_70165_t, 0.0);
        } else if (this.field_70170_p.func_147439_a(x, y, z - 1).func_149688_o() == material) {
            this.func_70653_a(null, val, 0.0, (double)(z - 1) - this.field_70161_v);
        } else if (this.field_70170_p.func_147439_a(x + 1, y, z).func_149688_o() == material) {
            this.func_70653_a(null, val, (double)(x + 1) - this.field_70165_t, 0.0);
        } else if (this.field_70170_p.func_147439_a(x, y, z + 1).func_149688_o() == material) {
            this.func_70653_a(null, val, 0.0, (double)(z + 1) - this.field_70161_v);
        } else if (this.field_70170_p.func_147439_a(x - 1, y, z - 1).func_149688_o() == material) {
            this.func_70653_a(null, val, (double)(x - 1) - this.field_70165_t, (double)(z - 1) - this.field_70161_v);
        } else if (this.field_70170_p.func_147439_a(x + 1, y, z - 1).func_149688_o() == material) {
            this.func_70653_a(null, val, (double)(x + 1) - this.field_70165_t, (double)(z - 1) - this.field_70161_v);
        } else if (this.field_70170_p.func_147439_a(x - 1, y, z + 1).func_149688_o() == material) {
            this.func_70653_a(null, val, (double)(x - 1) - this.field_70165_t, (double)(z + 1) - this.field_70161_v);
        } else if (this.field_70170_p.func_147439_a(x + 1, y, z + 1).func_149688_o() == material) {
            this.func_70653_a(null, val, (double)(x + 1) - this.field_70165_t, (double)(z + 1) - this.field_70161_v);
        } else if (this.field_70170_p.func_147439_a(x, y - 1, z).func_149688_o() == material) {
            this.func_70653_a(null, val, 2.0f * this.func_70681_au().nextFloat() - 1.0f, 2.0f * this.func_70681_au().nextFloat() - 1.0f);
        }
        if (this.field_70170_p.field_72995_K || this.func_70661_as().func_75500_f()) {
            return;
        }
        PathPoint point = this.func_70661_as().func_75505_d().func_75877_a(this.func_70661_as().func_75505_d().func_75873_e());
        if (this.field_70170_p.func_147439_a(point.field_75839_a, point.field_75837_b, point.field_75838_c).func_149688_o() == material) {
            this.func_70661_as().func_75499_g();
        } else if (this.field_70170_p.func_147439_a(point.field_75839_a, point.field_75837_b - 1, point.field_75838_c).func_149688_o() == material) {
            this.func_70661_as().func_75499_g();
        }
    }

    public void func_70029_a(World world) {
        super.func_70029_a(world);
        ((NpcNavigator)this.field_70699_by).onWorldChange();
    }

    public void func_70624_b(EntityLivingBase entity) {
        if (entity != null && !this.canTarget((Entity)entity)) {
            return;
        }
        super.func_70624_b(entity);
    }

    public final void func_70604_c(EntityLivingBase entity) {
        if (entity != null && !this.canTarget((Entity)entity)) {
            return;
        }
        super.func_70604_c(entity);
    }

    protected final void func_82160_b(boolean par1, int par2) {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.field_82174_bp.length; ++i) {
                ItemStack stack = this.func_71124_b(i);
                if (stack != null) {
                    this.func_70099_a(stack, 0.0f);
                }
                this.func_70062_b(i, null);
            }
            if (this.ordersStack != null) {
                this.func_70099_a(this.ordersStack, 0.0f);
            }
            if (this.upkeepStack != null) {
                this.func_70099_a(this.upkeepStack, 0.0f);
            }
            if (this.getShieldStack() != null) {
                this.func_70099_a(this.getShieldStack(), 0.0f);
            }
            this.ordersStack = null;
            this.upkeepStack = null;
            this.setShieldStack(null);
        }
    }

    public final ItemStack func_71124_b(int slot) {
        if (slot == 5) {
            return this.ordersStack;
        }
        if (slot == 6) {
            return this.upkeepStack;
        }
        if (slot == 7) {
            return this.getShieldStack();
        }
        return super.func_71124_b(slot);
    }

    public final void func_70062_b(int slot, ItemStack stack) {
        if (slot == 7) {
            this.setShieldStack(stack);
        } else if (slot == 6) {
            this.upkeepStack = stack;
        } else if (slot == 5) {
            this.ordersStack = stack;
            this.onOrdersInventoryChanged();
        } else {
            super.func_70062_b(slot, stack);
            if (slot == 0) {
                this.onWeaponInventoryChanged();
            }
        }
    }

    public final void func_70074_a(EntityLivingBase par1EntityLivingBase) {
        super.func_70074_a(par1EntityLivingBase);
        if (!this.field_70170_p.field_72995_K) {
            this.addExperience(AWNPCStatics.npcXpFromKill);
            if (par1EntityLivingBase == this.func_70638_az()) {
                this.func_70624_b(null);
            }
        }
    }

    public final int getAITasks() {
        return this.func_70096_w().func_75679_c(20);
    }

    public final void addAITask(int task) {
        int tasks = this.getAITasks();
        int tc = tasks;
        if (tc != (tasks |= task)) {
            this.setAITasks(tasks);
        }
    }

    public final void removeAITask(int task) {
        int tasks = this.getAITasks();
        int tc = tasks;
        if (tc != (tasks &= ~task)) {
            this.setAITasks(tasks);
        }
    }

    private final void setAITasks(int tasks) {
        this.func_70096_w().func_75692_b(20, (Object)tasks);
    }

    public final void addExperience(int amount) {
        this.getLevelingStats().addExperience(amount);
    }

    public final void readAdditionalItemData(NBTTagCompound tag) {
        NBTTagList equipmentList = tag.func_150295_c("equipment", 10);
        for (int i = 0; i < equipmentList.func_74745_c(); ++i) {
            NBTTagCompound equipmentTag = equipmentList.func_150305_b(i);
            ItemStack stack = InventoryTools.readItemStack(equipmentTag);
            if (!equipmentTag.func_74764_b("slotNum")) continue;
            this.func_70062_b(equipmentTag.func_74762_e("slotNum"), stack);
        }
        this.readBaseTags(tag);
    }

    public final NBTTagCompound writeAdditionalItemData(NBTTagCompound tag) {
        NBTTagList equipmentList = new NBTTagList();
        for (int i = 0; i < this.field_82174_bp.length; ++i) {
            ItemStack stack = this.func_71124_b(i);
            if (stack == null) continue;
            NBTTagCompound equipmentTag = InventoryTools.writeItemStack(stack);
            equipmentTag.func_74768_a("slotNum", i);
            equipmentList.func_74742_a((NBTBase)equipmentTag);
        }
        tag.func_74782_a("equipment", (NBTBase)equipmentList);
        this.writeBaseTags(tag);
        return tag;
    }

    public boolean isValidOrdersStack(ItemStack stack) {
        return false;
    }

    public void onOrdersInventoryChanged() {
    }

    public void onWeaponInventoryChanged() {
    }

    public abstract String getNpcSubType();

    public abstract String getNpcType();

    public final String getNpcFullType() {
        String type = this.getNpcType();
        if (type == null || type.isEmpty()) {
            throw new RuntimeException("Type must not be null or empty:");
        }
        String sub = this.getNpcSubType();
        if (sub == null) {
            throw new RuntimeException("Subtype must not be null...type: " + type);
        }
        if (!sub.isEmpty()) {
            type = type + "." + sub;
        }
        return type;
    }

    public String func_70005_c_() {
        String name = StatCollector.func_74838_a((String)("entity.AncientWarfareNpc." + this.getNpcFullType() + ".name"));
        if (this.func_94056_bM()) {
            name = name + " : " + this.func_94057_bL();
        }
        return name;
    }

    public final NpcLevelingStats getLevelingStats() {
        return this.levelingStats;
    }

    public final ResourceLocation getDefaultTexture() {
        return baseDefaultTexture;
    }

    public final ItemStack getItemToSpawn() {
        return ItemNpcSpawner.getSpawnerItemForNpc(this);
    }

    public final long getIDForSkin() {
        return this.field_96093_i.getLeastSignificantBits();
    }

    public final ItemStack getPickedResult(MovingObjectPosition target) {
        EntityPlayer player = AncientWarfareCore.proxy.getClientPlayer();
        if (player != null) {
            PacketEntity pkt = new PacketEntity((Entity)this);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("playerID", player.func_145782_y());
            pkt.packetData.func_74782_a("pickEntity", (NBTBase)tag);
            NetworkHandler.sendToServer(pkt);
        }
        return null;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeLong(this.func_110124_au().getMostSignificantBits());
        buffer.writeLong(this.func_110124_au().getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ownerName);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.customTexRef);
    }

    public void readSpawnData(ByteBuf buffer) {
        long l1 = buffer.readLong();
        long l2 = buffer.readLong();
        this.field_96093_i = new UUID(l1, l2);
        this.ownerName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.customTexRef = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.updateTexture();
    }

    public void func_70071_h_() {
        this.field_70170_p.field_72984_F.func_76320_a("AWNpcTick");
        this.func_82168_bl();
        if (this.field_70173_aa % 200 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_70089_S() && (!this.requiresUpkeep() || this.getFoodRemaining() > 0)) {
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        }
        super.func_70071_h_();
        if (this.func_70694_bm() != null) {
            try {
                this.func_70694_bm().func_77945_a(this.field_70170_p, (Entity)this, 0, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    public boolean func_70686_a(Class claz) {
        return !EntityFlying.class.isAssignableFrom(claz);
    }

    protected final boolean func_70692_ba() {
        return false;
    }

    protected final boolean func_70650_aV() {
        return true;
    }

    public final void updateDamageFromLevel() {
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(AncientWarfareNPC.statics.getAttack(this));
    }

    public int getFoodRemaining() {
        return 0;
    }

    public void setFoodRemaining(int food) {
    }

    public boolean requiresUpkeep() {
        return this instanceof IKeepFood;
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.ownerId = player.func_110124_au();
        this.setOwnerName(player.func_70005_c_());
    }

    public void setOwnerName(String name) {
        if (name == null) {
            name = "";
        }
        if (!this.field_70170_p.field_72995_K && !name.equals(this.ownerName)) {
            PacketEntity pkt = new PacketEntity((Entity)this);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("ownerName", name);
            EntityPlayer player = this.field_70170_p.func_72924_a(name);
            if (player != null) {
                this.ownerId = player.func_110124_au();
            }
            if (this.ownerId != null) {
                tag.func_74778_a("ownerId", this.ownerId.toString());
            }
            pkt.packetData = tag;
            NetworkHandler.sendToAllTracking((Entity)this, pkt);
        }
        this.ownerName = name;
    }

    private void checkOwnerName() {
        EntityPlayer player;
        if (this.ownerId != null && (player = this.field_70170_p.func_152378_a(this.ownerId)) != null && !player.func_70005_c_().equals(this.ownerName)) {
            this.setOwnerName(player.func_70005_c_());
        }
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        if (player == null || player.func_146103_bH() == null) {
            return false;
        }
        if (this.ownerId != null) {
            return player.func_110124_au().equals(this.ownerId);
        }
        return player.func_70005_c_().equals(this.ownerName);
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    public Team func_96124_cp() {
        return this.field_70170_p.func_96441_U().func_96509_i(this.ownerName);
    }

    protected int func_70693_a(EntityPlayer attacker) {
        if (attacker != null && this.isHostileTowards((Entity)attacker) && this.canBeAttackedBy((Entity)attacker)) {
            return super.func_70693_a(attacker);
        }
        return 0;
    }

    public void setExperienceDrop(int exp) {
        this.field_70728_aV = exp;
    }

    public abstract boolean isHostileTowards(Entity var1);

    public abstract boolean canTarget(Entity var1);

    public abstract boolean canBeAttackedBy(Entity var1);

    public final EntityLivingBase getFollowingEntity() {
        if (this.followingPlayerName == null) {
            return null;
        }
        return this.field_70170_p.func_72924_a(this.followingPlayerName);
    }

    public final void setFollowingEntity(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && this.canBeCommandedBy(entity.func_70005_c_())) {
            this.followingPlayerName = entity.func_70005_c_();
        }
    }

    public boolean func_110164_bC() {
        return false;
    }

    public final void repackEntity(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.onRepack();
            ItemStack item = InventoryTools.mergeItemStack((IInventory)player.field_71071_by, this.getItemToSpawn(), -1);
            if (item != null) {
                InventoryTools.dropItemInWorld(player.field_70170_p, item, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
        }
        this.func_70106_y();
    }

    protected void onRepack() {
    }

    public void func_70037_a(NBTTagCompound tag) {
        for (int i = 0; i < this.field_82174_bp.length; ++i) {
            this.func_70062_b(i, null);
        }
        super.func_70037_a(tag);
        if (tag.func_74764_b("home")) {
            int[] ccia = tag.func_74759_k("home");
            this.func_110171_b(ccia[0], ccia[1], ccia[2], ccia[3]);
        }
        this.readBaseTags(tag);
        this.onWeaponInventoryChanged();
    }

    private void readBaseTags(NBTTagCompound tag) {
        if (tag.func_74764_b("ordersStack")) {
            this.func_70062_b(5, InventoryTools.readItemStack(tag.func_74775_l("ordersStack")));
        }
        if (tag.func_74764_b("upkeepStack")) {
            this.func_70062_b(6, InventoryTools.readItemStack(tag.func_74775_l("upkeepStack")));
        }
        if (tag.func_74764_b("shieldStack")) {
            this.setShieldStack(InventoryTools.readItemStack(tag.func_74775_l("shieldStack")));
        }
        if (tag.func_74764_b("levelingStats")) {
            this.getLevelingStats().readFromNBT(tag.func_74775_l("levelingStats"));
        }
        if (tag.func_74764_b("maxHealth")) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)tag.func_74760_g("maxHealth"));
        }
        if (tag.func_74764_b("health")) {
            this.func_70606_j(tag.func_74760_g("health"));
        }
        if (tag.func_74764_b("name")) {
            this.func_94058_c(tag.func_74779_i("name"));
        }
        if (tag.func_74764_b("food")) {
            this.setFoodRemaining(tag.func_74762_e("food"));
        }
        if (tag.func_74764_b("attackDamageOverride")) {
            this.setAttackDamageOverride(tag.func_74762_e("attackDamageOverride"));
        }
        if (tag.func_74764_b("armorValueOverride")) {
            this.setArmorValueOverride(tag.func_74762_e("armorValueOverride"));
        }
        if (tag.func_74764_b("customTex")) {
            this.setCustomTexRef(tag.func_74779_i("customTex"));
        }
        if (tag.func_74764_b("aiEnabled")) {
            this.setIsAIEnabled(tag.func_74767_n("aiEnabled"));
        }
        this.setOwnerName(tag.func_74779_i("owner"));
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (!this.func_110175_bO()) {
            BlockPosition position = this.getTownHallPosition();
            if (position != null) {
                this.func_110171_b(position.x, position.y, position.z, this.getHomeRange());
            } else {
                this.setHomeAreaAtCurrentPosition();
            }
        }
        ChunkCoordinates cc = this.func_110172_bL();
        int[] ccia = new int[]{cc.field_71574_a, cc.field_71572_b, cc.field_71573_c, this.getHomeRange()};
        tag.func_74783_a("home", ccia);
        this.writeBaseTags(tag);
    }

    private void writeBaseTags(NBTTagCompound tag) {
        if (this.ordersStack != null) {
            tag.func_74782_a("ordersStack", (NBTBase)InventoryTools.writeItemStack(this.ordersStack));
        }
        if (this.upkeepStack != null) {
            tag.func_74782_a("upkeepStack", (NBTBase)InventoryTools.writeItemStack(this.upkeepStack));
        }
        if (this.getShieldStack() != null) {
            tag.func_74782_a("shieldStack", (NBTBase)InventoryTools.writeItemStack(this.getShieldStack()));
        }
        tag.func_74782_a("levelingStats", (NBTBase)this.getLevelingStats().writeToNBT(new NBTTagCompound()));
        tag.func_74776_a("maxHealth", this.func_110138_aP());
        tag.func_74776_a("health", this.func_110143_aJ());
        tag.func_74768_a("food", this.getFoodRemaining());
        if (this.func_94056_bM()) {
            tag.func_74778_a("name", this.func_94057_bL());
        }
        this.checkOwnerName();
        tag.func_74778_a("owner", this.ownerName);
        tag.func_74768_a("attackDamageOverride", this.attackDamage);
        tag.func_74768_a("armorValueOverride", this.armorValue);
        tag.func_74778_a("customTex", this.customTexRef);
        tag.func_74757_a("aiEnabled", this.aiEnabled);
    }

    public final ResourceLocation getTexture() {
        if (this.currentTexture == null) {
            this.updateTexture();
        }
        return this.currentTexture == null ? this.getDefaultTexture() : this.currentTexture;
    }

    public final void updateTexture() {
        if (this.customTexRef.startsWith("Player:")) {
            try {
                this.currentTexture = AncientWarfareNPC.proxy.getPlayerSkin(this.customTexRef.split(":", 2)[1]);
            }
            catch (Throwable throwable) {}
        } else {
            this.currentTexture = NpcSkinManager.INSTANCE.getTextureFor(this);
        }
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        int id;
        EntityPlayer player;
        if (tag.func_74764_b("ownerName")) {
            this.setOwnerName(tag.func_74779_i("ownerName"));
            if (tag.func_74764_b("ownerId")) {
                this.ownerId = UUID.fromString(tag.func_74779_i("ownerId"));
                this.checkOwnerName();
            }
        } else if (tag.func_74764_b("profileTex") && tag.func_74764_b("customTex")) {
            this.customTexRef = tag.func_74779_i("customTex");
            NBTTagCompound tah = tag.func_74775_l("profileTex");
            if (this.field_70170_p.field_72995_K) {
                try {
                    AncientWarfareNPC.proxy.cacheProfile(NBTUtil.func_152459_a((NBTTagCompound)tah));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.updateTexture();
        } else if (tag.func_74764_b("customTex")) {
            this.setCustomTexRef(tag.func_74779_i("customTex"));
        } else if (tag.func_74764_b("pickEntity") && !this.field_70170_p.field_72995_K && (player = (EntityPlayer)this.field_70170_p.func_73045_a(id = tag.func_74775_l("pickEntity").func_74762_e("playerID"))) != null) {
            this.handlePickEntity(player);
        }
    }

    private void handlePickEntity(EntityPlayer player) {
        int i;
        ItemStack item = this.getItemToSpawn();
        for (i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
            if (!ItemStack.func_77989_b((ItemStack)player.field_71071_by.func_70301_a(i), (ItemStack)item)) continue;
            player.field_71071_by.field_70461_c = i;
            return;
        }
        if (player.func_70694_bm() != null) {
            for (i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
                if (player.field_71071_by.func_70301_a(i) != null) continue;
                player.field_71071_by.func_70299_a(i, item);
                return;
            }
        } else {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, item);
        }
    }

    public double getDistanceSq(BlockPosition pos) {
        return this.func_70092_e((double)pos.x + 0.5, pos.y, (double)pos.z + 0.5);
    }
}

