/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedRideHorse;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.IKeepFood;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.npc_command.NpcCommand;
import net.shadowmage.ancientwarfare.npc.orders.UpkeepOrder;
import net.shadowmage.ancientwarfare.npc.tile.TileTownHall;

public abstract class NpcPlayerOwned
extends NpcBase
implements IKeepFood {
    public boolean isAlarmed = false;
    private NpcCommand.Command playerIssuedCommand;
    private int foodValueRemaining = 0;
    protected NpcAIPlayerOwnedRideHorse horseAI;
    private BlockPosition townHallPosition;
    private BlockPosition upkeepAutoBlock;

    public NpcPlayerOwned(World par1World) {
        super(par1World);
    }

    @Override
    public final int func_82143_as() {
        return super.func_82143_as() - 1;
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.horseAI != null) {
                this.horseAI.onKilled();
            }
            this.validateTownHallPosition();
            TileTownHall townHall = this.getTownHall();
            if (townHall != null) {
                townHall.handleNpcDeath(this, source);
            }
        }
        super.func_70645_a(source);
    }

    @Override
    public final int getArmorValueOverride() {
        return -1;
    }

    @Override
    public final int getAttackDamageOverride() {
        return -1;
    }

    public void setTownHallPosition(BlockPosition pos) {
        this.townHallPosition = pos != null ? pos.copy() : null;
    }

    @Override
    public BlockPosition getTownHallPosition() {
        return this.townHallPosition;
    }

    public TileTownHall getTownHall() {
        TileEntity te;
        BlockPosition pos = this.getTownHallPosition();
        if (pos != null && (te = this.field_70170_p.func_147438_o(pos.x, pos.y, pos.z)) instanceof TileTownHall) {
            return (TileTownHall)te;
        }
        return null;
    }

    public void handleTownHallBroadcast(TileTownHall tile, BlockPosition position) {
        this.validateTownHallPosition();
        BlockPosition pos = this.getTownHallPosition();
        if (pos != null) {
            double curDist = this.func_70092_e((double)pos.x + 0.5, pos.y, (double)pos.z + 0.5);
            double newDist = this.func_70092_e((double)position.x + 0.5, position.y, (double)position.z + 0.5);
            if (newDist < curDist) {
                this.setTownHallPosition(position);
                if (this.upkeepAutoBlock == null || this.upkeepAutoBlock.equals(pos)) {
                    this.upkeepAutoBlock = position;
                }
            }
        } else {
            this.setTownHallPosition(position);
            if (this.upkeepAutoBlock == null) {
                this.upkeepAutoBlock = position;
            }
        }
        this.isAlarmed = this.getTownHall().alarmActive;
    }

    private boolean validateTownHallPosition() {
        BlockPosition pos = this.getTownHallPosition();
        if (pos == null) {
            return false;
        }
        if (!this.field_70170_p.func_72899_e(pos.x, pos.y, pos.z)) {
            return true;
        }
        TileEntity te = this.field_70170_p.func_147438_o(pos.x, pos.y, pos.z);
        if (te instanceof TileTownHall && this.canBeCommandedBy(((TileTownHall)te).getOwnerName())) {
            return true;
        }
        this.setTownHallPosition(null);
        return false;
    }

    public NpcCommand.Command getCurrentCommand() {
        return this.playerIssuedCommand;
    }

    public void handlePlayerCommand(NpcCommand.Command cmd) {
        if (cmd != null && cmd.type == NpcCommand.CommandType.ATTACK) {
            EntityLivingBase elb;
            Entity e = cmd.getEntityTarget(this.field_70170_p);
            AWLog.logDebug("Handling attack command : " + e);
            if (e instanceof EntityLivingBase && this.canTarget((Entity)(elb = (EntityLivingBase)e))) {
                this.func_70624_b(elb);
            }
            cmd = null;
        }
        this.setPlayerCommand(cmd);
    }

    public void setPlayerCommand(NpcCommand.Command cmd) {
        this.playerIssuedCommand = cmd;
    }

    @Override
    public boolean isHostileTowards(Entity e) {
        if (e instanceof NpcPlayerOwned) {
            NpcPlayerOwned npc = (NpcPlayerOwned)e;
            Team t = npc.func_96124_cp();
            return t != this.func_96124_cp();
        }
        if (e instanceof NpcFaction) {
            NpcFaction npc = (NpcFaction)e;
            return npc.isHostileTowards((Entity)this);
        }
        if (e instanceof EntityPlayer) {
            Team t = ((EntityPlayer)e).func_96124_cp();
            return t != this.func_96124_cp();
        }
        String n = EntityList.func_75621_b((Entity)e);
        List<String> targets = AncientWarfareNPC.statics.getValidTargetsFor(this.getNpcType(), this.getNpcSubType());
        return targets.contains(n);
    }

    @Override
    public boolean canTarget(Entity e) {
        if (e instanceof NpcPlayerOwned) {
            Team t = ((NpcPlayerOwned)e).func_96124_cp();
            return t != this.func_96124_cp();
        }
        if (e instanceof EntityPlayer) {
            Team t = ((EntityPlayer)e).func_96124_cp();
            return t != this.func_96124_cp();
        }
        return e instanceof EntityLivingBase;
    }

    @Override
    public boolean canBeAttackedBy(Entity e) {
        if (e instanceof NpcPlayerOwned) {
            return ((NpcPlayerOwned)e).func_96124_cp() != this.func_96124_cp();
        }
        return true;
    }

    protected boolean isHostileTowards(Team team) {
        Team a = this.func_96124_cp();
        return a != null && !a.func_142054_a(team);
    }

    @Override
    public void onWeaponInventoryChanged() {
        this.updateTexture();
    }

    @Override
    public int getFoodRemaining() {
        return this.foodValueRemaining;
    }

    @Override
    public void setFoodRemaining(int food) {
        this.foodValueRemaining = food;
    }

    @Override
    public BlockPosition getUpkeepPoint() {
        UpkeepOrder order = UpkeepOrder.getUpkeepOrder(this.upkeepStack);
        if (order != null) {
            return order.getUpkeepPosition();
        }
        return this.upkeepAutoBlock;
    }

    @Override
    public void setUpkeepAutoPosition(BlockPosition pos) {
        this.upkeepAutoBlock = pos;
    }

    @Override
    public int getUpkeepBlockSide() {
        UpkeepOrder order = UpkeepOrder.getUpkeepOrder(this.upkeepStack);
        if (order != null) {
            return order.getUpkeepBlockSide();
        }
        return 0;
    }

    @Override
    public int getUpkeepDimensionId() {
        UpkeepOrder order = UpkeepOrder.getUpkeepOrder(this.upkeepStack);
        if (order != null) {
            return order.getUpkeepDimension();
        }
        return this.field_70170_p.field_73011_w.field_76574_g;
    }

    @Override
    public int getUpkeepAmount() {
        UpkeepOrder order = UpkeepOrder.getUpkeepOrder(this.upkeepStack);
        if (order != null) {
            return order.getUpkeepAmount();
        }
        return AWNPCStatics.npcDefaultUpkeepWithdraw;
    }

    @Override
    protected boolean tryCommand(EntityPlayer player) {
        if (this.canBeCommandedBy(player.func_70005_c_()) && (this.func_96124_cp() == null || this.func_96124_cp().func_142054_a(player.func_96124_cp()))) {
            return super.tryCommand(player);
        }
        return false;
    }

    public boolean withdrawFood(IInventory inventory, int side) {
        int amount = this.getUpkeepAmount() - this.getFoodRemaining();
        if (amount <= 0) {
            return true;
        }
        int eaten = 0;
        if (side >= 0 && inventory instanceof ISidedInventory) {
            int[] ind;
            for (int i : ind = ((ISidedInventory)inventory).func_94128_d(side)) {
                ItemStack stack = inventory.func_70301_a(i);
                int val = AncientWarfareNPC.statics.getFoodValue(stack);
                if (val <= 0) continue;
                while (eaten < amount && stack.field_77994_a > 0) {
                    eaten += val;
                    --stack.field_77994_a;
                    inventory.func_70296_d();
                }
                if (stack.field_77994_a > 0) continue;
                inventory.func_70299_a(i, null);
            }
        } else {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                int val = AncientWarfareNPC.statics.getFoodValue(stack);
                if (val <= 0) continue;
                while (eaten < amount && stack.field_77994_a > 0) {
                    eaten += val;
                    --stack.field_77994_a;
                    inventory.func_70296_d();
                }
                if (stack.field_77994_a > 0) continue;
                inventory.func_70299_a(i, null);
            }
        }
        this.setFoodRemaining(this.getFoodRemaining() + eaten);
        return this.getFoodRemaining() >= this.getUpkeepAmount();
    }

    @Override
    protected boolean func_70085_c(EntityPlayer player) {
        int value;
        if (this.getFoodRemaining() < this.getUpkeepAmount() && (value = AncientWarfareNPC.statics.getFoodValue(player.func_70694_bm())) > 0) {
            if (!this.field_70170_p.field_72995_K) {
                --player.func_70694_bm().field_77994_a;
            }
            this.foodValueRemaining += value;
            return true;
        }
        return super.func_70085_c(player);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.foodValueRemaining > 0) {
            --this.foodValueRemaining;
        }
    }

    public void func_71027_c(int par1) {
        this.townHallPosition = null;
        this.upkeepAutoBlock = null;
        super.func_71027_c(par1);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.foodValueRemaining = tag.func_74762_e("foodValue");
        if (tag.func_74764_b("command")) {
            this.playerIssuedCommand = new NpcCommand.Command(tag.func_74775_l("command"));
        }
        if (tag.func_74764_b("townHall")) {
            this.townHallPosition = new BlockPosition(tag.func_74775_l("townHall"));
        }
        if (tag.func_74764_b("upkeepPos")) {
            this.upkeepAutoBlock = new BlockPosition(tag.func_74775_l("upkeepPos"));
        }
        this.onOrdersInventoryChanged();
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("foodValue", this.foodValueRemaining);
        if (this.playerIssuedCommand != null) {
            tag.func_74782_a("command", (NBTBase)this.playerIssuedCommand.writeToNBT(new NBTTagCompound()));
        }
        if (this.townHallPosition != null) {
            tag.func_74782_a("townHall", (NBTBase)this.townHallPosition.writeToNBT(new NBTTagCompound()));
        }
        if (this.upkeepAutoBlock != null) {
            tag.func_74782_a("upkeepPos", (NBTBase)this.upkeepAutoBlock.writeToNBT(new NBTTagCompound()));
        }
    }
}

