/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;

public final class RangeAttackHelper {
    public static final RangeAttackHelper DEFAULT = new RangeAttackHelper(1.6f, 14.0f);
    private final float speedFactor;
    private final float precisionFactor;
    private boolean difficultyBased = true;

    public RangeAttackHelper(float speed, float prec) {
        this.speedFactor = speed;
        this.precisionFactor = prec;
    }

    public void removeDifficulty() {
        this.difficultyBased = false;
    }

    public void doRangedAttack(EntityLivingBase attacker, EntityLivingBase target, float force) {
        int bonus;
        EntityArrow entityarrow = new EntityArrow(attacker.field_70170_p, attacker, target, this.speedFactor, this.getPrecisionFactor(attacker));
        entityarrow.func_70239_b((double)force * 2.0 + attacker.func_70681_au().nextGaussian() * 0.25);
        if (this.difficultyBased) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)attacker.field_70170_p.field_73013_u.func_151525_a() * 0.11);
        }
        if ((bonus = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)attacker.func_70694_bm())) > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)bonus * 0.5 + 0.5);
        }
        if ((bonus = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)attacker.func_70694_bm())) > 0) {
            entityarrow.func_70240_a(bonus);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)attacker.func_70694_bm()) > 0) {
            entityarrow.func_70015_d(100);
        }
        attacker.func_85030_a("random.bow", 1.0f, 1.0f / (attacker.func_70681_au().nextFloat() * 0.4f + 0.8f));
        attacker.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    public float getPrecisionFactor(EntityLivingBase attacker) {
        if (!this.difficultyBased) {
            return this.precisionFactor;
        }
        return this.precisionFactor - (float)(attacker.field_70170_p.field_73013_u.func_151525_a() * 4);
    }
}

