/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity.faction;

import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.faction.FactionTracker;

public abstract class NpcFaction
extends NpcBase {
    protected final IEntitySelector selector = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            return NpcFaction.this.isHostileTowards(entity);
        }
    };

    public NpcFaction(World par1World) {
        super(par1World);
        String type = this.getNpcFullType();
        for (int i = 0; i < 8; ++i) {
            ItemStack eqs = AncientWarfareNPC.statics.getStartingEquipmentForSlot(type, i);
            if (eqs == null) continue;
            this.func_70062_b(i, eqs);
        }
    }

    @Override
    public final int func_82143_as() {
        int i = super.func_82143_as();
        if (i > 4) {
            i = (int)((float)i + (float)this.field_70170_p.field_73013_u.func_151525_a() * this.func_110138_aP() / 5.0f);
        }
        if ((float)i >= this.func_110143_aJ()) {
            return (int)this.func_110143_aJ();
        }
        return i;
    }

    @Override
    protected boolean tryCommand(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d && super.tryCommand(player);
    }

    @Override
    public boolean canBeCommandedBy(String playerName) {
        return false;
    }

    @Override
    public boolean isHostileTowards(Entity e) {
        String t;
        if (e instanceof EntityPlayer) {
            int standing = FactionTracker.INSTANCE.getStandingFor(this.field_70170_p, e.func_70005_c_(), this.getFaction());
            if (this.getNpcFullType().endsWith("elite")) {
                standing -= 50;
            }
            return standing < 0;
        }
        if (e instanceof NpcPlayerOwned) {
            NpcBase npc = (NpcBase)e;
            int standing = FactionTracker.INSTANCE.getStandingFor(this.field_70170_p, npc.getOwnerName(), this.getFaction());
            if (this.getNpcFullType().endsWith("elite")) {
                standing -= 50;
            }
            return standing < 0;
        }
        if (e instanceof NpcFaction) {
            NpcFaction npc = (NpcFaction)e;
            return AncientWarfareNPC.statics.shouldFactionBeHostileTowards(this.getFaction(), npc.getFaction());
        }
        List<String> targets = AncientWarfareNPC.statics.getValidTargetsFor(this.getNpcFullType(), "");
        return targets.contains(t = EntityList.func_75621_b((Entity)e));
    }

    @Override
    public boolean canTarget(Entity e) {
        if (e instanceof NpcFaction) {
            return !((NpcFaction)e).getFaction().equals(this.getFaction());
        }
        return e instanceof EntityLivingBase;
    }

    @Override
    public boolean canBeAttackedBy(Entity e) {
        if (e instanceof NpcFaction) {
            return !this.getFaction().equals(((NpcFaction)e).getFaction());
        }
        return true;
    }

    public void func_70645_a(DamageSource damageSource) {
        String playerName;
        super.func_70645_a(damageSource);
        if (damageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)damageSource.func_76346_g();
            FactionTracker.INSTANCE.adjustStandingFor(this.field_70170_p, player.func_70005_c_(), this.getFaction(), -AWNPCStatics.factionLossOnDeath);
        } else if (damageSource.func_76346_g() instanceof NpcPlayerOwned && (playerName = ((NpcBase)damageSource.func_76346_g()).getOwnerName()) != null) {
            FactionTracker.INSTANCE.adjustStandingFor(this.field_70170_p, playerName, this.getFaction(), -AWNPCStatics.factionLossOnDeath);
        }
    }

    @Override
    public String getNpcSubType() {
        return "";
    }

    public String getFaction() {
        String type = this.getNpcType();
        return type.substring(0, type.indexOf("."));
    }
}

