/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Line;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.SongPlayData;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcBard;
import net.shadowmage.ancientwarfare.npc.entity.NpcBard;

public class GuiNpcBard
extends GuiContainerBase<ContainerNpcBard> {
    private CompositeScrolled area;

    public GuiNpcBard(ContainerBase container) {
        super(container);
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void setupElements() {
        this.clearElements();
        this.area.clearElements();
        this.addGuiElement(this.area);
        int totalHeight = 8;
        final SongPlayData data = ((ContainerNpcBard)((Object)this.getContainer())).data;
        Checkbox playerEntry = new Checkbox(8, totalHeight, 16, 16, "guistrings.play_on_player_entry"){

            @Override
            public void onToggled() {
                data.setPlayOnPlayerEntry(this.checked());
            }
        };
        playerEntry.setChecked(data.getPlayOnPlayerEntry());
        this.area.addGuiElement(playerEntry);
        Checkbox random = new Checkbox(8, totalHeight += 16, 16, 16, "guistrings.random"){

            @Override
            public void onToggled() {
                data.setRandom(this.checked());
            }
        };
        random.setChecked(data.getIsRandom());
        this.area.addGuiElement(random);
        NumberInput minDelay = new NumberInput(88, totalHeight += 16, 55, data.getMinDelay(), this){

            @Override
            public void onValueUpdated(float value) {
                data.setMinDelay((int)value);
            }
        };
        minDelay.setIntegerValue();
        this.area.addGuiElement(minDelay);
        this.area.addGuiElement(new Label(8, totalHeight + 1, "guistrings.min_delay"));
        NumberInput maxDelay = new NumberInput(88, totalHeight += 12, 55, data.getMaxDelay(), this){

            @Override
            public void onValueUpdated(float value) {
                data.setMaxDelay((int)value);
            }
        };
        maxDelay.setIntegerValue();
        this.area.addGuiElement(maxDelay);
        this.area.addGuiElement(new Label(8, totalHeight + 1, "guistrings.max_delay"));
        this.area.addGuiElement(new Line(0, (totalHeight += 12) + 2, this.field_146999_f, totalHeight + 2, 1, 255));
        totalHeight += 5;
        totalHeight = this.addTuneEntries(data, totalHeight);
        Button newTuneButton = new Button(8, totalHeight, 120, 12, "guistrings.new_tune"){

            @Override
            protected void onPressed() {
                data.addNewEntry();
                GuiNpcBard.this.refreshGui();
            }
        };
        this.area.addGuiElement(newTuneButton);
        this.area.setAreaSize(totalHeight += 12);
    }

    private int addTuneEntries(SongPlayData data, int startHeight) {
        for (int i = 0; i < data.size(); ++i) {
            startHeight = this.addTuneEntry(data.get(i), i, startHeight);
        }
        return startHeight;
    }

    private int addTuneEntry(final SongPlayData.SongEntry entry, final int index, int startHeight) {
        int y = startHeight;
        Text input = new Text(8, startHeight, 120, entry.name(), this){

            @Override
            public void onTextUpdated(String oldText, String newText) {
                super.onTextUpdated(oldText, newText);
                entry.setName(newText);
            }
        };
        this.area.addGuiElement(input);
        this.area.addGuiElement(new Label(8, (startHeight += 12) + 1, "guistrings.length"));
        NumberInput length = new NumberInput(88, startHeight, 60, entry.length(), this){

            @Override
            public void onValueUpdated(float value) {
                entry.setLength(value);
            }
        };
        this.area.addGuiElement(length);
        this.area.addGuiElement(new Label(8, (startHeight += 12) + 1, "guistrings.volume"));
        NumberInput volume = new NumberInput(88, startHeight, 60, entry.volume(), this){

            @Override
            public void onValueUpdated(float value) {
                entry.setVolume((int)value);
            }
        };
        this.area.addGuiElement(volume);
        this.area.addGuiElement(new Button(160, y, 55, 12, "guistrings.up"){

            @Override
            protected void onPressed() {
                SongPlayData data = ((ContainerNpcBard)((Object)GuiNpcBard.this.getContainer())).data;
                data.decrementEntry(index);
                GuiNpcBard.this.refreshGui();
            }
        });
        this.area.addGuiElement(new Button(160, y + 12, 55, 12, "guistrings.delete"){

            @Override
            protected void onPressed() {
                SongPlayData data = ((ContainerNpcBard)((Object)GuiNpcBard.this.getContainer())).data;
                data.deleteEntry(index);
                GuiNpcBard.this.refreshGui();
            }
        });
        this.area.addGuiElement(new Button(160, y + 24, 55, 12, "guistrings.down"){

            @Override
            protected void onPressed() {
                SongPlayData data = ((ContainerNpcBard)((Object)GuiNpcBard.this.getContainer())).data;
                data.incrementEntry(index);
                GuiNpcBard.this.refreshGui();
            }
        });
        this.area.addGuiElement(new Line(0, (startHeight += 12) + 2, this.field_146999_f, startHeight + 2, 1, 255));
        return startHeight += 5;
    }

    @Override
    protected boolean onGuiCloseRequested() {
        ((ContainerNpcBard)((Object)this.getContainer())).sendTuneDataToServer();
        NetworkHandler.INSTANCE.openGui(this.player, 4, ((NpcBard)((ContainerNpcBard)((Object)this.getContainer())).entity).func_145782_y(), 0, 0);
        return false;
    }
}

