/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.npc.container.ContainerUpkeepOrder;

public class GuiUpkeepOrder
extends GuiContainerBase<ContainerUpkeepOrder> {
    private boolean hasChanged = false;

    public GuiUpkeepOrder(ContainerBase container) {
        super(container, 246, 38);
    }

    @Override
    public void initElements() {
    }

    @Override
    public void setupElements() {
        this.clearElements();
        BlockPosition pos = ((ContainerUpkeepOrder)((Object)this.getContainer())).upkeepOrder.getUpkeepPosition();
        if (pos != null) {
            ItemStack blockStack = new ItemStack(((ContainerUpkeepOrder)((Object)this.getContainer())).upkeepOrder.getBlock());
            ItemSlot slot = new ItemSlot(8, 10, blockStack, this);
            this.addGuiElement(slot);
            Label label = new Label(30, 8, pos.toString());
            this.addGuiElement(label);
            Button button = new Button(36, 18, 55, 12, "guistrings.npc.remove_upkeep_point"){

                @Override
                protected void onPressed() {
                    ((ContainerUpkeepOrder)((Object)GuiUpkeepOrder.this.getContainer())).upkeepOrder.removeUpkeepPoint();
                    GuiUpkeepOrder.this.hasChanged = true;
                    GuiUpkeepOrder.this.refreshGui();
                }
            };
            this.addGuiElement(button);
            button = new Button(101, 18, 55, 12, this.getSideName(((ContainerUpkeepOrder)((Object)this.getContainer())).upkeepOrder.getUpkeepBlockSide())){

                @Override
                protected void onPressed() {
                    ((ContainerUpkeepOrder)((Object)GuiUpkeepOrder.this.getContainer())).upkeepOrder.changeBlockSide();
                    this.setText(GuiUpkeepOrder.this.getSideName(((ContainerUpkeepOrder)((Object)GuiUpkeepOrder.this.getContainer())).upkeepOrder.getUpkeepBlockSide()));
                    GuiUpkeepOrder.this.hasChanged = true;
                    GuiUpkeepOrder.this.refreshGui();
                }
            };
            this.addGuiElement(button);
            label = new Label(166, 8, "guistrings.npc.upkeep_time");
            this.addGuiElement(label);
            NumberInput input = new NumberInput(166, 18, 60, (float)((ContainerUpkeepOrder)((Object)this.getContainer())).upkeepOrder.getUpkeepAmount() / 1200.0f, this){

                @Override
                public void onValueUpdated(float value) {
                    float val = value * 1200.0f;
                    ((ContainerUpkeepOrder)((Object)GuiUpkeepOrder.this.getContainer())).upkeepOrder.setUpkeepAmount((int)val);
                    GuiUpkeepOrder.this.hasChanged = true;
                }
            };
            this.addGuiElement(input);
        } else {
            Label label = new Label(8, 8, "guistrings.npc.assign_upkeep_point");
            this.addGuiElement(label);
        }
    }

    private String getSideName(int side) {
        switch (side) {
            case 0: {
                return "guistrings.inventory.direction.down";
            }
            case 1: {
                return "guistrings.inventory.direction.up";
            }
            case 2: {
                return "guistrings.inventory.direction.north";
            }
            case 3: {
                return "guistrings.inventory.direction.south";
            }
            case 4: {
                return "guistrings.inventory.direction.west";
            }
            case 5: {
                return "guistrings.inventory.direction.east";
            }
        }
        return "";
    }

    @Override
    protected boolean onGuiCloseRequested() {
        if (this.hasChanged) {
            ((ContainerUpkeepOrder)((Object)this.getContainer())).onClose();
        }
        return super.onGuiCloseRequested();
    }
}

