/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.item;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.util.RayTraceUtils;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.item.AWNpcItemLoader;
import net.shadowmage.ancientwarfare.npc.npc_command.NpcCommand;

public class ItemCommandBaton
extends Item
implements IItemKeyInterface {
    private final double attackDamage;
    int range = 120;
    private final Item.ToolMaterial material;

    public ItemCommandBaton(String name, Item.ToolMaterial material) {
        this.func_77655_b(name);
        this.func_77637_a(AWNpcItemLoader.npcTab);
        this.func_111206_d("ancientwarfare:npc/" + name);
        this.attackDamage = 4.0f + material.func_78000_c();
        this.material = material;
        this.func_77625_d(1);
        this.func_77656_e(material.func_77997_a());
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        String text = "RMB = " + StatCollector.func_74838_a((String)"guistrings.npc.baton.add_remove");
        list.add(text);
        String keyText = InputHandler.instance.getKeybindBinding("keybind.alt_item_use_1");
        text = keyText + " = " + StatCollector.func_74838_a((String)"guistrings.npc.baton.clear");
        list.add(text);
        keyText = InputHandler.instance.getKeybindBinding("keybind.alt_item_use_2");
        text = keyText + " = " + StatCollector.func_74838_a((String)"guistrings.npc.baton.attack");
        list.add(text);
        keyText = InputHandler.instance.getKeybindBinding("keybind.alt_item_use_3");
        text = keyText + " = " + StatCollector.func_74838_a((String)"guistrings.npc.baton.move");
        list.add(text);
        keyText = InputHandler.instance.getKeybindBinding("keybind.alt_item_use_4");
        text = keyText + " = " + StatCollector.func_74838_a((String)"guistrings.npc.baton.home");
        list.add(text);
        keyText = InputHandler.instance.getKeybindBinding("keybind.alt_item_use_5");
        text = keyText + " = " + StatCollector.func_74838_a((String)"guistrings.npc.baton.upkeep");
        list.add(text);
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return this.material.func_150995_f() == par2ItemStack.func_77973_b();
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase attacked, EntityLivingBase wielder) {
        stack.func_77972_a(1, wielder);
        return true;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase wielder) {
        if (block.func_149712_f(world, x, y, z) != 0.0f) {
            stack.func_77972_a(2, wielder);
        }
        return true;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.attackDamage, 0));
        return multimap;
    }

    public boolean func_77662_d() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NpcBase npc;
        MovingObjectPosition pos;
        if (world.field_72995_K) {
            return stack;
        }
        if (!player.func_70093_af() && (pos = RayTraceUtils.getPlayerTarget(player, this.range, 0.0f)) != null && pos.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && pos.field_72308_g instanceof NpcBase && (npc = (NpcBase)pos.field_72308_g).canBeCommandedBy(player.func_70005_c_())) {
            this.onNpcClicked(player, npc, stack);
        }
        return stack;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        switch (key) {
            case KEY_0: {
                MovingObjectPosition hit = new MovingObjectPosition((Entity)player);
                NpcCommand.handleCommandClient(NpcCommand.CommandType.CLEAR_COMMAND, hit);
                break;
            }
            case KEY_1: {
                MovingObjectPosition hit = RayTraceUtils.getPlayerTarget(player, this.range, 0.0f);
                if (hit == null) break;
                NpcCommand.CommandType c = hit.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY ? NpcCommand.CommandType.ATTACK : NpcCommand.CommandType.ATTACK_AREA;
                NpcCommand.handleCommandClient(c, hit);
                break;
            }
            case KEY_2: {
                MovingObjectPosition hit = RayTraceUtils.getPlayerTarget(player, this.range, 0.0f);
                if (hit == null) break;
                NpcCommand.CommandType c = hit.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY ? NpcCommand.CommandType.GUARD : NpcCommand.CommandType.MOVE;
                NpcCommand.handleCommandClient(c, hit);
                break;
            }
            case KEY_3: {
                MovingObjectPosition hit = RayTraceUtils.getPlayerTarget(player, this.range, 0.0f);
                if (hit == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) break;
                NpcCommand.CommandType c = player.func_70093_af() ? NpcCommand.CommandType.CLEAR_HOME : NpcCommand.CommandType.SET_HOME;
                NpcCommand.handleCommandClient(c, hit);
                break;
            }
            case KEY_4: {
                MovingObjectPosition hit = RayTraceUtils.getPlayerTarget(player, this.range, 0.0f);
                if (hit == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) break;
                NpcCommand.CommandType c = player.func_70093_af() ? NpcCommand.CommandType.CLEAR_UPKEEP : NpcCommand.CommandType.SET_UPKEEP;
                NpcCommand.handleCommandClient(c, hit);
            }
        }
        return false;
    }

    private void onNpcClicked(EntityPlayer player, NpcBase npc, ItemStack stack) {
        if (player == null || npc == null || stack == null || stack.func_77973_b() != this) {
            return;
        }
        CommandSet.loadFromStack(stack).onNpcClicked(npc, stack);
    }

    public static List<Entity> getCommandedEntities(World world, ItemStack stack) {
        if (world == null || stack == null || !(stack.func_77973_b() instanceof ItemCommandBaton)) {
            return new ArrayList<Entity>();
        }
        return CommandSet.loadFromStack(stack).getEntities(world);
    }

    private static class CommandSet {
        private Set<UUID> ids = new HashSet<UUID>();

        private CommandSet() {
        }

        public static CommandSet loadFromStack(ItemStack stack) {
            CommandSet set = new CommandSet();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("entityList")) {
                set.readFromNBT(stack.func_77978_p().func_74775_l("entityList"));
            }
            return set;
        }

        private void writeToStack(ItemStack stack) {
            stack.func_77983_a("entityList", (NBTBase)this.writeToNBT());
        }

        private void readFromNBT(NBTTagCompound tag) {
            NBTTagList entryList = tag.func_150295_c("entryList", 10);
            for (int i = 0; i < entryList.func_74745_c(); ++i) {
                NBTTagCompound idTag = entryList.func_150305_b(i);
                this.ids.add(new UUID(idTag.func_74763_f("idmsb"), idTag.func_74763_f("idlsb")));
            }
        }

        private NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList entryList = new NBTTagList();
            for (UUID id : this.ids) {
                NBTTagCompound idTag = new NBTTagCompound();
                idTag.func_74772_a("idmsb", id.getMostSignificantBits());
                idTag.func_74772_a("idlsb", id.getLeastSignificantBits());
                entryList.func_74742_a((NBTBase)idTag);
            }
            tag.func_74782_a("entryList", (NBTBase)entryList);
            return tag;
        }

        public void onNpcClicked(NpcBase npc, ItemStack stack) {
            if (this.ids.contains(npc.getPersistentID())) {
                this.ids.remove(npc.getPersistentID());
            } else {
                this.ids.add(npc.getPersistentID());
            }
            this.validateEntities(npc.field_70170_p);
            this.writeToStack(stack);
        }

        public List<Entity> getEntities(World world) {
            ArrayList<Entity> in = new ArrayList<Entity>();
            for (UUID id : this.ids) {
                Entity e = WorldTools.getEntityByUUID(world, id);
                if (e == null) continue;
                in.add(e);
            }
            return in;
        }

        private void validateEntities(World world) {
            Iterator<UUID> it = this.ids.iterator();
            while (it.hasNext()) {
                UUID id = it.next();
                if (id != null && WorldTools.getEntityByUUID(world, id) != null) continue;
                it.remove();
            }
        }
    }
}

