/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.orders;

import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.core.interfaces.INBTSerialable;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.OrderingList;
import net.shadowmage.ancientwarfare.npc.item.ItemRoutingOrder;

public class RoutingOrder
extends OrderingList<RoutePoint>
implements INBTSerialable {
    int routeDimension;

    public void addRoutePoint(int side, int x, int y, int z) {
        this.add(new RoutePoint(side, x, y, z));
    }

    private boolean check(int index) {
        return index >= 0 && index < this.size();
    }

    public void changeRouteType(int index) {
        if (this.check(index)) {
            ((RoutePoint)this.get(index)).changeRouteType();
        }
    }

    public void changeBlockSide(int index) {
        if (this.check(index)) {
            ((RoutePoint)this.get(index)).changeBlockSide();
        }
    }

    public void toggleIgnoreDamage(int index) {
        if (this.check(index)) {
            ((RoutePoint)this.get(index)).toggleIgnoreDamage();
        }
    }

    public void toggleIgnoreTag(int index) {
        if (this.check(index)) {
            ((RoutePoint)this.get(index)).toggleIgnoreTag();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.clear();
        NBTTagList entryList = tag.func_150295_c("entryList", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            this.add(new RoutePoint(entryList.func_150305_b(i)));
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (RoutePoint p : this.points) {
            list.func_74742_a((NBTBase)p.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("entryList", (NBTBase)list);
        return tag;
    }

    public static RoutingOrder getRoutingOrder(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemRoutingOrder) {
            RoutingOrder order = new RoutingOrder();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("orders")) {
                order.readFromNBT(stack.func_77978_p().func_74775_l("orders"));
            }
            return order;
        }
        return null;
    }

    public void write(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemRoutingOrder) {
            stack.func_77983_a("orders", (NBTBase)this.writeToNBT(new NBTTagCompound()));
        }
    }

    public int handleRouteAction(RoutePoint p, IInventory npc, IInventory target) {
        switch (p.routeType) {
            case FILL_COURIER_TO: {
                return p.fillTo(target, npc, true);
            }
            case FILL_TARGET_TO: {
                return p.fillTo(npc, target, false);
            }
            case DEPOSIT_ALL_EXCEPT: {
                return p.depositAllItemsExcept(npc, target, false);
            }
            case DEPOSIT_ALL_OF: {
                return p.depositAllItems(npc, target, false);
            }
            case WITHDRAW_ALL_EXCEPT: {
                return p.depositAllItemsExcept(target, npc, true);
            }
            case WITHDRAW_ALL_OF: {
                return p.depositAllItems(target, npc, true);
            }
        }
        return 0;
    }

    public List<RoutePoint> getEntries() {
        return this.points;
    }

    public static enum RouteType {
        FILL_TARGET_TO("route.fill.target"),
        FILL_COURIER_TO("route.fill.courier"),
        DEPOSIT_ALL_OF("route.deposit.match"),
        WITHDRAW_ALL_OF("route.withdraw.match"),
        DEPOSIT_ALL_EXCEPT("route.deposit.no_match"),
        WITHDRAW_ALL_EXCEPT("route.withdraw.no_match");

        final String key;

        private RouteType(String key) {
            this.key = key;
        }

        public String getTranslationKey() {
            return this.key;
        }

        public static RouteType next(RouteType type) {
            return type == null ? FILL_TARGET_TO : type.next();
        }

        public RouteType next() {
            int ordinal = this.ordinal() + 1;
            if (ordinal >= RouteType.values().length) {
                ordinal = 0;
            }
            return RouteType.values()[ordinal];
        }
    }

    public static class RoutePoint {
        boolean ignoreDamage;
        boolean ignoreTag;
        RouteType routeType = RouteType.FILL_TARGET_TO;
        BlockPosition target = new BlockPosition();
        int blockSide = 0;
        ItemStack[] filters = new ItemStack[8];

        private RoutePoint(NBTTagCompound tag) {
            this.readFromNBT(tag);
        }

        public RoutePoint(int side, int x, int y, int z) {
            this.target = new BlockPosition(x, y, z);
            this.blockSide = side;
        }

        private void changeBlockSide() {
            this.blockSide = this.blockSide == 5 ? 0 : this.blockSide + 1;
        }

        private void changeRouteType() {
            this.routeType = this.routeType.next();
        }

        public void setFilter(int index, ItemStack stack) {
            this.filters[index] = stack;
        }

        public int getBlockSide() {
            return this.blockSide;
        }

        public RouteType getRouteType() {
            return this.routeType;
        }

        public BlockPosition getTarget() {
            return this.target;
        }

        public ItemStack getFilterInSlot(int slot) {
            return this.filters[slot];
        }

        public int getFilterSize() {
            return this.filters.length;
        }

        public boolean getIgnoreDamage() {
            return this.ignoreDamage;
        }

        public boolean getIgnoreTag() {
            return this.ignoreTag;
        }

        public void toggleIgnoreDamage() {
            this.ignoreDamage = !this.ignoreDamage;
        }

        public void toggleIgnoreTag() {
            this.ignoreTag = !this.ignoreTag;
        }

        private int depositAllItems(IInventory from, IInventory to, boolean reversed) {
            int[] fromIndices;
            int fromSide = -1;
            int toSide = this.getBlockSide();
            if (reversed) {
                fromSide = this.getBlockSide();
                toSide = -1;
            }
            int moved = 0;
            int stackSize = 0;
            for (int index : fromIndices = InventoryTools.getSlotsForSide(from, fromSide)) {
                ItemStack stack = from.func_70301_a(index);
                if (stack == null) continue;
                boolean shouldMove = false;
                stackSize = stack.field_77994_a;
                for (ItemStack filter : this.filters) {
                    if (filter == null || !InventoryTools.doItemStacksMatch(stack, filter, this.ignoreDamage, this.ignoreTag)) continue;
                    shouldMove = true;
                    break;
                }
                if (shouldMove && (stack = InventoryTools.mergeItemStack(to, stack, toSide)) == null) {
                    from.func_70299_a(index, null);
                }
                if (stack != null && stack.field_77994_a == stackSize) continue;
                ++moved;
                from.func_70296_d();
            }
            return moved;
        }

        private int depositAllItemsExcept(IInventory from, IInventory to, boolean reversed) {
            int[] fromIndices;
            int fromSide = -1;
            int toSide = this.getBlockSide();
            if (reversed) {
                fromSide = this.getBlockSide();
                toSide = -1;
            }
            int moved = 0;
            int stackSize = 0;
            for (int index : fromIndices = InventoryTools.getSlotsForSide(from, fromSide)) {
                ItemStack stack = from.func_70301_a(index);
                if (stack == null) continue;
                boolean shouldMove = true;
                stackSize = stack.field_77994_a;
                for (ItemStack filter : this.filters) {
                    if (filter == null || !InventoryTools.doItemStacksMatch(stack, filter, this.ignoreDamage, this.ignoreTag)) continue;
                    shouldMove = false;
                    break;
                }
                if (shouldMove && (stack = InventoryTools.mergeItemStack(to, stack, toSide)) == null) {
                    from.func_70299_a(index, null);
                }
                if (stack != null && stack.field_77994_a == stackSize) continue;
                ++moved;
                from.func_70296_d();
            }
            return moved;
        }

        private int fillTo(IInventory from, IInventory to, boolean reversed) {
            int fromSide = -1;
            int toSide = this.getBlockSide();
            if (reversed) {
                fromSide = this.getBlockSide();
                toSide = -1;
            }
            int moved = 0;
            int toMove = 0;
            int foundCount = 0;
            for (ItemStack filter : this.filters) {
                if (filter == null || (foundCount = InventoryTools.getCountOf(to, toSide, filter)) > (toMove = filter.field_77994_a)) continue;
                int m1 = InventoryTools.transferItems(from, to, filter, toMove -= foundCount, fromSide, toSide, this.ignoreDamage, this.ignoreTag);
                moved += m1 / filter.func_77976_d();
            }
            return moved;
        }

        private final void readFromNBT(NBTTagCompound tag) {
            this.routeType = RouteType.values()[tag.func_74762_e("type")];
            this.target = new BlockPosition(tag.func_74775_l("position"));
            this.blockSide = tag.func_74762_e("blockSide");
            this.ignoreDamage = tag.func_74767_n("ignoreDamage");
            this.ignoreTag = tag.func_74767_n("ignoreTag");
            NBTTagList filterList = tag.func_150295_c("filterList", 10);
            for (int i = 0; i < filterList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = filterList.func_150305_b(i);
                int slot = itemTag.func_74762_e("slot");
                if (slot >= this.filters.length) {
                    ItemStack[] temp = new ItemStack[slot + 1];
                    System.arraycopy(this.filters, 0, temp, 0, this.filters.length);
                    this.filters = temp;
                }
                this.filters[slot] = InventoryTools.readItemStack(itemTag);
            }
        }

        private final NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("type", this.routeType.ordinal());
            tag.func_74782_a("position", (NBTBase)this.target.writeToNBT(new NBTTagCompound()));
            tag.func_74768_a("blockSide", this.blockSide);
            tag.func_74757_a("ignoreDamage", this.ignoreDamage);
            tag.func_74757_a("ignoreTag", this.ignoreTag);
            NBTTagList filterList = new NBTTagList();
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i] == null) continue;
                NBTTagCompound itemTag = InventoryTools.writeItemStack(this.filters[i]);
                itemTag.func_74768_a("slot", i);
                filterList.func_74742_a((NBTBase)itemTag);
            }
            tag.func_74782_a("filterList", (NBTBase)filterList);
            return tag;
        }
    }
}

